/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.imc.IMCCentrifuge;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBedrockOre;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.items.special.ItemByproduct;
import com.hbm.main.MainRegistry;
import com.hbm.util.ItemStackUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CentrifugeRecipes
extends SerializableRecipe {
    public static HashMap<RecipesCommon.AStack, ItemStack[]> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        boolean lbs = GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleCentrifuge;
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.RARE)), new ItemStack[]{new ItemStack(ModItems.powder_cobalt_tiny, 2), new ItemStack(ModItems.powder_boron_tiny, 2), new ItemStack(ModItems.powder_niobium_tiny, 2), new ItemStack(ModItems.nugget_zirconium, 3)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.COAL.ore()), new ItemStack[]{new ItemStack(ModItems.powder_coal, 2), new ItemStack(ModItems.powder_coal, 2), new ItemStack(ModItems.powder_coal, 2), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LIGNITE.ore()), new ItemStack[]{new ItemStack(ModItems.powder_lignite, 2), new ItemStack(ModItems.powder_lignite, 2), new ItemStack(ModItems.powder_lignite, 2), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.IRON.ore()), new ItemStack[]{new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.NI.ore()), new ItemStack[]{new ItemStack(ModItems.chunk_ore, 2, ItemEnums.EnumChunkType.PENTLANDITE.ordinal()), new ItemStack(ModItems.sulfur, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.GOLD.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_gold, 2) : new ItemStack(ModItems.powder_gold, 1), new ItemStack(ModItems.powder_gold, 1), lbs ? new ItemStack(ModItems.nugget_bismuth, 1) : new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.ore()), new ItemStack[]{new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.EMERALD.ore()), new ItemStack[]{new ItemStack(ModItems.powder_emerald, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.TI.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_titanium, 2) : new ItemStack(ModItems.powder_titanium, 1), lbs ? new ItemStack(ModItems.powder_titanium, 2) : new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.ore()), new ItemStack[]{new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_lithium_tiny, 1), new ItemStack(Blocks.field_150424_aL, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.W.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_tungsten, 2) : new ItemStack(ModItems.powder_tungsten, 1), new ItemStack(ModItems.powder_tungsten, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.CU.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_copper, 2) : new ItemStack(ModItems.powder_copper, 1), new ItemStack(ModItems.powder_copper, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.AL.ore()), new ItemStack[]{new ItemStack(ModItems.chunk_ore, 2, ItemEnums.EnumChunkType.CRYOLITE.ordinal()), new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.PB.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_lead, 2) : new ItemStack(ModItems.powder_lead, 1), lbs ? new ItemStack(ModItems.nugget_bismuth, 1) : new ItemStack(ModItems.powder_lead, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.SA326.ore()), new ItemStack[]{new ItemStack(ModItems.powder_schrabidium, 1), new ItemStack(ModItems.powder_schrabidium, 1), new ItemStack(ModItems.nugget_solinium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack("oreRareEarth"), new ItemStack[]{new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.nugget_zirconium, 1), new ItemStack(ModItems.nugget_zirconium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.PU.ore()), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.nugget_polonium, 3), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.U.ore()), new ItemStack[]{lbs ? new ItemStack(ModItems.powder_uranium, 2) : new ItemStack(ModItems.powder_uranium, 1), lbs ? new ItemStack(ModItems.nugget_technetium, 2) : new ItemStack(ModItems.powder_uranium, 1), lbs ? new ItemStack(ModItems.nugget_ra226, 2) : new ItemStack(ModItems.nugget_ra226, 1), new ItemStack(Blocks.field_150351_n, 1)});
        for (String string : OreDictManager.TH232.all(MaterialShapes.ORE)) {
            recipes.put(new RecipesCommon.OreDictStack(string), new ItemStack[]{new ItemStack(ModItems.powder_thorium, 1), new ItemStack(ModItems.powder_thorium, 1), new ItemStack(ModItems.powder_uranium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        }
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.BE.ore()), new ItemStack[]{new ItemStack(ModItems.powder_beryllium, 1), new ItemStack(ModItems.powder_beryllium, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.F.ore()), new ItemStack[]{new ItemStack(ModItems.fluorite, 3), new ItemStack(ModItems.fluorite, 3), new ItemStack(ModItems.gem_sodalite, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.ore()), new ItemStack[]{new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), lbs ? new ItemStack(ModItems.ingot_mercury, 3) : new ItemStack(ModItems.ingot_mercury, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.ore_tikite), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_niobium, 2), new ItemStack(Blocks.field_150377_bs, 1)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LAPIS.ore()), new ItemStack[]{new ItemStack(ModItems.powder_lapis, 6), new ItemStack(ModItems.powder_cobalt_tiny, 1), new ItemStack(ModItems.gem_sodalite, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.block_euphemium_cluster), new ItemStack[]{new ItemStack(ModItems.nugget_euphemium, 7), new ItemStack(ModItems.powder_schrabidium, 4), new ItemStack(ModItems.ingot_starmetal, 2), new ItemStack(ModItems.nugget_solinium, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.ore_nether_fire), new ItemStack[]{new ItemStack(Items.field_151065_br, 2), new ItemStack(ModItems.powder_fire, 2), new ItemStack(ModItems.ingot_phosphorus), new ItemStack(Blocks.field_150424_aL)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.P_RED.ore()), new ItemStack[]{new ItemStack(Items.field_151065_br, 2), new ItemStack(ModItems.powder_fire, 2), new ItemStack(ModItems.ingot_phosphorus), new ItemStack(Blocks.field_150351_n)});
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.CO.ore()), new ItemStack[]{new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_copper, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.powder_tektite), new ItemStack[]{new ItemStack(ModItems.powder_meteorite_tiny, 1), new ItemStack(ModItems.powder_paleogenite_tiny, 1), new ItemStack(ModItems.powder_meteorite_tiny, 1), new ItemStack(ModItems.dust, 6)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.block_slag), new ItemStack[]{new ItemStack(Blocks.field_150351_n, 1), new ItemStack(ModItems.powder_fire, 1), new ItemStack(ModItems.powder_calcium), new ItemStack(ModItems.dust)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 0), new ItemStack[]{new ItemStack(ModItems.powder_niobium, 4), new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_zirconium, 1), new ItemStack(ModItems.powder_beryllium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 1), new ItemStack[]{new ItemStack(ModItems.powder_gallium, 4), new ItemStack(ModItems.powder_beryllium, 2), new ItemStack(ModItems.powder_niobium, 1), new ItemStack(ModItems.fragment_lanthanium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 2), new ItemStack[]{new ItemStack(ModItems.powder_beryllium, 4), new ItemStack(ModItems.powder_niobium, 2), new ItemStack(ModItems.powder_gallium, 1), new ItemStack(ModItems.fragment_lanthanium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 3), new ItemStack[]{new ItemStack(ModItems.powder_cobalt, 4), new ItemStack(ModItems.powder_gallium, 2), new ItemStack(ModItems.powder_niobium, 1), new ItemStack(ModItems.powder_coltan, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 4), new ItemStack[]{new ItemStack(ModItems.powder_zirconium, 4), new ItemStack(ModItems.powder_neodymium, 2), new ItemStack(ModItems.powder_niobium, 1), new ItemStack(ModItems.powder_cobalt, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.mineral_fragment, 1, 5), new ItemStack[]{new ItemStack(ModItems.powder_co60, 1), new ItemStack(ModItems.nugget_bismuth, 1), new ItemStack(ModItems.powder_asbestos, 6), new ItemStack(ModItems.nugget_technetium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.powder_ash, 1, ItemEnums.EnumAshType.COAL.ordinal()), new ItemStack[]{new ItemStack(ModItems.powder_coal_tiny, 2), new ItemStack(ModItems.powder_boron_tiny, 1), new ItemStack(ModItems.dust_tiny, 6)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.ferric_clay, 1), new ItemStack[]{new ItemStack(Items.field_151119_aD, 1), new ItemStack(Items.field_151119_aD, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_iron, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.ingot_magma, 1), new ItemStack[]{Mats.MAT_GALLIUM.make(ModItems.bedrock_ore_fragment, 4), Mats.MAT_ARSENIC.make(ModItems.bedrock_ore_fragment, 2), new ItemStack(ModItems.powder_meteorite_tiny, 2), new ItemStack(ModItems.dust_tiny, 3)});
        for (String string : ItemBedrockOre.EnumBedrockOre.values()) {
            int i = ((Enum)((Object)string)).ordinal();
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_centrifuged, 1, i), new ItemStack(ModItems.ore_centrifuged, 1, i), new ItemStack(ModItems.ore_centrifuged, 1, i), new ItemStack(ModItems.ore_centrifuged, 1, i)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_cleaned, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_separated, 1, i), new ItemStack(ModItems.ore_separated, 1, i), new ItemStack(ModItems.ore_separated, 1, i), new ItemStack(ModItems.ore_separated, 1, i)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_purified, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_enriched, 1, i), new ItemStack(ModItems.ore_enriched, 1, i), new ItemStack(ModItems.ore_enriched, 1, i), new ItemStack(ModItems.ore_enriched, 1, i)});
            ItemByproduct.EnumByproduct tier1 = ((ItemBedrockOre.EnumBedrockOre)((Object)string)).byproducts[0];
            ItemStack by1 = tier1 == null ? new ItemStack(ModItems.dust) : OreDictManager.DictFrame.fromOne(ModItems.ore_byproduct, (Enum)tier1, 1);
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_nitrated, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_nitrocrystalline, 1, i), new ItemStack(ModItems.ore_nitrocrystalline, 1, i), ItemStackUtil.carefulCopy(by1), ItemStackUtil.carefulCopy(by1)});
            ItemByproduct.EnumByproduct tier2 = ((ItemBedrockOre.EnumBedrockOre)((Object)string)).byproducts[1];
            ItemStack by2 = tier2 == null ? new ItemStack(ModItems.dust) : OreDictManager.DictFrame.fromOne(ModItems.ore_byproduct, (Enum)tier2, 1);
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_deepcleaned, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_enriched, 1, i), new ItemStack(ModItems.ore_enriched, 1, i), ItemStackUtil.carefulCopy(by2), ItemStackUtil.carefulCopy(by2)});
            ItemByproduct.EnumByproduct tier3 = ((ItemBedrockOre.EnumBedrockOre)((Object)string)).byproducts[2];
            ItemStack by3 = tier3 == null ? new ItemStack(ModItems.dust) : OreDictManager.DictFrame.fromOne(ModItems.ore_byproduct, (Enum)tier3, 1);
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_seared, 1, i), new ItemStack[]{new ItemStack(ModItems.ore_enriched, 1, i), new ItemStack(ModItems.ore_enriched, 1, i), ItemStackUtil.carefulCopy(by3), ItemStackUtil.carefulCopy(by3)});
        }
        for (ItemBedrockOreNew.CelestialBedrockOreType type : ItemBedrockOreNew.CelestialBedrockOre.getAllTypes()) {
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type), new ItemStack(Blocks.field_150351_n)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_ROASTED, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type), new ItemStack(Blocks.field_150351_n)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_WASHED, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type), new ItemStack(Blocks.field_150351_n)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SULFURIC, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type, 2)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSOLVENT, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, type, 2)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type)), new ItemStack[]{ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NORAD, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, type, 2), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_BYPRODUCT, type, 2)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSOLVENT, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NORAD, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.primary, 1.0), ItemBedrockOreNew.extract(type.primary, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_WASHED, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.byproductAcid, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_WASHED, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.byproductSolvent, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
            recipes.put(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_WASHED, type)), new ItemStack[]{ItemBedrockOreNew.extract(type.byproductRad, 1.0), ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)});
        }
        ArrayList quartz = OreDictionary.getOres((String)"crystalCertusQuartz");
        if (quartz != null && !quartz.isEmpty()) {
            ItemStack qItem = ((ItemStack)quartz.get(0)).func_77946_l();
            qItem.field_77994_a = 2;
            recipes.put(new RecipesCommon.OreDictStack("oreCertusQuartz"), new ItemStack[]{qItem.func_77946_l(), qItem.func_77946_l(), qItem.func_77946_l(), qItem.func_77946_l()});
        }
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151072_bj), new ItemStack[]{new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151065_br, 1), new ItemStack(ModItems.powder_fire, 1), new ItemStack(ModItems.powder_fire, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_coal), new ItemStack[]{new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_iron), new ItemStack[]{new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_gold), new ItemStack[]{new ItemStack(ModItems.powder_gold, 2), new ItemStack(ModItems.powder_gold, 2), new ItemStack(ModItems.ingot_mercury, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_redstone), new ItemStack[]{new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), new ItemStack(ModItems.ingot_mercury, 3)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_lapis), new ItemStack[]{new ItemStack(ModItems.powder_lapis, 4), new ItemStack(ModItems.powder_lapis, 4), new ItemStack(ModItems.powder_cobalt, 1), new ItemStack(ModItems.gem_sodalite, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_diamond), new ItemStack[]{new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_uranium), new ItemStack[]{new ItemStack(ModItems.powder_uranium, 2), new ItemStack(ModItems.powder_uranium, 2), new ItemStack(ModItems.nugget_ra226, 2), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_thorium), new ItemStack[]{new ItemStack(ModItems.powder_thorium, 2), new ItemStack(ModItems.powder_thorium, 2), new ItemStack(ModItems.powder_uranium, 1), new ItemStack(ModItems.nugget_ra226, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_plutonium), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_polonium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_titanium), new ItemStack[]{new ItemStack(ModItems.powder_titanium, 2), new ItemStack(ModItems.powder_titanium, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_sulfur), new ItemStack[]{new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.ingot_mercury, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_niter), new ItemStack[]{new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_copper), new ItemStack[]{new ItemStack(ModItems.powder_copper, 2), new ItemStack(ModItems.powder_copper, 2), new ItemStack(ModItems.sulfur, 1), new ItemStack(ModItems.powder_cobalt_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_tungsten), new ItemStack[]{new ItemStack(ModItems.powder_tungsten, 2), new ItemStack(ModItems.powder_tungsten, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_aluminium), new ItemStack[]{new ItemStack(ModItems.chunk_ore, 3, ItemEnums.EnumChunkType.CRYOLITE.ordinal()), new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_fluorite), new ItemStack[]{new ItemStack(ModItems.fluorite, 4), new ItemStack(ModItems.fluorite, 4), new ItemStack(ModItems.gem_sodalite, 2), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_beryllium), new ItemStack[]{new ItemStack(ModItems.powder_beryllium, 2), new ItemStack(ModItems.powder_beryllium, 2), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_lead), new ItemStack[]{new ItemStack(ModItems.powder_lead, 2), new ItemStack(ModItems.powder_lead, 2), new ItemStack(ModItems.powder_gold, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_schraranium), new ItemStack[]{new ItemStack(ModItems.nugget_schrabidium, 2), new ItemStack(ModItems.nugget_schrabidium, 2), new ItemStack(ModItems.nugget_uranium, 2), new ItemStack(ModItems.nugget_neptunium, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_schrabidium), new ItemStack[]{new ItemStack(ModItems.powder_schrabidium, 2), new ItemStack(ModItems.powder_schrabidium, 2), new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_rare), new ItemStack[]{new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.nugget_zirconium, 2), new ItemStack(ModItems.nugget_zirconium, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_phosphorus), new ItemStack[]{new ItemStack(ModItems.powder_fire, 3), new ItemStack(ModItems.powder_fire, 3), new ItemStack(ModItems.ingot_phosphorus, 2), new ItemStack(Items.field_151065_br, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_trixite), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_cobalt, 3), new ItemStack(ModItems.powder_niobium, 2), new ItemStack(ModItems.powder_nitan_mix, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_lithium), new ItemStack[]{new ItemStack(ModItems.powder_lithium, 2), new ItemStack(ModItems.powder_lithium, 2), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.fluorite, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_starmetal), new ItemStack[]{new ItemStack(ModItems.powder_dura_steel, 3), new ItemStack(ModItems.powder_cobalt, 3), new ItemStack(ModItems.powder_astatine, 2), new ItemStack(ModItems.ingot_mercury, 5)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_cobalt), new ItemStack[]{new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_iron, 3), new ItemStack(ModItems.powder_copper, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_mineral), new ItemStack[]{new ItemStack(ModItems.mineral_dust, 2), new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_aluminium, 2), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_nickel), new ItemStack[]{new ItemStack(ModItems.powder_nickel, 2), new ItemStack(ModItems.powder_nickel, 2), new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_titanium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_niobium), new ItemStack[]{new ItemStack(ModItems.powder_niobium, 2), new ItemStack(ModItems.powder_niobium, 2), new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.nugget_hafnium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_zinc), new ItemStack[]{new ItemStack(ModItems.powder_zinc, 2), new ItemStack(ModItems.powder_zinc, 2), new ItemStack(ModItems.sulfur, 2), new ItemStack(ModItems.powder_aluminium, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.nickel_salts), new ItemStack[]{new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_nickel, 2), new ItemStack(ModItems.powder_sodium, 1), new ItemStack(ModItems.sulfur, 1)});
    }

    @Override
    public void registerPost() {
        if (!IMCCentrifuge.buffer.isEmpty()) {
            recipes.putAll(IMCCentrifuge.buffer);
            MainRegistry.logger.info("Fetched " + IMCCentrifuge.buffer.size() + " IMC centrifuge recipes!");
            IMCCentrifuge.buffer.clear();
        }
    }

    public static ItemStack[] getOutput(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        if (recipes.containsKey(comp)) {
            return RecipesCommon.copyStackArray(recipes.get(comp));
        }
        for (Map.Entry<RecipesCommon.AStack, ItemStack[]> entry : recipes.entrySet()) {
            if (!entry.getKey().isApplicable(stack)) continue;
            return RecipesCommon.copyStackArray(entry.getValue());
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<RecipesCommon.AStack, ItemStack[]> recipes = new HashMap<RecipesCommon.AStack, ItemStack[]>();
        for (Map.Entry<RecipesCommon.AStack, ItemStack[]> entry : CentrifugeRecipes.recipes.entrySet()) {
            recipes.put(entry.getKey(), entry.getValue());
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmCentrifuge.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack in = CentrifugeRecipes.readAStack(obj.get("input").getAsJsonArray());
        ItemStack[] out = CentrifugeRecipes.readItemStackArray((JsonArray)obj.get("output"));
        recipes.put(in, out);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        try {
            Map.Entry entry = (Map.Entry)recipe;
            writer.name("input");
            CentrifugeRecipes.writeAStack((RecipesCommon.AStack)entry.getKey(), writer);
            writer.name("output").beginArray();
            for (ItemStack stack : (ItemStack[])entry.getValue()) {
                CentrifugeRecipes.writeItemStack(stack, writer);
            }
            writer.endArray();
        }
        catch (Exception ex) {
            MainRegistry.logger.error((Object)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public String getComment() {
        return "Outputs have to be an array of up to four item stacks. Fewer aren't used by default recipes, but should work anyway.";
    }
}

