/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemTransporterLinker;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUITransporterLinker
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/tool/gui_transport_linker.png");
    protected int xSize = 218;
    protected int ySize = 201;
    protected int guiLeft;
    protected int guiTop;
    private GuiTextField search;
    private int index = 0;
    protected ItemTransporterLinker.TransporterInfo linkFromTransporter;
    protected ItemTransporterLinker.TransporterInfo linkToTransporter;
    protected List<ItemTransporterLinker.TransporterInfo> transporters;
    private List<ItemTransporterLinker.TransporterInfo> visibleTransporters;
    private final EntityPlayer player;

    public GUITransporterLinker(EntityPlayer player, List<ItemTransporterLinker.TransporterInfo> transporters, ItemTransporterLinker.TransporterInfo linkFromTransporter) {
        this.player = player;
        this.linkFromTransporter = linkFromTransporter;
        if (linkFromTransporter != null) {
            this.linkToTransporter = linkFromTransporter.linkedTo;
        }
        this.transporters = transporters;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(mouseX, mouseY);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && Mouse.next()) {
            int scroll = Mouse.getEventDWheel();
            if (scroll > 0 && this.index > 0) {
                --this.index;
            }
            if (scroll < 0 && this.index < this.visibleTransporters.size() - 5) {
                ++this.index;
            }
        }
    }

    public void func_73876_c() {
        if (this.player.func_70694_bm() == null || this.player.func_70694_bm().func_77973_b() != ModItems.transporter_linker) {
            this.player.func_71053_j();
        }
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(this.field_146289_q, this.guiLeft + 59, this.guiTop + 46, 86, 12);
        this.search.func_146193_g(-1);
        this.search.func_146204_h(-1);
        this.search.func_146185_a(false);
        this.search.func_146195_b(true);
        this.updateSearch();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void drawGuiContainerBackgroundLayer(int mouseX, int mouseY) {
        int hideScroll = this.visibleTransporters.size() <= 5 ? 20 : 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize - hideScroll, this.ySize);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 55, this.guiTop + 41, 0, this.ySize, 107, 18);
        }
        this.search.func_146194_f();
        int x = this.guiLeft + 37;
        int textLeftX = this.guiLeft + 62;
        int textRightX = this.guiLeft + 188;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.linkFromTransporter.planet);
        GUITransporterLinker.func_146110_a((int)x, (int)(this.guiTop + 14), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        String coordinates = "x: " + this.linkFromTransporter.x + ", z: " + this.linkFromTransporter.z;
        int width = this.field_146289_q.func_78256_a(coordinates);
        this.field_146289_q.func_78261_a(this.linkFromTransporter.name, textLeftX, this.guiTop + 13, 65280);
        this.field_146289_q.func_78261_a(coordinates, textRightX - width, this.guiTop + 23, 65280);
        for (int i = this.index; i < Math.min(this.index + 5, this.visibleTransporters.size()); ++i) {
            ItemTransporterLinker.TransporterInfo transporter = this.visibleTransporters.get(i);
            int y = this.guiTop + 70 + (i - this.index) * 26;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(transporter.planet);
            GUITransporterLinker.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            coordinates = "x: " + transporter.x + ", z: " + transporter.z;
            width = this.field_146289_q.func_78256_a(coordinates);
            this.field_146289_q.func_78261_a(transporter.name, textLeftX, y - 1, 65280);
            this.field_146289_q.func_78261_a(coordinates, textRightX - width, y + 9, 65280);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int x = this.guiLeft + 10;
        if (this.isInAABB(mouseX, mouseY, x, this.guiTop + 13, 18, 18)) {
            this.func_73729_b(x, this.guiTop + 13, this.xSize + 18, 0, 18, 18);
        }
        for (int i = this.index; i < Math.min(this.index + 5, this.visibleTransporters.size()); ++i) {
            ItemTransporterLinker.TransporterInfo transporter = this.visibleTransporters.get(i);
            int y = this.guiTop + 69 + (i - this.index) * 26;
            if (this.linkToTransporter != null && this.linkToTransporter.equals(transporter)) {
                this.func_73729_b(x, y, this.xSize, 18, 18, 18);
                if (!this.isInAABB(mouseX, mouseY, x, y, 18, 18)) continue;
                this.func_73729_b(x, y, this.xSize + 18, 0, 18, 18);
                continue;
            }
            if (!this.isInAABB(mouseX, mouseY, x, y, 18, 18)) continue;
            this.func_73729_b(x, y, this.xSize, 0, 18, 18);
        }
        if (this.visibleTransporters.size() > 5) {
            x = this.guiLeft + 202;
            int y = this.guiTop + 68 + MathHelper.func_76141_d((float)((float)this.index / (float)(this.visibleTransporters.size() - 5) * 114.0f));
            this.func_73729_b(x, y, this.xSize, 54, 14, 15);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        this.search.func_146192_a(mouseX, mouseY, button);
        int x = this.guiLeft + 10;
        if (this.isInAABB(mouseX, mouseY, x, this.guiTop + 13, 18, 18) && this.selectTransporter(null)) {
            this.player.func_71053_j();
        }
        for (int i = this.index; i < Math.min(this.index + 5, this.visibleTransporters.size()); ++i) {
            int y = this.guiTop + 69 + (i - this.index) * 26;
            if (!this.isInAABB(mouseX, mouseY, x, y, 18, 18) || !this.selectTransporter(this.visibleTransporters.get(i))) continue;
            this.player.func_71053_j();
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastButtonClicked, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, lastButtonClicked, timeSinceLastClick);
        if (this.isInAABB(mouseX, mouseY, this.guiLeft + 198, this.guiTop + 64, 22, 137)) {
            this.index = MathHelper.func_76141_d((float)((float)(mouseY - (this.guiTop + 68)) / 114.0f * (float)(this.visibleTransporters.size() - 5)));
            this.index = MathHelper.func_76125_a((int)this.index, (int)0, (int)(this.visibleTransporters.size() - 5));
        }
    }

    private boolean selectTransporter(ItemTransporterLinker.TransporterInfo transporter) {
        if (this.linkFromTransporter.equals(transporter)) {
            return false;
        }
        if (this.linkToTransporter != null && this.linkToTransporter.equals(transporter)) {
            this.linkTransporters(this.linkFromTransporter, null);
        } else {
            this.linkTransporters(this.linkFromTransporter, transporter);
        }
        return true;
    }

    private void linkTransporters(ItemTransporterLinker.TransporterInfo from, ItemTransporterLinker.TransporterInfo to) {
        if (from == null && to == null) {
            return;
        }
        if (to == null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("unlink", true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, from.x, from.y, from.z));
            return;
        }
        if (from == null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("unlink", true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, to.x, to.y, to.z));
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("dimensionId", to.dimensionId);
        data.func_74783_a("linkedTo", new int[]{to.x, to.y, to.z});
        PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, from.x, from.y, from.z));
    }

    protected void func_73869_a(char c, int key) {
        if (this.search.func_146201_a(c, key)) {
            this.updateSearch();
        } else {
            super.func_73869_a(c, key);
        }
        if (key == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    private void updateSearch() {
        this.visibleTransporters = new ArrayList<ItemTransporterLinker.TransporterInfo>();
        this.index = 0;
        String subs = this.search.func_146179_b().toLowerCase(Locale.US);
        for (ItemTransporterLinker.TransporterInfo transporter : this.transporters) {
            if (transporter.equals(this.linkFromTransporter) || transporter.linkedTo != null && !transporter.linkedTo.equals(this.linkFromTransporter) || !transporter.name.toLowerCase(Locale.US).contains(subs)) continue;
            this.visibleTransporters.add(transporter);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private boolean isInAABB(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && x + width > mouseX && y <= mouseY && y + height > mouseY;
    }
}

