/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerCrucible;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.tileentity.machine.TileEntityCrucible;
import com.hbm.util.i18n.I18nUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUICrucible
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_crucible.png");
    private TileEntityCrucible crucible;

    public GUICrucible(InventoryPlayer invPlayer, TileEntityCrucible tedf) {
        super(new ContainerCrucible(invPlayer, tedf));
        this.crucible = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 214;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        this.drawStackInfo(this.crucible.wasteStack, x, y, 16, 17);
        this.drawStackInfo(this.crucible.recipeStack, x, y, 61, 17);
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[1];
        objectArray[0] = TileEntityCrucible.processTime;
        stringArray[0] = String.format(Locale.US, "%,d", this.crucible.progress) + " / " + String.format(Locale.US, "%,d", objectArray) + "TU";
        this.drawCustomInfoStat(x, y, this.field_147003_i + 125, this.field_147009_r + 81, 34, 7, x, y, stringArray);
        String[] stringArray2 = new String[1];
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = TileEntityCrucible.maxHeat;
        stringArray2[0] = String.format(Locale.US, "%,d", this.crucible.heat) + " / " + String.format(Locale.US, "%,d", objectArray2) + "TU";
        this.drawCustomInfoStat(x, y, this.field_147003_i + 125, this.field_147009_r + 90, 34, 7, x, y, stringArray2);
    }

    protected void func_146979_b(int i, int j) {
        String name = this.crucible.func_145818_k_() ? this.crucible.func_145825_b() : I18n.func_135052_a((String)this.crucible.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        int hGauge;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int pGauge = this.crucible.progress * 33 / TileEntityCrucible.processTime;
        if (pGauge > 0) {
            this.func_73729_b(this.field_147003_i + 126, this.field_147009_r + 82, 176, 0, pGauge, 5);
        }
        if ((hGauge = this.crucible.heat * 33 / TileEntityCrucible.maxHeat) > 0) {
            this.func_73729_b(this.field_147003_i + 126, this.field_147009_r + 91, 176, 5, hGauge, 5);
        }
        if (!this.crucible.recipeStack.isEmpty()) {
            this.drawStack(this.crucible.recipeStack, TileEntityCrucible.recipeZCapacity, 62, 97);
        }
        if (!this.crucible.wasteStack.isEmpty()) {
            this.drawStack(this.crucible.wasteStack, TileEntityCrucible.wasteZCapacity, 17, 97);
        }
    }

    protected void drawStackInfo(List<Mats.MaterialStack> stack, int mouseX, int mouseY, int x, int y) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.isEmpty()) {
            list.add(EnumChatFormatting.RED + "Empty");
        }
        for (Mats.MaterialStack sta : stack) {
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey(sta.material.getUnlocalizedName(), new Object[0]) + ": " + Mats.formatAmount(sta.amount, Keyboard.isKeyDown((int)42)));
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + x, this.field_147009_r + y, 36, 81, mouseX, mouseY, list);
    }

    protected void drawStack(List<Mats.MaterialStack> stack, int capacity, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        int lastHeight = 0;
        int lastQuant = 0;
        GL11.glBlendFunc((int)770, (int)1);
        for (Mats.MaterialStack sta : stack) {
            int targetHeight = (lastQuant + sta.amount) * 79 / capacity;
            if (lastHeight == targetHeight) continue;
            int offset = sta.material.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE ? 34 : 0;
            int hex = sta.material.moltenColor;
            Color color = new Color(hex);
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y - targetHeight, 176 + offset, 89 - targetHeight, 34, targetHeight - lastHeight);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y - targetHeight, 176 + offset, 89 - targetHeight, 34, targetHeight - lastHeight);
            GL11.glDisable((int)3042);
            lastQuant += sta.amount;
            lastHeight = targetHeight;
        }
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
    }
}

