/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.tank;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.handler.ArmorModHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidLoadingHandler;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class FluidLoaderFillableItem
extends FluidLoadingHandler {
    @Override
    public boolean fillItem(ItemStack[] slots, int in, int out, FluidTank tank) {
        return this.fill(slots[in], tank);
    }

    public boolean fill(ItemStack stack, FluidTank tank) {
        if (tank.pressure != 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        FluidType type = tank.getTankType();
        if (stack.func_77973_b() instanceof ItemArmor && ArmorModHandler.hasMods(stack)) {
            for (ItemStack mod : ArmorModHandler.pryMods(stack)) {
                if (mod == null || !(mod.func_77973_b() instanceof IFillableItem)) continue;
                this.fill(mod, tank);
                ArmorModHandler.applyMod(stack, mod);
            }
        }
        if (!(stack.func_77973_b() instanceof IFillableItem)) {
            return false;
        }
        IFillableItem fillable = (IFillableItem)stack.func_77973_b();
        if (fillable.acceptsFluid(type, stack)) {
            tank.setFill(fillable.tryFill(type, tank.getFill(), stack));
        }
        return true;
    }

    @Override
    public boolean emptyItem(ItemStack[] slots, int in, int out, FluidTank tank) {
        return this.empty(slots[in], tank);
    }

    public boolean empty(ItemStack stack, FluidTank tank) {
        FluidType type = tank.getTankType();
        if (stack.func_77973_b() instanceof ItemArmor && ArmorModHandler.hasMods(stack)) {
            for (ItemStack mod : ArmorModHandler.pryMods(stack)) {
                if (mod == null || !(mod.func_77973_b() instanceof IFillableItem)) continue;
                this.empty(mod, tank);
            }
        }
        if (!(stack.func_77973_b() instanceof IFillableItem)) {
            return false;
        }
        IFillableItem fillable = (IFillableItem)stack.func_77973_b();
        if (fillable.providesFluid(type, stack)) {
            tank.setFill(tank.getFill() + fillable.tryEmpty(type, tank.getMaxFill() - tank.getFill(), stack));
        }
        return tank.getFill() == tank.getMaxFill();
    }
}

