/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.itempool.ItemPool;
import com.hbm.items.ModItems;
import com.hbm.saveddata.satellites.SatelliteMiner;
import com.hbm.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.WeightedRandomChestContent;

public class SatelliteHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModBlocks.sat_dock)};
    }

    @Override
    public String getRecipeID() {
        return "ntmSatellite";
    }

    public String getRecipeName() {
        return "Satellite";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_anvil.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntmSatellite")) {
            for (Item satelliteItem : new Item[]{ModItems.sat_miner, ModItems.sat_lunar_miner}) {
                String poolName = SatelliteMiner.getCargoForItem(satelliteItem);
                if (poolName == null) continue;
                this.addRecipeToList(satelliteItem, ItemPool.getPool(poolName));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Item satelliteItem : new Item[]{ModItems.sat_miner, ModItems.sat_lunar_miner}) {
            WeightedRandomChestContent[] pool;
            String poolName = SatelliteMiner.getCargoForItem(satelliteItem);
            if (poolName == null) continue;
            for (WeightedRandomChestContent poolEntry : pool = ItemPool.getPool(poolName)) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)poolEntry.field_76297_b, (ItemStack)result)) continue;
                this.addRecipeToList(satelliteItem, pool);
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntmSatellite")) {
            this.loadCraftingRecipes("ntmSatellite", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == ModItems.sat_miner) {
            this.addRecipeToList(ModItems.sat_miner, ItemPool.getPool("POOL_SAT_MINER"));
        } else if (ingredient.func_77973_b() == ModItems.sat_lunar_miner) {
            this.addRecipeToList(ModItems.sat_lunar_miner, ItemPool.getPool("POOL_SAT_LUNAR"));
        }
    }

    private void addRecipeToList(Item poolItem, WeightedRandomChestContent[] poolEntries) {
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>();
        int weight = Arrays.stream(poolEntries).mapToInt(poolEntry -> poolEntry.field_76292_a).sum();
        for (WeightedRandomChestContent poolEntry2 : poolEntries) {
            ItemStack stack = poolEntry2.field_76297_b.func_77946_l();
            float chance = 100.0f * (float)poolEntry2.field_76292_a / (float)weight;
            ItemStackUtil.addTooltipToStack(stack, EnumChatFormatting.RED + "" + (float)((int)(chance * 10.0f)) / 10.0f + "%");
            outs.add(stack);
        }
        this.arecipes.add(new RecipeSet(new ItemStack(poolItem), outs));
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        GuiDraw.drawTexturedModalRect((int)11, (int)23, (int)113, (int)105, (int)18, (int)18);
        GuiDraw.drawTexturedModalRect((int)47, (int)5, (int)5, (int)87, (int)108, (int)54);
        GuiDraw.drawTexturedModalRect((int)29, (int)14, (int)131, (int)96, (int)18, (int)36);
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        List<PositionedStack> input;
        List<PositionedStack> output;
        PositionedStack satelliteDock;

        public RecipeSet(Object in, List<ItemStack> out) {
            super((TemplateRecipeHandler)SatelliteHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.output = new ArrayList<PositionedStack>();
            int outLine = 1;
            int inOX = 0;
            int inOY = 0;
            int outOX = 0;
            int outOY = 0;
            int anvX = 0;
            int anvY = 31;
            outLine = 6;
            inOX = 12;
            inOY = 24;
            outOX = 48;
            outOY = 6;
            anvX = 30;
            this.input.add(new PositionedStack(in, inOX, inOY));
            int overflowCount = out.size() / 18;
            for (int i = 0; i < Math.min(out.size(), 18); ++i) {
                ItemStack[] stacks = new ItemStack[overflowCount + 1];
                for (int j = 0; j < overflowCount + 1 && j * 18 + i < out.size(); ++j) {
                    stacks[j] = out.get(j * 18 + i);
                }
                this.output.add(new PositionedStack((Object)stacks, outOX + 18 * (i % outLine), outOY + 18 * (i / outLine)));
            }
            this.satelliteDock = new PositionedStack((Object)new ItemStack(ModBlocks.sat_dock), anvX, anvY);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SatelliteHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output.get(0);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>(this.output);
            stacks.add(this.satelliteDock);
            return this.getCycledIngredients(SatelliteHandler.this.cycleticks / 20, stacks);
        }
    }
}

