/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.CustomMachineConfigJSON;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.CustomMachineRecipes;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class CustomMachineHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public CustomMachineConfigJSON.MachineConfiguration conf;

    public TemplateRecipeHandler newInstance() {
        try {
            return new CustomMachineHandler(this.conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CustomMachineHandler(CustomMachineConfigJSON.MachineConfiguration conf) {
        this.conf = conf;
        this.loadTransferRects();
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public String getRecipeName() {
        return this.conf.localizedName;
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_custom.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntm_" + this.conf.unlocalizedName)) {
            List<CustomMachineRecipes.CustomMachineRecipe> recipes = CustomMachineRecipes.recipes.get(this.conf.recipeKey);
            if (recipes != null) {
                for (CustomMachineRecipes.CustomMachineRecipe recipe : recipes) {
                    this.arecipes.add(new RecipeSet(recipe));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<CustomMachineRecipes.CustomMachineRecipe> recipes = CustomMachineRecipes.recipes.get(this.conf.recipeKey);
        if (recipes != null) {
            block0: for (CustomMachineRecipes.CustomMachineRecipe recipe : recipes) {
                for (Tuple.Pair<ItemStack, Float> stack : recipe.outputItems) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack.getKey(), (ItemStack)result)) continue;
                    this.arecipes.add(new RecipeSet(recipe));
                    continue block0;
                }
                for (FluidStack fluid : recipe.outputFluids) {
                    ItemStack drop = ItemFluidIcon.make(fluid);
                    if (!CustomMachineHandler.compareFluidStacks(result, drop)) continue;
                    this.arecipes.add(new RecipeSet(recipe));
                    continue block0;
                }
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntm_" + this.conf.unlocalizedName)) {
            this.loadCraftingRecipes("ntm_" + this.conf.unlocalizedName, new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<CustomMachineRecipes.CustomMachineRecipe> recipes = CustomMachineRecipes.recipes.get(this.conf.recipeKey);
        if (recipes != null) {
            block0: for (CustomMachineRecipes.CustomMachineRecipe recipe : recipes) {
                for (RecipesCommon.AStack stack : recipe.inputItems) {
                    List<ItemStack> stacks = stack.extractForNEI();
                    for (ItemStack sta : stacks) {
                        if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)sta)) continue;
                        this.arecipes.add(new RecipeSet(recipe));
                        continue block0;
                    }
                }
                for (FluidStack fluid : recipe.inputFluids) {
                    ItemStack drop = ItemFluidIcon.make(fluid);
                    if (!CustomMachineHandler.compareFluidStacks(ingredient, drop)) continue;
                    this.arecipes.add(new RecipeSet(recipe));
                    continue block0;
                }
            }
        }
    }

    public static boolean compareFluidStacks(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j();
    }

    public void loadTransferRects() {
        if (this.conf == null) {
            return;
        }
        this.transferRects.clear();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 23, 36, 18), "ntm_" + this.conf.unlocalizedName, new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public void drawExtras(int recipe) {
        RecipeSet Recipe = (RecipeSet)((Object)this.arecipes.get(recipe));
        int side = 83;
        if (Recipe.radiationAmount != 0.0f) {
            String radiation = "Radiation:" + Recipe.radiationAmount + "";
            GuiDraw.drawString((String)radiation, (int)(160 - GuiDraw.fontRenderer.func_78256_a(radiation)), (int)63, (int)589568);
        }
        if (Recipe.pollutionAmount != 0.0f) {
            String pollution = Recipe.pollutionType + ":" + Recipe.pollutionAmount + "";
            GuiDraw.drawString((String)pollution, (int)(160 - GuiDraw.fontRenderer.func_78256_a(pollution)), (int)75, (int)0x404040);
        }
        if (this.conf.fluxMode) {
            String flux = "Flux:" + Recipe.flux + "";
            GuiDraw.drawString((String)flux, (int)(side - GuiDraw.fontRenderer.func_78256_a(flux) / 2), (int)16, (int)589568);
        }
        if (this.conf.maxHeat > 0 && Recipe.heat > 0) {
            String heat = "Heat:" + Recipe.heat + "";
            GuiDraw.drawString((String)heat, (int)(side - GuiDraw.fontRenderer.func_78256_a(heat) / 2), (int)8, (int)0xFF0000);
        }
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        List<PositionedStack> inputs;
        PositionedStack machine;
        List<PositionedStack> outputs;
        public int flux;
        public int heat;
        public float radiationAmount;
        public String pollutionType;
        public float pollutionAmount;

        public RecipeSet(CustomMachineRecipes.CustomMachineRecipe recipe) {
            ItemStack out;
            Tuple.Pair<ItemStack, Float> pair;
            int i;
            super((TemplateRecipeHandler)CustomMachineHandler.this);
            this.inputs = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.flux = 0;
            this.heat = 0;
            this.radiationAmount = 0.0f;
            this.pollutionAmount = 0.0f;
            for (i = 0; i < 3; ++i) {
                if (recipe.inputFluids.length <= i) continue;
                this.inputs.add(new PositionedStack((Object)ItemFluidIcon.make(recipe.inputFluids[i]), 12 + i * 18, 6));
            }
            for (i = 0; i < 3; ++i) {
                if (recipe.inputItems.length <= i) continue;
                this.inputs.add(new PositionedStack(recipe.inputItems[i].extractForNEI(), 12 + i * 18, 24));
            }
            for (i = 3; i < 6; ++i) {
                if (recipe.inputItems.length <= i) continue;
                this.inputs.add(new PositionedStack(recipe.inputItems[i].extractForNEI(), 12 + (i - 3) * 18, 42));
            }
            for (i = 0; i < 3; ++i) {
                if (recipe.outputFluids.length <= i) continue;
                this.outputs.add(new PositionedStack((Object)ItemFluidIcon.make(recipe.outputFluids[i]), 102 + i * 18, 6));
            }
            for (i = 0; i < 3; ++i) {
                if (recipe.outputItems.length <= i) continue;
                pair = recipe.outputItems[i];
                out = pair.getKey().func_77946_l();
                if (pair.getValue().floatValue() != 1.0f) {
                    ItemStackUtil.addTooltipToStack(out, EnumChatFormatting.RED + "" + (double)((int)(pair.getValue().floatValue() * 1000.0f)) / 10.0 + "%");
                }
                this.outputs.add(new PositionedStack((Object)out, 102 + i * 18, 24));
            }
            for (i = 3; i < 6; ++i) {
                if (recipe.outputItems.length <= i) continue;
                pair = recipe.outputItems[i];
                out = pair.getKey().func_77946_l();
                if (pair.getValue().floatValue() != 1.0f) {
                    ItemStackUtil.addTooltipToStack(out, EnumChatFormatting.RED + "" + (double)((int)(pair.getValue().floatValue() * 1000.0f)) / 10.0 + "%");
                }
                this.outputs.add(new PositionedStack((Object)out, 102 + (i - 3) * 18, 42));
            }
            this.pollutionType = recipe.pollutionType;
            this.pollutionAmount = recipe.pollutionAmount;
            this.radiationAmount = recipe.radiationAmount;
            if (CustomMachineHandler.this.conf.fluxMode) {
                this.flux = recipe.flux;
            }
            if (CustomMachineHandler.this.conf.maxHeat > 0 && recipe.heat > 0) {
                this.heat = recipe.heat;
            }
            this.machine = new PositionedStack((Object)new ItemStack(ModBlocks.custom_machine, 1, 100 + CustomMachineConfigJSON.niceList.indexOf(CustomMachineHandler.this.conf)), 75, 42);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CustomMachineHandler.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.outputs.get(0);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            other.addAll(this.inputs);
            other.add(this.machine);
            other.addAll(this.outputs);
            return this.getCycledIngredients(CustomMachineHandler.this.cycleticks / 20, other);
        }
    }
}

