/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.CrucibleRecipes;
import com.hbm.items.machine.ItemMold;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CrucibleCastingHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();

    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModBlocks.foundry_basin), new ItemStack(ModBlocks.foundry_mold), new ItemStack(ModBlocks.machine_strand_caster)};
    }

    @Override
    public String getRecipeID() {
        return "ntmCrucibleFoundry";
    }

    public String getRecipeName() {
        return "Crucible Casting";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_foundry.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntmCrucibleFoundry")) {
            for (ItemStack[] recipe : CrucibleRecipes.getMoldRecipes()) {
                this.arecipes.add(new RecipeSet(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (ItemStack[] recipe : CrucibleRecipes.getMoldRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe[3], (ItemStack)result)) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntmCrucibleFoundry")) {
            this.loadCraftingRecipes("ntmCrucibleFoundry", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (ItemStack[] recipe : CrucibleRecipes.getMoldRecipes()) {
            for (int i = 0; i < 3; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe[i], (ItemStack)ingredient)) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 23, 36, 18), "ntmCrucibleFoundry", new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack mold;
        PositionedStack basin;
        PositionedStack output;

        public RecipeSet(ItemStack[] stacks) {
            super((TemplateRecipeHandler)CrucibleCastingHandler.this);
            this.input = new PositionedStack((Object)stacks[0].func_77946_l(), 48, 24);
            this.mold = new PositionedStack((Object)stacks[1].func_77946_l(), 75, 6);
            this.basin = new PositionedStack((Object)stacks[2].func_77946_l(), 75, 42);
            ItemStack o = ItemMold.moldById.get(stacks[1].func_77960_j()).getOutput(Mats.matById.get(stacks[0].func_77960_j()));
            this.output = new PositionedStack((Object)o.func_77946_l(), 102, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrucibleCastingHandler.this.cycleticks / 20, Arrays.asList(this.input, this.mold, this.basin));
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            other.add(this.input);
            other.add(this.mold);
            other.add(this.basin);
            other.add(this.output);
            return this.getCycledIngredients(CrucibleCastingHandler.this.cycleticks / 20, other);
        }
    }
}

