/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.atmosphere;

import com.hbm.config.GeneralConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.atmosphere.AtmosphereBlob;
import com.hbm.handler.atmosphere.IAtmosphereProvider;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.handler.atmosphere.IPlantableBreathing;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkAtmosphereHandler {
    private HashMap<Integer, HashMap<IAtmosphereProvider, AtmosphereBlob>> worldBlobs = new HashMap();
    private final int MAX_BLOB_RADIUS = 256;
    public static final int TREE_GROWTH_CONVERSION = 400;
    public static final int CROP_GROWTH_CONVERSION = 15;
    private static List<Tuple.Pair<ExplosionEvent.Detonate, List<ThreeInts>>> explosions = new ArrayList<Tuple.Pair<ExplosionEvent.Detonate, List<ThreeInts>>>();

    public CBT_Atmosphere getAtmosphere(Entity entity) {
        return this.getAtmosphere(entity.field_70170_p, MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)(entity.field_70163_u + (double)entity.func_70047_e())), MathHelper.func_76128_c((double)entity.field_70161_v), null);
    }

    public CBT_Atmosphere getAtmosphere(World world, int x, int y, int z) {
        return this.getAtmosphere(world, x, y, z, null);
    }

    public CBT_Atmosphere getAtmosphere(World world, int x, int y, int z, AtmosphereBlob excludeBlob) {
        ThreeInts pos = new ThreeInts(x, y, z);
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(world.field_73011_w.field_76574_g);
        if (blobs == null) {
            return null;
        }
        CBT_Atmosphere atmosphere = this.getCelestialAtmosphere(world);
        for (AtmosphereBlob blob : blobs.values()) {
            if (blob == excludeBlob || !blob.contains(pos)) continue;
            double pressure = blob.handler.getFluidPressure();
            if (pressure < 0.0) {
                atmosphere.reduce(pressure);
                continue;
            }
            atmosphere.add(blob.handler.getFluidType(), pressure);
        }
        if (atmosphere.fluids.size() == 0) {
            return null;
        }
        return atmosphere;
    }

    private CBT_Atmosphere getCelestialAtmosphere(World world) {
        if (world.field_73011_w instanceof WorldProviderOrbit) {
            return new CBT_Atmosphere();
        }
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(world, CBT_Atmosphere.class);
        if (atmosphere == null) {
            return new CBT_Atmosphere();
        }
        return atmosphere.clone();
    }

    public List<AtmosphereBlob> getBlobs(World world, int x, int y, int z) {
        ArrayList<AtmosphereBlob> inBlobs = new ArrayList<AtmosphereBlob>();
        ThreeInts pos = new ThreeInts(x, y, z);
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(world.field_73011_w.field_76574_g);
        if (blobs == null) {
            return inBlobs;
        }
        for (AtmosphereBlob blob : blobs.values()) {
            if (!blob.contains(pos)) continue;
            inBlobs.add(blob);
        }
        return inBlobs;
    }

    public boolean hasAtmosphere(World world, int x, int y, int z) {
        ThreeInts pos = new ThreeInts(x, y, z);
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(world.field_73011_w.field_76574_g);
        if (blobs == null) {
            return false;
        }
        for (AtmosphereBlob blob : blobs.values()) {
            if (!blob.contains(pos)) continue;
            return true;
        }
        return false;
    }

    protected List<AtmosphereBlob> getBlobsWithinRadius(World world, ThreeInts pos) {
        return this.getBlobsWithinRadius(world, pos, 256);
    }

    protected List<AtmosphereBlob> getBlobsWithinRadius(World world, ThreeInts pos, int radius) {
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(world.field_73011_w.field_76574_g);
        LinkedList<AtmosphereBlob> list = new LinkedList<AtmosphereBlob>();
        if (blobs == null) {
            return list;
        }
        double radiusSqr = radius * radius;
        for (AtmosphereBlob blob : blobs.values()) {
            if (!(blob.getRootPosition().getDistanceSquared(pos) <= radiusSqr)) continue;
            list.add(blob);
        }
        return list;
    }

    public boolean canBreathe(EntityLivingBase entity) {
        CBT_Atmosphere atmosphere = this.getAtmosphere((Entity)entity);
        if (GeneralConfig.enableDebugMode && entity instanceof EntityPlayer && entity.field_70170_p.func_82737_E() % 20L == 0L) {
            if (atmosphere != null && atmosphere.fluids.size() > 0) {
                for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
                    MainRegistry.logger.info("Atmosphere: " + entry.fluid.getUnlocalizedName() + " - " + entry.pressure + "bar");
                }
            } else {
                MainRegistry.logger.info("Atmosphere: TOTAL VACUUM");
            }
        }
        return this.canBreathe(atmosphere);
    }

    public boolean canBreathe(CBT_Atmosphere atmosphere) {
        return atmosphere != null && (atmosphere.hasFluid(Fluids.AIR, 0.21) || atmosphere.hasFluid(Fluids.OXYGEN, 0.09));
    }

    public boolean hasLiquidPressure(CBT_Atmosphere atmosphere) {
        return atmosphere != null && atmosphere.getPressure() >= 0.19;
    }

    public boolean willCorrode(EntityLivingBase entity) {
        return this.willCorrode(this.getAtmosphere((Entity)entity));
    }

    public boolean willCorrode(CBT_Atmosphere atmosphere) {
        return atmosphere != null && atmosphere.hasTrait(FT_Corrosive.class, 0.2);
    }

    private boolean runEffectsOnBlock(CBT_Atmosphere atmosphere, World world, Block block, int x, int y, int z, boolean fetchAtmosphere) {
        boolean requiresPressure = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
        boolean requiresO2 = block instanceof BlockTorch && !(block instanceof BlockRedstoneTorch) || block instanceof BlockFire;
        boolean requiresCO2 = block instanceof IPlantable;
        if (!(requiresO2 || requiresCO2 || requiresPressure)) {
            return false;
        }
        if (fetchAtmosphere) {
            atmosphere = this.getAtmosphere(world, x, y, z);
        }
        boolean canExist = true;
        if (requiresO2) {
            canExist = atmosphere != null && (atmosphere.hasFluid(Fluids.OXYGEN, 0.09) || atmosphere.hasFluid(Fluids.AIR, 0.21));
        } else if (requiresPressure) {
            canExist = this.hasLiquidPressure(atmosphere);
        } else if (requiresCO2) {
            if (block instanceof IPlantableBreathing) {
                canExist = ((IPlantableBreathing)block).canBreathe(atmosphere);
            } else {
                boolean bl = canExist = atmosphere != null && (atmosphere.hasFluid(Fluids.OXYGEN, 0.01) || atmosphere.hasFluid(Fluids.AIR, 0.1));
            }
        }
        if (canExist) {
            return false;
        }
        block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
        return true;
    }

    public boolean runEffectsOnBlock(CBT_Atmosphere atmosphere, World world, Block block, int x, int y, int z) {
        return this.runEffectsOnBlock(atmosphere, world, block, x, y, z, false);
    }

    public boolean runEffectsOnBlock(World world, Block block, int x, int y, int z) {
        return this.runEffectsOnBlock(null, world, block, x, y, z, true);
    }

    public void registerAtmosphere(IAtmosphereProvider handler) {
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(handler.getWorld().field_73011_w.field_76574_g);
        AtmosphereBlob blob = blobs.get(handler);
        if (blob == null) {
            blob = new AtmosphereBlob(handler);
            blob.addBlock(handler.getRootPosition());
            blobs.put(handler, blob);
        }
    }

    public void unregisterAtmosphere(IAtmosphereProvider handler) {
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(handler.getWorld().field_73011_w.field_76574_g);
        blobs.remove(handler);
    }

    public void onSealableChange(World world, ThreeInts pos, IBlockSealable sealable, List<AtmosphereBlob> nearbyBlobs) {
        if (world.field_72995_K) {
            return;
        }
        if (sealable.isSealed(world, pos.x, pos.y, pos.z)) {
            for (AtmosphereBlob blob : nearbyBlobs) {
                if (blob.contains(pos)) {
                    blob.removeBlock(pos);
                    continue;
                }
                if (blob.contains(blob.getRootPosition())) continue;
                blob.runDepress = false;
                blob.addBlock(blob.getRootPosition());
            }
        } else {
            this.onBlockRemoved(world, pos);
        }
    }

    private void onBlockPlaced(World world, ThreeInts pos) {
        if (!AtmosphereBlob.isBlockSealed(world, pos)) {
            return;
        }
        List<AtmosphereBlob> nearbyBlobs = this.getBlobsWithinRadius(world, pos);
        for (AtmosphereBlob blob : nearbyBlobs) {
            if (blob.contains(pos)) {
                blob.removeBlock(pos);
                continue;
            }
            if (blob.contains(blob.getRootPosition())) continue;
            blob.runDepress = false;
            blob.addBlock(blob.getRootPosition());
        }
    }

    private void onBlockRemoved(World world, ThreeInts pos) {
        List<AtmosphereBlob> nearbyBlobs = this.getBlobsWithinRadius(world, pos);
        block0: for (AtmosphereBlob blob : nearbyBlobs) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!blob.contains(pos.getPositionAtOffset(dir))) continue;
                blob.runDepress = true;
                blob.depressDir = dir;
                blob.addBlock(pos);
                continue block0;
            }
        }
    }

    public void receiveWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        this.worldBlobs.put(event.world.field_73011_w.field_76574_g, new HashMap());
    }

    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        this.worldBlobs.remove(event.world.field_73011_w.field_76574_g);
    }

    public void receiveWorldTick(TickEvent.WorldTickEvent tick) {
        if (tick.world.field_72995_K || tick.phase != TickEvent.Phase.END || tick.world.func_82737_E() % 20L != 0L) {
            return;
        }
        HashMap<IAtmosphereProvider, AtmosphereBlob> blobs = this.worldBlobs.get(tick.world.field_73011_w.field_76574_g);
        for (AtmosphereBlob blob : blobs.values()) {
            blob.checkGrowth();
        }
    }

    public void receiveBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        this.onBlockPlaced(event.world, new ThreeInts(event.x, event.y, event.z));
    }

    public void receiveBlockBroken(BlockEvent.BreakEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        this.onBlockRemoved(event.world, new ThreeInts(event.x, event.y, event.z));
    }

    public void receiveDetonate(ExplosionEvent.Detonate event) {
        if (event.world.field_72995_K) {
            return;
        }
        ArrayList<ThreeInts> unsealingBlocks = new ArrayList<ThreeInts>();
        for (ChunkPosition block : event.getAffectedBlocks()) {
            if (!AtmosphereBlob.isBlockSealed(event.world, block.field_151329_a, block.field_151327_b, block.field_151328_c)) continue;
            unsealingBlocks.add(new ThreeInts(block.field_151329_a, block.field_151327_b, block.field_151328_c));
        }
        explosions.add(new Tuple.Pair(event, unsealingBlocks));
    }

    public void receiveServerTick(TickEvent.ServerTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END) {
            return;
        }
        if (explosions.isEmpty()) {
            return;
        }
        block0: for (Tuple.Pair<ExplosionEvent.Detonate, List<ThreeInts>> pair : explosions) {
            ExplosionEvent.Detonate event = (ExplosionEvent.Detonate)pair.key;
            ThreeInts explosion = new ThreeInts(MathHelper.func_76128_c((double)event.explosion.field_77284_b), MathHelper.func_76128_c((double)event.explosion.field_77285_c), MathHelper.func_76128_c((double)event.explosion.field_77282_d));
            List<AtmosphereBlob> nearbyBlobs = this.getBlobsWithinRadius(event.world, explosion, 256 + MathHelper.func_76123_f((float)event.explosion.field_77280_f));
            for (ThreeInts pos : (List)pair.value) {
                if (nearbyBlobs.size() == 0) continue block0;
                Iterator<AtmosphereBlob> iterator = nearbyBlobs.iterator();
                block2: while (iterator.hasNext()) {
                    AtmosphereBlob blob = iterator.next();
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (!blob.contains(pos.getPositionAtOffset(dir))) continue;
                        blob.runDepress = true;
                        blob.depressDir = dir;
                        blob.addBlock(pos);
                        iterator.remove();
                        continue block2;
                    }
                }
            }
        }
        explosions.clear();
    }

    public void receiveTreeGrow(SaplingGrowTreeEvent event) {
        ThreeInts pos = new ThreeInts(event.x, event.y, event.z);
        List<AtmosphereBlob> nearbyBlobs = this.getBlobsWithinRadius(event.world, pos, 256);
        for (AtmosphereBlob blob : nearbyBlobs) {
            if (!blob.contains(pos)) continue;
            blob.produce(400);
            break;
        }
    }

    public void trackPlant(World world, int x, int y, int z) {
        ThreeInts pos = new ThreeInts(x, y, z);
        List<AtmosphereBlob> nearbyBlobs = this.getBlobsWithinRadius(world, pos);
        for (AtmosphereBlob blob : nearbyBlobs) {
            if (!blob.contains(pos)) continue;
            blob.addPlant(world, x, y, z);
        }
    }
}

