/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.items.ModItems;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public interface IWeaponAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 200;
    public static final IWeaponAbility NONE = new IWeaponAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 200;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
        }
    };
    public static final IWeaponAbility RADIATION = new IWeaponAbility(){
        public final float[] radAtLevel = new float[]{15.0f, 50.0f, 500.0f};

        @Override
        public String getName() {
            return "weapon.ability.radiation";
        }

        @Override
        public int levels() {
            return this.radAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.radAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 201;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            if (victim instanceof EntityLivingBase) {
                ContaminationUtil.contaminate((EntityLivingBase)victim, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, this.radAtLevel[level]);
            }
        }
    };
    public static final IWeaponAbility VAMPIRE = new IWeaponAbility(){
        public final float[] amountAtLevel = new float[]{2.0f, 3.0f, 5.0f, 10.0f, 50.0f};

        @Override
        public String getName() {
            return "weapon.ability.vampire";
        }

        @Override
        public int levels() {
            return this.amountAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.amountAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 202;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            float amount = this.amountAtLevel[level];
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                if (living.func_110143_aJ() <= 0.0f) {
                    return;
                }
                living.func_70606_j(living.func_110143_aJ() - amount);
                if (living.func_110143_aJ() <= 0.0f) {
                    living.func_70645_a(DamageSource.field_76376_m);
                }
                player.func_70691_i(amount);
            }
        }
    };
    public static final IWeaponAbility STUN = new IWeaponAbility(){
        public final int[] durationAtLevel = new int[]{2, 3, 5, 10, 15};

        @Override
        public String getName() {
            return "weapon.ability.stun";
        }

        @Override
        public int levels() {
            return this.durationAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.durationAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 203;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            int duration = this.durationAtLevel[level];
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration * 20, 4));
                living.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, duration * 20, 4));
            }
        }
    };
    public static final IWeaponAbility PHOSPHORUS = new IWeaponAbility(){
        public final int[] durationAtLevel = new int[]{60, 90};

        @Override
        public String getName() {
            return "weapon.ability.phosphorus";
        }

        @Override
        public int levels() {
            return this.durationAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.durationAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 204;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            int duration = this.durationAtLevel[level];
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect(HbmPotion.phosphorus.field_76415_H, duration * 20, 4));
            }
        }
    };
    public static final IWeaponAbility FIRE = new IWeaponAbility(){
        public final int[] durationAtLevel = new int[]{5, 10};

        @Override
        public String getName() {
            return "weapon.ability.fire";
        }

        @Override
        public int levels() {
            return this.durationAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.durationAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 206;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            if (victim instanceof EntityLivingBase) {
                victim.func_70015_d(this.durationAtLevel[level]);
            }
        }
    };
    public static final IWeaponAbility CHAINSAW = new IWeaponAbility(){
        public final int[] dividerAtLevel = new int[]{15, 10};

        @Override
        public String getName() {
            return "weapon.ability.chainsaw";
        }

        @Override
        public int levels() {
            return this.dividerAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (1:" + this.dividerAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 207;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            EntityLivingBase living;
            int divider = this.dividerAtLevel[level];
            if (victim instanceof EntityLivingBase && (living = (EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                int count = Math.min((int)Math.ceil(living.func_110138_aP() / (float)divider), 250);
                for (int i = 0; i < count; ++i) {
                    living.func_70099_a(new ItemStack(ModItems.nitra_small), 1.0f);
                    world.func_72838_d((Entity)new EntityXPOrb(world, living.field_70165_t, living.field_70163_u, living.field_70161_v, 1));
                }
                if (player instanceof EntityPlayerMP) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaburst");
                    data.func_74768_a("count", count * 4);
                    data.func_74780_a("motion", 0.1);
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v), new NetworkRegistry.TargetPoint(living.field_71093_bK, living.field_70165_t, living.field_70163_u, living.field_70161_v, 50.0));
                }
                world.func_72908_a(living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v, "hbm:weapon.chainsaw", 0.5f, 1.0f);
            }
        }
    };
    public static final IWeaponAbility BEHEADER = new IWeaponAbility(){

        @Override
        public String getName() {
            return "weapon.ability.beheader";
        }

        @Override
        public int sortOrder() {
            return 208;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            if (victim instanceof EntityLivingBase && ((EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                EntityLivingBase living = (EntityLivingBase)victim;
                if (living instanceof EntitySkeleton) {
                    if (((EntitySkeleton)living).func_82202_m() == 0) {
                        living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
                    } else if (world.field_73012_v.nextInt(20) == 0) {
                        living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
                    } else {
                        living.func_70099_a(new ItemStack(Items.field_151044_h, 3), 0.0f);
                    }
                } else if (living instanceof EntityZombie) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
                } else if (living instanceof EntityCreeper) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
                } else if (living instanceof EntityMagmaCube) {
                    living.func_70099_a(new ItemStack(Items.field_151064_bs, 3), 0.0f);
                } else if (living instanceof EntitySlime) {
                    living.func_70099_a(new ItemStack(Items.field_151123_aH, 3), 0.0f);
                } else if (living instanceof EntityPlayer) {
                    ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
                    head.field_77990_d = new NBTTagCompound();
                    head.field_77990_d.func_74778_a("SkullOwner", ((EntityPlayer)living).getDisplayName());
                    living.func_70099_a(head, 0.0f);
                } else {
                    living.func_70099_a(new ItemStack(Items.field_151078_bh, 3, 0), 0.0f);
                    living.func_70099_a(new ItemStack(Items.field_151103_aS, 2, 0), 0.0f);
                }
            }
        }
    };
    public static final IWeaponAbility BOBBLE = new IWeaponAbility(){

        @Override
        public String getName() {
            return "weapon.ability.bobble";
        }

        @Override
        public int sortOrder() {
            return 209;
        }

        @Override
        public void onHit(int level, World world, EntityPlayer player, Entity victim, Item tool) {
            if (victim instanceof EntityMob && ((EntityMob)victim).func_110143_aJ() <= 0.0f) {
                EntityMob mob = (EntityMob)victim;
                int chance = 1000;
                if (mob.func_110138_aP() > 20.0f) {
                    chance = 750;
                }
                if (world.field_73012_v.nextInt(chance) == 0) {
                    mob.func_70099_a(new ItemStack(ModBlocks.bobblehead, 1, world.field_73012_v.nextInt(BlockBobble.BobbleType.values().length - 1) + 1), 0.0f);
                }
            }
        }
    };
    public static final IWeaponAbility[] abilities = new IWeaponAbility[]{NONE, RADIATION, VAMPIRE, STUN, PHOSPHORUS, FIRE, CHAINSAW, BEHEADER, BOBBLE};

    public void onHit(int var1, World var2, EntityPlayer var3, Entity var4, Item var5);

    public static IWeaponAbility getByName(String name) {
        for (IWeaponAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

