/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.main.MainRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class HTTPHandler {
    public static List<String> capsule = new ArrayList<String>();
    public static List<String> tipOfTheDay = new ArrayList<String>();
    public static boolean newVersion = false;
    public static String versionNumber = "";

    public static void loadStats() {
        Thread versionChecker = new Thread("NTM Version Checker"){

            @Override
            public void run() {
                try {
                    HTTPHandler.loadVersion();
                    HTTPHandler.loadSoyuz();
                    HTTPHandler.loadTips();
                    HTTPHandler.loadSpaceTips();
                }
                catch (IOException e) {
                    MainRegistry.logger.warn("Version checker failed!");
                }
            }
        };
        versionChecker.start();
    }

    private static void loadVersion() throws IOException {
        String line;
        URL github = new URL("https://raw.githubusercontent.com/JameH2/Hbm-s-Nuclear-Tech-GIT/space-travel-twopointfive/src/main/java/com/hbm/lib/RefStrings.java");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        MainRegistry.logger.info("Searching for new versions...");
        while ((line = in.readLine()) != null) {
            int end;
            if (!line.contains("String VERSION")) continue;
            int begin = line.indexOf(34);
            String sub = line.substring(begin + 1, end = line.lastIndexOf(34));
            newVersion = !"1.0.27 BETA (5490)".equals(sub);
            versionNumber = sub;
            MainRegistry.logger.info("Found version " + sub);
            break;
        }
        MainRegistry.logger.info("Version checker ended.");
        in.close();
    }

    private static void loadSoyuz() throws IOException {
        String line;
        URL github = new URL("https://gist.githubusercontent.com/HbmMods/a1cad71d00b6915945a43961d0037a43/raw/soyuz_holo");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        while ((line = in.readLine()) != null) {
            capsule.add(line);
        }
        in.close();
    }

    private static void loadTips() throws IOException {
        String line;
        URL github = new URL("https://gist.githubusercontent.com/HbmMods/a03c66ba160184e12f43de826b30c096/raw/tip_of_the_day");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        while ((line = in.readLine()) != null) {
            tipOfTheDay.add(line);
        }
        in.close();
    }

    private static void loadSpaceTips() throws IOException {
        String line;
        URL github = new URL("https://gist.githubusercontent.com/MellowArpeggiation/f9424a8773ed8530000437dfcef50d3e/raw/tip_of_the_space");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        while ((line = in.readLine()) != null) {
            tipOfTheDay.add(line);
        }
        in.close();
    }
}

