/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.botprime;

import com.hbm.entity.mob.ai.EntityAINearestAttackableTargetNT;
import com.hbm.entity.mob.botprime.EntityBOTPrimeBase;
import com.hbm.entity.mob.botprime.EntityBOTPrimeBody;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBOTPrimeHead
extends EntityBOTPrimeBase
implements IBossDisplayData {
    public EntityBOTPrimeHead(World world) {
        super(world);
        this.field_70728_aV = 1000;
        this.wasNearGround = false;
        this.attackRange = 150.0;
        this.func_70105_a(3.0f, 3.0f);
        this.maxSpeed = 1.0;
        this.fallSpeed = 0.006;
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetNT(this, EntityPlayer.class, 0, false, false, null, 128.0));
        this.field_70158_ak = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
    }

    @Override
    public boolean getIsHead() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (super.func_70097_a(par1DamageSource, par2)) {
            this.dmgCooldown = 10;
            return true;
        }
        return false;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setHeadID(this.func_145782_y());
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int i = 0; i < 74; ++i) {
            EntityBOTPrimeBody bodyPart = new EntityBOTPrimeBody(this.field_70170_p);
            bodyPart.setPartNumber(i);
            bodyPart.func_70107_b(x, y, z);
            bodyPart.setHeadID(this.func_145782_y());
            this.field_70170_p.func_72838_d((Entity)bodyPart);
        }
        this.func_70107_b(x, y, z);
        this.spawnPoint.func_71571_b(x, y, z);
        return super.func_110161_a(data);
    }

    protected void func_70619_bc() {
        this.func_70626_be();
        super.func_70619_bc();
        this.updateHeadMovement();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 6 == 0) {
            if (this.targetedEntity != null) {
                this.func_70691_i(1.0f);
            } else if (this.field_70718_bc == 0) {
                this.func_70691_i(4.0f);
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < this.attackRange * this.attackRange) {
            if (this.canEntityBeSeenThroughNonSolids(this.targetedEntity)) {
                ++this.attackCounter;
                if (this.attackCounter == 30) {
                    this.laserAttack(this.targetedEntity, true);
                    this.attackCounter = 0;
                }
            } else {
                this.attackCounter = 0;
            }
        } else {
            this.attackCounter = 0;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double dx = this.field_70159_w;
        double dy = this.field_70181_x;
        double dz = this.field_70179_y;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dx, dz) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dy, f3) * 180.0 / Math.PI);
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(200.0, 200.0, 200.0));
        for (EntityPlayer player : players) {
            player.func_71029_a((StatBase)MainRegistry.bossWorm);
            player.field_71071_by.func_70441_a(new ItemStack(ModItems.coin_worm));
        }
    }

    @Override
    public float getAttackStrength(Entity target) {
        return 1000.0f;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawnX", this.spawnPoint.field_71574_a);
        nbt.func_74768_a("spawnY", this.spawnPoint.field_71572_b);
        nbt.func_74768_a("spawnZ", this.spawnPoint.field_71573_c);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spawnPoint.func_71571_b(nbt.func_74762_e("spawnX"), nbt.func_74762_e("spawnY"), nbt.func_74762_e("spawnZ"));
    }

    protected void updateHeadMovement() {
        double deltaX = this.waypointX - this.field_70165_t;
        double deltaY = this.waypointY - this.field_70163_u;
        double deltaZ = this.waypointZ - this.field_70161_v;
        double deltaSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.func_70681_au().nextInt(5) + 2;
            deltaSq = MathHelper.func_76133_a((double)deltaSq);
            if (this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < this.maxSpeed) {
                if (!this.isCourseTraversable()) {
                    deltaSq *= 8.0;
                }
                double moverSpeed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
                this.field_70159_w += deltaX / deltaSq * moverSpeed;
                this.field_70181_x += deltaY / deltaSq * moverSpeed;
                this.field_70179_y += deltaZ / deltaSq * moverSpeed;
            }
        }
        if (!this.isCourseTraversable()) {
            this.field_70181_x -= this.fallSpeed;
        }
        if (this.dmgCooldown > 0) {
            --this.dmgCooldown;
        }
        --this.aggroCooldown;
        if (this.func_70638_az() != null) {
            if (this.aggroCooldown <= 0) {
                this.targetedEntity = this.func_70638_az();
                this.aggroCooldown = 20;
            }
        } else if (this.targetedEntity == null) {
            this.waypointX = this.spawnPoint.field_71574_a - 50 + this.func_70681_au().nextInt(100);
            this.waypointY = this.spawnPoint.field_71572_b - 30 + this.func_70681_au().nextInt(60);
            this.waypointZ = this.spawnPoint.field_71573_c - 50 + this.func_70681_au().nextInt(100);
        }
        this.field_70177_z = -((float)(-(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI)));
        this.field_70125_A = (float)(-(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI));
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < this.attackRange * this.attackRange) {
            if (this.wasNearGround || this.canFly) {
                this.waypointX = this.targetedEntity.field_70165_t;
                this.waypointY = this.targetedEntity.field_70163_u;
                this.waypointZ = this.targetedEntity.field_70161_v;
                if (this.func_70681_au().nextInt(80) == 0 && this.field_70163_u > (double)this.surfaceY && !this.isCourseTraversable()) {
                    this.wasNearGround = false;
                }
            } else {
                this.waypointX = this.targetedEntity.field_70165_t;
                this.waypointY = 10.0;
                this.waypointZ = this.targetedEntity.field_70161_v;
                if (this.field_70163_u < 15.0) {
                    this.wasNearGround = true;
                }
            }
        }
    }
}

