/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import api.hbm.entity.ISuffocationImmune;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityUFOBase
extends EntityFlying
implements IMob,
ISuffocationImmune {
    protected int scanCooldown;
    protected int courseChangeCooldown;
    protected Entity target;

    public EntityUFOBase(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(17, (Object)0);
        this.func_70096_w().func_75682_a(18, (Object)0);
        this.func_70096_w().func_75682_a(19, (Object)0);
    }

    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (this.target != null && !this.target.func_70089_S()) {
            this.target = null;
        }
        this.scanForTarget();
        if (this.courseChangeCooldown <= 0) {
            this.setCourse();
        }
    }

    protected void scanForTarget() {
        int range = this.getScanRange();
        if (this.scanCooldown <= 0) {
            List entities = this.field_70170_p.func_72872_a(Entity.class, this.field_70121_D.func_72314_b((double)range, (double)(range / 2), (double)range));
            this.target = null;
            for (Entity entity : entities) {
                if (!entity.func_70089_S() || !this.func_70686_a(entity.getClass()) || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).func_82165_m(Potion.field_76441_p.field_76415_H)) continue;
                if (this.target == null) {
                    this.target = entity;
                    continue;
                }
                if (!(this.func_70068_e(entity) < this.func_70068_e(this.target))) continue;
                this.target = entity;
            }
            this.scanCooldown = this.getScanDelay();
        }
    }

    protected int getScanRange() {
        return 50;
    }

    protected int getScanDelay() {
        return 100;
    }

    protected boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double p_70790_7_) {
        double d4 = ((double)this.getX() - this.field_70165_t) / p_70790_7_;
        double d5 = ((double)this.getY() - this.field_70163_u) / p_70790_7_;
        double d6 = ((double)this.getZ() - this.field_70161_v) / p_70790_7_;
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < p_70790_7_) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.field_70170_p.func_72945_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void approachPosition(double speed) {
        double deltaZ;
        double deltaY;
        double deltaX = (double)this.getX() - this.field_70165_t;
        Vec3 delta = Vec3.func_72443_a((double)deltaX, (double)(deltaY = (double)this.getY() - this.field_70163_u), (double)(deltaZ = (double)this.getZ() - this.field_70161_v));
        double len = delta.func_72433_c();
        if (len > 5.0) {
            if (this.isCourseTraversable(this.getX(), this.getY(), this.getZ(), len)) {
                this.field_70159_w = delta.field_72450_a * speed / len;
                this.field_70181_x = delta.field_72448_b * speed / len;
                this.field_70179_y = delta.field_72449_c * speed / len;
            } else {
                this.courseChangeCooldown = 0;
            }
        }
    }

    protected void setCourse() {
        if (this.target != null) {
            this.setCourseForTaget();
            this.courseChangeCooldown = 20 + this.field_70146_Z.nextInt(20);
        } else {
            this.setCourseWithoutTaget();
            this.courseChangeCooldown = 60 + this.field_70146_Z.nextInt(20);
        }
    }

    protected void setCourseForTaget() {
        Vec3 vec = Vec3.func_72443_a((double)(this.field_70165_t - this.target.field_70165_t), (double)0.0, (double)(this.field_70161_v - this.target.field_70161_v));
        vec.func_72442_b((float)Math.PI * 2 * this.field_70146_Z.nextFloat());
        double length = vec.func_72433_c();
        double overshoot = 10.0 + this.field_70146_Z.nextDouble() * 10.0;
        int wX = (int)Math.floor(this.target.field_70165_t - vec.field_72450_a / length * overshoot);
        int wZ = (int)Math.floor(this.target.field_70161_v - vec.field_72449_c / length * overshoot);
        this.setWaypoint(wX, Math.max(this.field_70170_p.func_72976_f(wX, wZ), (int)this.target.field_70163_u) + this.targetHeightOffset(), wZ);
    }

    protected int targetHeightOffset() {
        return 2 + this.field_70146_Z.nextInt(2);
    }

    protected int wanderHeightOffset() {
        return 2 + this.field_70146_Z.nextInt(3);
    }

    protected void setCourseWithoutTaget() {
        int x = (int)Math.floor(this.field_70165_t + this.field_70146_Z.nextGaussian() * 5.0);
        int z = (int)Math.floor(this.field_70161_v + this.field_70146_Z.nextGaussian() * 5.0);
        this.setWaypoint(x, this.field_70170_p.func_72976_f(x, z) + this.wanderHeightOffset(), z);
    }

    public void setWaypoint(int x, int y, int z) {
        this.field_70180_af.func_75692_b(17, (Object)x);
        this.field_70180_af.func_75692_b(18, (Object)y);
        this.field_70180_af.func_75692_b(19, (Object)z);
    }

    public int getX() {
        return this.field_70180_af.func_75679_c(17);
    }

    public int getY() {
        return this.field_70180_af.func_75679_c(18);
    }

    public int getZ() {
        return this.field_70180_af.func_75679_c(19);
    }
}

