/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.BombConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.entity.logic.EntityExplosionChunkloading;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeRayBatched;
import com.hbm.interfaces.IExplosionRay;
import com.hbm.main.MainRegistry;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityNukeExplosionMK5
extends EntityExplosionChunkloading {
    public int strength;
    public int speed;
    public int length;
    private long explosionStart;
    public boolean fallout = true;
    public boolean salted = false;
    private int falloutAdd = 0;
    private IExplosionRay explosion;

    public EntityNukeExplosionMK5(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public EntityNukeExplosionMK5(World world, int strength, int speed, int length) {
        super(world);
        this.strength = strength;
        this.speed = speed;
        this.length = length;
    }

    public void func_70071_h_() {
        if (this.strength == 0) {
            this.clearChunkLoader();
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.loadChunk((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
        }
        for (Object player : this.field_70170_p.field_73010_i) {
            ((EntityPlayer)player).func_71029_a((StatBase)MainRegistry.achManhattan);
        }
        if (!this.field_70170_p.field_72995_K && this.fallout && this.explosion != null && this.field_70173_aa < 10 && this.strength >= 75) {
            this.radiate(2500000.0f / (float)(this.field_70173_aa * 5 + 1), this.length * 2);
        }
        ExplosionNukeGeneric.dealDamage(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.length * 2);
        if (this.explosion == null) {
            this.explosionStart = System.currentTimeMillis();
            this.explosion = new ExplosionNukeRayBatched(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.strength, this.speed, this.length);
        }
        if (!this.explosion.isComplete()) {
            this.explosion.cacheChunksTick(BombConfig.mk5);
            this.explosion.destructionTick(BombConfig.mk5);
        } else {
            if (GeneralConfig.enableExtendedLogging && this.explosionStart != 0L) {
                MainRegistry.logger.log(Level.INFO, "[NUKE] Explosion complete. Time elapsed: {}ms", new Object[]{System.currentTimeMillis() - this.explosionStart});
            }
            if (this.fallout) {
                EntityFalloutRain fallout = new EntityFalloutRain(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.length * 2.5 + (double)this.falloutAdd) * BombConfig.falloutRange / 100);
                this.field_70170_p.func_72838_d((Entity)fallout);
            }
            this.clearChunkLoader();
            this.func_70106_y();
        }
    }

    private void radiate(float rads, double range) {
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(range, range, range));
        for (EntityLivingBase e : entities) {
            Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - this.field_70165_t), (double)(e.field_70163_u + (double)e.func_70047_e() - this.field_70163_u), (double)(e.field_70161_v - this.field_70161_v));
            double len = vec.func_72433_c();
            vec = vec.func_72432_b();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor(this.field_70165_t + vec.field_72450_a * (double)i);
                int iy = (int)Math.floor(this.field_70163_u + vec.field_72448_b * (double)i);
                int iz = (int)Math.floor(this.field_70161_v + vec.field_72449_c * (double)i);
                res += this.field_70170_p.func_147439_a(ix, iy, iz).func_149638_a(null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = rads;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, eRads /= (float)(len * len));
        }
    }

    public void func_70106_y() {
        if (this.explosion != null) {
            this.explosion.cancel();
        }
        super.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70173_aa = nbt.func_74762_e("ticksExisted");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksExisted", this.field_70173_aa);
    }

    public static EntityNukeExplosionMK5 statFac(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized explosion at {} / {} / {} with strength {}!", new Object[]{x, y, z, r});
        }
        if (r == 0) {
            r = 25;
        }
        EntityNukeExplosionMK5 mk5 = new EntityNukeExplosionMK5(world);
        mk5.strength = r *= 2;
        mk5.speed = (int)Math.ceil(100000 / mk5.strength);
        mk5.func_70107_b(x, y, z);
        mk5.length = mk5.strength / 2;
        mk5.loadChunk((int)Math.floor(x / 16.0), (int)Math.floor(z / 16.0));
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacNoRad(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.fallout = false;
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacSalted(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.salted = true;
        return mk5;
    }

    public EntityNukeExplosionMK5 moreFallout(int fallout) {
        this.falloutAdd = fallout;
        return this;
    }
}

