/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.logic.EntityExplosionChunkloading;
import com.hbm.explosion.ExplosionBalefire;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.main.MainRegistry;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityBalefire
extends EntityExplosionChunkloading {
    public int age = 0;
    public int destructionRange = 0;
    public ExplosionBalefire exp;
    public int speed = 1;
    public boolean did = false;
    public boolean antimatter = false;

    protected void func_70037_a(NBTTagCompound nbt) {
        this.age = nbt.func_74762_e("age");
        this.destructionRange = nbt.func_74762_e("destructionRange");
        this.speed = nbt.func_74762_e("speed");
        this.did = nbt.func_74767_n("did");
        this.antimatter = nbt.func_74767_n("antimatter");
        this.exp = new ExplosionBalefire((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p, this.destructionRange, this.antimatter);
        this.exp.readFromNbt(nbt, "exp_");
        this.did = true;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("destructionRange", this.destructionRange);
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74757_a("did", this.did);
        nbt.func_74757_a("antimatter", this.antimatter);
        if (this.exp != null) {
            this.exp.saveToNbt(nbt, "exp_");
        }
    }

    public EntityBalefire(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.did) {
            if (GeneralConfig.enableExtendedLogging && !this.field_70170_p.field_72995_K) {
                MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized BF explosion at " + this.field_70165_t + " / " + this.field_70163_u + " / " + this.field_70161_v + " with strength " + this.destructionRange + "!");
            }
            this.exp = new ExplosionBalefire((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p, this.destructionRange, this.antimatter);
            this.did = true;
        }
        ++this.speed;
        boolean flag = false;
        for (int i = 0; i < this.speed; ++i) {
            flag = this.exp.update();
            if (!flag) continue;
            this.clearChunkLoader();
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.antimatter && this.field_70173_aa < 10) {
            this.radiate(40000 * this.destructionRange, this.destructionRange * 2);
        }
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        if (!flag) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            ExplosionNukeGeneric.dealDamage(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.destructionRange * 2);
        }
        ++this.age;
    }

    private void radiate(float rads, double range) {
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(range, range, range));
        for (EntityLivingBase e : entities) {
            Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - this.field_70165_t), (double)(e.field_70163_u + (double)e.func_70047_e() - this.field_70163_u), (double)(e.field_70161_v - this.field_70161_v));
            double len = vec.func_72433_c();
            vec = vec.func_72432_b();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor(this.field_70165_t + vec.field_72450_a * (double)i);
                int iy = (int)Math.floor(this.field_70163_u + vec.field_72448_b * (double)i);
                int iz = (int)Math.floor(this.field_70161_v + vec.field_72449_c * (double)i);
                res += this.field_70170_p.func_147439_a(ix, iy, iz).func_149638_a(null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = rads;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, eRads /= (float)(len * len));
            if (!(eRads >= 500.0f) || e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) continue;
            e.func_70606_j(0.0f);
            ExplosionLarge.spawnShock(this.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, 10, 10.0);
            e.func_70106_y();
        }
        ++this.age;
    }

    public EntityBalefire antimatter() {
        this.antimatter = true;
        return this;
    }
}

