/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FT_Pheromone;
import com.hbm.inventory.fluid.trait.FT_Poison;
import com.hbm.inventory.fluid.trait.FT_Toxin;
import com.hbm.inventory.fluid.trait.FT_VentRadiation;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.EntityDamageUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityMist
extends Entity {
    public int maxAge = 150;

    public EntityMist(World world) {
        super(world);
        this.field_70145_X = true;
    }

    public EntityMist setArea(float width, float height) {
        this.field_70180_af.func_75692_b(11, (Object)Float.valueOf(width));
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(height));
        return this;
    }

    public EntityMist setDuration(int duration) {
        this.maxAge = duration;
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(11, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(12, (Object)new Float(0.0f));
    }

    public EntityMist setType(FluidType fluid) {
        this.field_70180_af.func_75692_b(10, (Object)fluid.getID());
        return this;
    }

    public FluidType getType() {
        return Fluids.fromID(this.field_70180_af.func_75679_c(10));
    }

    public void func_70030_z() {
        float height = this.field_70180_af.func_111145_d(12);
        this.field_70129_M = 0.0f;
        this.func_70105_a(this.field_70180_af.func_111145_d(11), height);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            FluidType type;
            if (this.field_70173_aa >= this.getMaxAge()) {
                this.func_70106_y();
            }
            if ((type = this.getType()).hasTrait(FT_VentRadiation.class)) {
                FT_VentRadiation trait = type.getTrait(FT_VentRadiation.class);
                ChunkRadiationManager.proxy.incrementRad(this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), trait.getRadPerMB() * 2.0f);
            }
            double intensity = 1.0 - (double)this.field_70173_aa / (double)this.getMaxAge();
            if (type.hasTrait(FT_Flammable.class) && this.func_70027_ad()) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(height / 2.0f), this.field_70161_v, (float)intensity * 15.0f, true);
                this.func_70106_y();
                return;
            }
            AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
            List affected = this.field_70170_p.func_72839_b((Entity)this, aabb.func_72317_d((double)(-this.field_70130_N / 2.0f), 0.0, (double)(-this.field_70130_N / 2.0f)));
            for (Entity e : affected) {
                this.affect(e, intensity);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                double x = this.field_70121_D.field_72340_a + (this.field_70146_Z.nextDouble() - 0.5) * (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a);
                double y = this.field_70121_D.field_72338_b + this.field_70146_Z.nextDouble() * (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b);
                double z = this.field_70121_D.field_72339_c + (this.field_70146_Z.nextDouble() - 0.5) * (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c);
                NBTTagCompound fx = new NBTTagCompound();
                fx.func_74778_a("type", "tower");
                fx.func_74776_a("lift", 0.5f);
                fx.func_74776_a("base", 0.75f);
                fx.func_74776_a("max", 2.0f);
                fx.func_74768_a("life", 50 + this.field_70170_p.field_73012_v.nextInt(10));
                fx.func_74768_a("color", this.getType().getColor());
                fx.func_74780_a("posX", x);
                fx.func_74780_a("posY", y);
                fx.func_74780_a("posZ", z);
                MainRegistry.proxy.effectNT(fx);
            }
        }
    }

    protected void affect(Entity e, double intensity) {
        FluidTrait trait;
        EntityLivingBase living;
        FluidType type = this.getType();
        EntityLivingBase entityLivingBase = living = e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
        if (type.temperature >= 100) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, new DamageSource("boil"), 0.2f + (float)(type.temperature - 100) * 0.02f);
            if (type.temperature >= 500) {
                e.func_70015_d(10);
            }
        }
        if (type.temperature < -20 && living != null) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, new DamageSource("ice"), 0.2f + (float)(type.temperature + 20) * -0.05f);
            living.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 2));
            living.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100, 4));
        }
        if (type.hasTrait(Fluids.DELICIOUS.getClass()) && living != null && living.func_70089_S()) {
            living.func_70691_i(2.0f * (float)intensity);
        }
        if (type.hasTrait(FT_Flammable.class) && type.hasTrait(FluidTraitSimple.FT_Liquid.class) && living != null) {
            HbmLivingProps.setOil(living, 200);
        }
        if (this.isExtinguishing(type)) {
            e.func_70066_B();
        }
        if (type.hasTrait(FT_Corrosive.class)) {
            trait = type.getTrait(FT_Corrosive.class);
            if (living != null) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame((Entity)living, ModDamageSource.acid, (float)((FT_Corrosive)trait).getRating() / 60.0f);
                for (int i = 0; i < 4; ++i) {
                    ArmorUtil.damageSuit(living, i, ((FT_Corrosive)trait).getRating() / 50);
                }
            }
        }
        if (type.hasTrait(FT_VentRadiation.class)) {
            trait = type.getTrait(FT_VentRadiation.class);
            if (living != null) {
                ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ((FT_VentRadiation)trait).getRadPerMB() * 5.0f);
            }
        }
        if (type.hasTrait(FT_Poison.class)) {
            trait = type.getTrait(FT_Poison.class);
            if (living != null) {
                living.func_70690_d(new PotionEffect(((FT_Poison)trait).isWithering() ? Potion.field_82731_v.field_76415_H : Potion.field_76436_u.field_76415_H, (int)(100.0 * intensity)));
            }
        }
        if (type.hasTrait(FT_Toxin.class)) {
            trait = type.getTrait(FT_Toxin.class);
            if (living != null) {
                ((FT_Toxin)trait).affect(living, intensity);
            }
        }
        if (type == Fluids.ENDERJUICE && living != null) {
            this.teleportRandomly((Entity)living);
        }
        if (type.hasTrait(FT_Pheromone.class)) {
            FT_Pheromone pheromone = type.getTrait(FT_Pheromone.class);
            if (living != null && (living instanceof EntityGlyphid && pheromone.getType() == 1 || living instanceof EntityPlayer && pheromone.getType() == 2)) {
                int mult = pheromone.getType();
                living.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, mult * 60 * 20, 1));
                living.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, mult * 60 * 20, 1));
                living.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, mult * 2 * 20, 0));
                living.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, mult * 60 * 20, 0));
                living.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, mult * 60 * 20, 1));
                living.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, mult * 60 * 20, 0));
            }
        }
    }

    protected boolean isExtinguishing(FluidType type) {
        return this.getType().temperature < 50 && !type.hasTrait(FT_Flammable.class);
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setType(Fluids.fromID(nbt.func_74762_e("type")));
        this.setArea(nbt.func_74760_g("width"), nbt.func_74760_g("height"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("type", this.getType().getID());
        nbt.func_74776_a("width", this.field_70180_af.func_111145_d(11));
        nbt.func_74776_a("height", this.field_70180_af.func_111145_d(12));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70107_b(double x, double y, double z) {
        if (this.field_70173_aa == 0) {
            super.func_70107_b(x, y, z);
        }
    }

    public static SprayStyle getStyleFromType(FluidType type) {
        if (type.hasTrait(FluidTraitSimple.FT_Viscous.class)) {
            return SprayStyle.NULL;
        }
        if (type.hasTrait(FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
            return SprayStyle.GAS;
        }
        if (type.hasTrait(FluidTraitSimple.FT_Liquid.class)) {
            return SprayStyle.MIST;
        }
        return SprayStyle.NULL;
    }

    public void teleportRandomly(Entity e) {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        this.teleportTo(e, x, y, z);
    }

    public void teleportTo(Entity e, double x, double y, double z) {
        int k;
        int j;
        double targetX = e.field_70165_t;
        double targetY = e.field_70163_u;
        double targetZ = e.field_70161_v;
        e.field_70165_t = x;
        e.field_70163_u = y;
        e.field_70161_v = z;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)e.field_70165_t);
        if (e.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)e.field_70163_u), k = MathHelper.func_76128_c((double)e.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = e.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                e.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                e.func_70107_b(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                if (e.field_70170_p.func_72945_a(e, e.field_70121_D).isEmpty() && !e.field_70170_p.func_72953_d(e.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            e.func_70107_b(targetX, targetY, targetZ);
        } else {
            int short1 = 128;
            for (int l = 0; l < short1; ++l) {
                double d6 = (double)l / ((double)short1 - 1.0);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d7 = targetX + (e.field_70165_t - targetX) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
                double d8 = targetY + (e.field_70163_u - targetY) * d6 + this.field_70146_Z.nextDouble() * (double)e.field_70131_O;
                double d9 = targetZ + (e.field_70161_v - targetZ) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
                e.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
            }
            e.field_70170_p.func_72908_a(targetX, targetY, targetZ, "mob.endermen.portal", 1.0f, 1.0f);
            e.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    public static enum SprayStyle {
        MIST,
        GAS,
        NULL;

    }
}

