/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.tekto;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.mapgen.MapGenGreg;
import com.hbm.dim.mapgen.MapGenVolcano;
import com.hbm.dim.tekto.biome.BiomeGenBaseTekto;
import com.hbm.world.gen.terrain.MapGenBubble;
import net.minecraft.world.World;

public class ChunkProviderTekto
extends ChunkProviderCelestial {
    private MapGenGreg caveGenV3 = new MapGenGreg();
    private MapGenVolcano volcano = new MapGenVolcano(12);
    private MapGenBubble tektonic = new MapGenBubble(WorldConfig.tektoOilSpawn);

    public ChunkProviderTekto(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.reclamp = false;
        this.caveGenV3.stoneBlock = ModBlocks.basalt;
        this.volcano.setSize(8, 16);
        this.volcano.setMaterial(ModBlocks.geysir_chloric, ModBlocks.vinyl_sand);
        this.tektonic.block = ModBlocks.ore_tekto;
        this.tektonic.meta = (byte)CelestialBody.getMeta(world);
        this.tektonic.replace = ModBlocks.basalt;
        this.tektonic.setSize(8, 16);
        this.stoneBlock = ModBlocks.basalt;
        this.seaBlock = ModBlocks.ccl_block;
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = super.getChunkPrimer(x, z);
        this.tektonic.setMetas(buffer.metas);
        if (this.biomesForGeneration[0] == BiomeGenBaseTekto.vinylsands) {
            this.volcano.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.caveGenV3.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.tektonic.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }
}

