/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.noise;

import com.hbm.dim.noise.DoublePerlinNoiseSampler;
import com.hbm.util.BobMathUtil;
import java.util.Random;

public final class NoiseCaveGenerator {
    private final DoublePerlinNoiseSampler terrainAdditionNoise;
    private final DoublePerlinNoiseSampler pillarNoise;
    private final DoublePerlinNoiseSampler pillarFalloffNoise;
    private final DoublePerlinNoiseSampler pillarScaleNoise;
    private final DoublePerlinNoiseSampler caveNoise;
    private final DoublePerlinNoiseSampler horizontalCaveNoise;
    private final DoublePerlinNoiseSampler caveScaleNoise;
    private final DoublePerlinNoiseSampler caveFalloffNoise;
    private final DoublePerlinNoiseSampler tunnelNoise1;
    private final DoublePerlinNoiseSampler tunnelNoise2;
    private final DoublePerlinNoiseSampler tunnelScaleNoise;
    private final DoublePerlinNoiseSampler tunnelFalloffNoise;
    private final DoublePerlinNoiseSampler offsetNoise;
    private final DoublePerlinNoiseSampler offsetScaleNoise;
    private final DoublePerlinNoiseSampler caveDensityNoise;

    public NoiseCaveGenerator(Random random) {
        this.pillarNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -7, 1.0, 1.0);
        this.pillarFalloffNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.pillarScaleNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.caveNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -7, 1.0);
        this.horizontalCaveNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.caveScaleNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -11, 1.0);
        this.caveFalloffNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -11, 1.0);
        this.tunnelNoise1 = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -7, 1.0);
        this.tunnelNoise2 = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -7, 1.0);
        this.tunnelScaleNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -11, 1.0);
        this.tunnelFalloffNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.offsetNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -5, 1.0);
        this.offsetScaleNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.terrainAdditionNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 1.0);
        this.caveDensityNoise = DoublePerlinNoiseSampler.create(new Random(random.nextLong()), -8, 0.5, 1.0, 2.0, 1.0, 2.0, 1.0, 0.0, 2.0, 0.0);
    }

    public double sample(double noise, int y, int z, int x) {
        boolean generateLimited = noise < 170.0;
        double tunnelOffset = this.getTunnelOffsetNoise(x, y, z);
        double tunnel = this.getTunnelNoise(x, y, z);
        if (generateLimited) {
            return Math.min(noise, (tunnel + tunnelOffset) * 128.0 * 5.0);
        }
        double caveDensity = this.caveDensityNoise.sample(x, (double)y / 1.5, z);
        double scaledCaveDensity = BobMathUtil.clamp(caveDensity + 0.25, -1.0, 1.0);
        double yScale = (float)(30 - y) / 8.0f;
        double caveOffset = scaledCaveDensity + BobMathUtil.clampedLerp(0.5, 0.0, yScale);
        double terrainAddition = this.getTerrainAdditionNoise(x, y, z);
        double caveNoise = this.getCaveNoise(x, y, z);
        double offset = caveOffset + terrainAddition;
        double smallerNoise = Math.min(offset, Math.min(tunnel, caveNoise) + tunnelOffset);
        double finalNoise = Math.max(smallerNoise, this.getPillarNoise(x, y, z));
        return 128.0 * BobMathUtil.clamp(finalNoise, -1.0, 1.0);
    }

    private double getPillarNoise(int x, int y, int z) {
        double pillarFalloff = NoiseCaveGenerator.lerpFromProgress(this.pillarFalloffNoise, x, y, z, 0.0, 2.0);
        double pillarScale = NoiseCaveGenerator.lerpFromProgress(this.pillarScaleNoise, x, y, z, 0.0, 1.1);
        pillarScale = Math.pow(pillarScale, 3.0);
        double pillarNoise = this.pillarNoise.sample((double)x * 25.0, (double)y * 0.3, (double)z * 25.0);
        return (pillarNoise = pillarScale * (pillarNoise * 2.0 - pillarFalloff)) > 0.03 ? pillarNoise : Double.NEGATIVE_INFINITY;
    }

    private double getTerrainAdditionNoise(int x, int y, int z) {
        double addition = this.terrainAdditionNoise.sample(x, y * 8, z);
        return addition * addition * 4.0;
    }

    private double getTunnelNoise(int x, int y, int z) {
        double tunnelScaleNoise = this.tunnelScaleNoise.sample(x * 2, y, z * 2);
        double tunnelScale = NoiseCaveGenerator.scaleTunnels(tunnelScaleNoise);
        double tunnelFalloff = NoiseCaveGenerator.lerpFromProgress(this.tunnelFalloffNoise, x, y, z, 0.065, 0.088);
        double tunnelNoise1 = NoiseCaveGenerator.sample(this.tunnelNoise1, x, y, z, tunnelScale);
        double scaledTunnelNoise1 = Math.abs(tunnelScale * tunnelNoise1) - tunnelFalloff;
        double tunnelNoise2 = NoiseCaveGenerator.sample(this.tunnelNoise2, x, y, z, tunnelScale);
        double scaledTunnelNoise2 = Math.abs(tunnelScale * tunnelNoise2) - tunnelFalloff;
        return NoiseCaveGenerator.clamp(Math.max(scaledTunnelNoise1, scaledTunnelNoise2));
    }

    private double getCaveNoise(int x, int y, int z) {
        double caveScaleNoise = this.caveScaleNoise.sample(x * 2, y, z * 2);
        double caveScale = NoiseCaveGenerator.scaleCaves(caveScaleNoise);
        double caveFalloff = NoiseCaveGenerator.lerpFromProgress(this.caveFalloffNoise, x * 2, y, z * 2, 0.6, 1.3);
        double caveNoise = NoiseCaveGenerator.sample(this.caveNoise, x, y, z, caveScale);
        double scaledCaveNoise = Math.abs(caveScale * caveNoise) - 0.083 * caveFalloff;
        int yStart = -4;
        double horizontalCaveNoise = NoiseCaveGenerator.lerpFromProgress(this.horizontalCaveNoise, x, 0.0, z, yStart, 4.0) + 4.0;
        double caveFalloffNoise = Math.abs(horizontalCaveNoise - (double)y / 8.0) - 2.0 * caveFalloff;
        caveFalloffNoise = caveFalloffNoise * caveFalloffNoise * caveFalloffNoise;
        return NoiseCaveGenerator.clamp(Math.max(caveFalloffNoise, scaledCaveNoise));
    }

    private double getTunnelOffsetNoise(int x, int y, int z) {
        double scale = NoiseCaveGenerator.lerpFromProgress(this.offsetScaleNoise, x, y, z, 0.0, 0.1);
        return (0.4 - Math.abs(this.offsetNoise.sample(x, y, z))) * scale;
    }

    private static double clamp(double value) {
        return BobMathUtil.clamp(value, -1.0, 1.0);
    }

    private static double sample(DoublePerlinNoiseSampler sampler, double x, double y, double z, double scale) {
        return sampler.sample(x / scale, y / scale, z / scale);
    }

    public static double lerpFromProgress(DoublePerlinNoiseSampler sampler, double x, double y, double z, double start, double end) {
        double value = sampler.sample(x, y, z);
        return BobMathUtil.lerpFromProgress(value, -1.0, 1.0, start, end);
    }

    private static double scaleCaves(double value) {
        if (value < -0.75) {
            return 0.5;
        }
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.5) {
            return 1.0;
        }
        return value < 0.75 ? 2.0 : 3.0;
    }

    private static double scaleTunnels(double value) {
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.0) {
            return 1.0;
        }
        return value < 0.5 ? 1.5 : 2.0;
    }
}

