/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.moho;

import com.hbm.blocks.ModBlocks;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.mapgen.ExperimentalCaveGenerator;
import com.hbm.dim.mapgen.MapGenCrater;
import com.hbm.dim.mapgen.MapGenPlateau;
import com.hbm.dim.mapgen.MapGenVolcano;
import com.hbm.dim.mapgen.MapgenRavineButBased;
import com.hbm.dim.moho.biome.BiomeGenBaseMoho;
import com.hbm.dim.noise.MapGenVNoise;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class ChunkProviderMoho
extends ChunkProviderCelestial {
    private ExperimentalCaveGenerator caveGenV2 = new ExperimentalCaveGenerator(1.0f, 52, 5.0f);
    private MapgenRavineButBased rgen = new MapgenRavineButBased();
    private MapGenVNoise noise = new MapGenVNoise();
    private MapGenCrater smallCrater = new MapGenCrater(6);
    private MapGenCrater largeCrater = new MapGenCrater(64);
    private MapGenVolcano volcano = new MapGenVolcano(72);
    private MapGenPlateau plateau = new MapGenPlateau(this.worldObj);

    public ChunkProviderMoho(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.smallCrater.setSize(8, 32);
        this.largeCrater.setSize(96, 128);
        this.volcano.setSize(64, 128);
        this.volcano.setMaterial(ModBlocks.volcano_core, ModBlocks.basalt);
        this.smallCrater.regolith = this.largeCrater.regolith = ModBlocks.moho_regolith;
        this.smallCrater.rock = this.largeCrater.rock = ModBlocks.moho_stone;
        this.caveGenV2.stoneBlock = ModBlocks.moho_stone;
        this.rgen.stoneBlock = ModBlocks.moho_stone;
        this.stoneBlock = ModBlocks.moho_stone;
        this.seaBlock = Blocks.field_150353_l;
        this.noise.surfBlock = ModBlocks.moho_stone;
        this.noise.rockBlock = ModBlocks.moho_stone;
        this.noise.fluidBlock = Blocks.field_150353_l;
        this.noise.crackSize = 0.5;
        this.noise.cellSize = 27;
        this.noise.plateStartY = 62;
        this.noise.plateThickness = 25;
        this.noise.applyToBiome = BiomeGenBaseMoho.mohoLavaSea;
        this.plateau.maxPlateauAddition = 6;
        this.plateau.surfrock = ModBlocks.moho_regolith;
        this.plateau.stoneBlock = ModBlocks.moho_stone;
        this.plateau.fillblock = Blocks.field_150353_l;
        this.plateau.maxPlateauAddition = 6;
        this.plateau.stepHeight = 2;
        this.plateau.noiseScale = 0.03;
        this.plateau.applyToBiome = BiomeGenBaseMoho.mohoPlateau;
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = super.getChunkPrimer(x, z);
        boolean hasLavaSea = false;
        boolean hasPlateau = false;
        for (int i = 0; i < this.biomesForGeneration.length; ++i) {
            if (this.biomesForGeneration[i] == BiomeGenBaseMoho.mohoLavaSea) {
                hasLavaSea = true;
            }
            if (this.biomesForGeneration[i] == BiomeGenBaseMoho.mohoPlateau) {
                hasPlateau = true;
            }
            if (hasLavaSea && hasPlateau) break;
        }
        if (hasLavaSea) {
            this.noise.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        if (hasPlateau) {
            this.plateau.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.caveGenV2.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.rgen.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.smallCrater.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.largeCrater.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.volcano.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }
}

