/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.dim.trait.CelestialBodyTrait;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class SolarSystemWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "SolarSystemData";
    private Random rand = new Random();
    private HashMap<String, HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait>> traitMap = new HashMap();
    private HashMap<ChunkCoordIntPair, OrbitalStation> stations = new HashMap();
    public static HashMap<String, HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait>> clientTraits = new HashMap();

    public SolarSystemWorldSavedData(String name) {
        super(name);
    }

    public static SolarSystemWorldSavedData get() {
        return SolarSystemWorldSavedData.get((World)DimensionManager.getWorlds()[0]);
    }

    public static SolarSystemWorldSavedData get(World world) {
        SolarSystemWorldSavedData result = (SolarSystemWorldSavedData)world.field_72988_C.func_75742_a(SolarSystemWorldSavedData.class, DATA_NAME);
        if (result == null) {
            world.field_72988_C.func_75745_a(DATA_NAME, (WorldSavedData)new SolarSystemWorldSavedData(DATA_NAME));
            result = (SolarSystemWorldSavedData)world.field_72988_C.func_75742_a(SolarSystemWorldSavedData.class, DATA_NAME);
        }
        return result;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (CelestialBody body : CelestialBody.getAllBodies()) {
            if (!nbt.func_74764_b("b_" + body.name)) continue;
            NBTTagCompound data = nbt.func_74775_l("b_" + body.name);
            HashMap traits = new HashMap();
            for (Map.Entry entry : CelestialBodyTrait.traitMap.entrySet()) {
                if (!data.func_74764_b((String)entry.getKey())) continue;
                try {
                    CelestialBodyTrait trait = (CelestialBodyTrait)((Class)entry.getValue()).newInstance();
                    trait.readFromNBT(data.func_74775_l((String)entry.getKey()));
                    traits.put(trait.getClass(), trait);
                }
                catch (Exception trait) {}
            }
            this.traitMap.put(body.name, traits);
        }
        NBTTagList stationList = nbt.func_150295_c("stations", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound stationTag = stationList.func_150305_b(i);
            int x = stationTag.func_74762_e("x");
            int z = stationTag.func_74762_e("z");
            CelestialBody orbiting = CelestialBody.getBody(stationTag.func_74779_i("orbiting"));
            CelestialBody target = CelestialBody.getBody(stationTag.func_74779_i("target"));
            OrbitalStation.StationState state = OrbitalStation.StationState.values()[stationTag.func_74762_e("state")];
            int stateTimer = stationTag.func_74762_e("stateTimer");
            int maxStateTimer = stationTag.func_74762_e("maxStateTimer");
            boolean hasStation = stationTag.func_74767_n("hasStation");
            String name = stationTag.func_74779_i("name");
            float gravityMultiplier = stationTag.func_74764_b("gravity") ? stationTag.func_74760_g("gravity") : 1.0f;
            ChunkCoordIntPair pos = new ChunkCoordIntPair(x, z);
            OrbitalStation station = new OrbitalStation(orbiting, x, z);
            station.target = target;
            station.state = state;
            station.stateTimer = stateTimer;
            station.maxStateTimer = maxStateTimer;
            station.hasStation = hasStation;
            station.name = name;
            station.gravityMultiplier = gravityMultiplier;
            this.stations.put(pos, station);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        for (Map.Entry<String, HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait>> entry : this.traitMap.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            for (CelestialBodyTrait trait : entry.getValue().values()) {
                String name = (String)CelestialBodyTrait.traitMap.inverse().get(trait.getClass());
                NBTTagCompound traitData = new NBTTagCompound();
                trait.writeToNBT(traitData);
                data.func_74782_a(name, (NBTBase)traitData);
            }
            nbt.func_74782_a("b_" + entry.getKey(), (NBTBase)data);
        }
        NBTTagList stationList = new NBTTagList();
        for (OrbitalStation station : this.stations.values()) {
            NBTTagCompound stationTag = new NBTTagCompound();
            stationTag.func_74768_a("x", station.dX);
            stationTag.func_74768_a("z", station.dZ);
            stationTag.func_74778_a("orbiting", station.orbiting.name);
            stationTag.func_74778_a("target", station.target.name);
            stationTag.func_74768_a("state", station.state.ordinal());
            stationTag.func_74768_a("stateTimer", station.stateTimer);
            stationTag.func_74768_a("maxStateTimer", station.maxStateTimer);
            stationTag.func_74757_a("hasStation", station.hasStation);
            stationTag.func_74778_a("name", station.name);
            stationTag.func_74776_a("gravity", station.gravityMultiplier);
            stationList.func_74742_a((NBTBase)stationTag);
        }
        nbt.func_74782_a("stations", (NBTBase)stationList);
    }

    public void setTraits(String bodyName, CelestialBodyTrait ... traits) {
        if (traits.length == 0) {
            this.clearTraits(bodyName);
            return;
        }
        HashMap newTraits = new HashMap();
        for (CelestialBodyTrait trait : traits) {
            newTraits.put(trait.getClass(), trait);
        }
        this.traitMap.put(bodyName, newTraits);
        this.func_76185_a();
    }

    public void clearTraits(String bodyName) {
        this.traitMap.remove(bodyName);
        this.func_76185_a();
    }

    public HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> getTraits(String bodyName) {
        return this.traitMap.get(bodyName);
    }

    public HashMap<ChunkCoordIntPair, OrbitalStation> getStations() {
        return this.stations;
    }

    public OrbitalStation getStationFromPosition(int x, int z) {
        ChunkCoordIntPair pos = new ChunkCoordIntPair(MathHelper.func_76141_d((float)((float)x / 1024.0f)), MathHelper.func_76141_d((float)((float)z / 1024.0f)));
        return this.stations.get(pos);
    }

    public ChunkCoordIntPair findFreeSpace() {
        int size = SpaceConfig.maxStationDistance / 1024;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(this.rand.nextInt(size * 2) - size, this.rand.nextInt(size * 2) - size);
        for (int i = 0; this.stations.containsKey(pos) && i < 512; ++i) {
            pos = new ChunkCoordIntPair(this.rand.nextInt(size * 2) - size, this.rand.nextInt(size * 2) - size);
        }
        return pos;
    }

    public OrbitalStation addStation(CelestialBody orbiting) {
        ChunkCoordIntPair pos = this.findFreeSpace();
        return this.addStation(pos.field_77276_a, pos.field_77275_b, orbiting);
    }

    public OrbitalStation addStation(int x, int z, CelestialBody orbiting) {
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x, z);
        OrbitalStation station = this.stations.get(pos);
        if (station == null) {
            station = new OrbitalStation(orbiting, x, z);
            this.stations.put(pos, station);
        }
        this.func_76185_a();
        return station;
    }

    public static void updateClientTraits(HashMap<String, HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait>> traits) {
        clientTraits = traits;
        if (clientTraits == null) {
            clientTraits = new HashMap();
        }
    }

    public static HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> getClientTraits(String bodyName) {
        return clientTraits.get(bodyName);
    }
}

