/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Destroyed;
import com.hbm.dim.trait.CBT_Dyson;
import com.hbm.dim.trait.CBT_Impact;
import com.hbm.dim.trait.CBT_Lights;
import com.hbm.dim.trait.CBT_War;
import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.main.ModEventHandlerRenderer;
import com.hbm.main.ResourceManager;
import com.hbm.render.shader.Shader;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;

public class SkyProviderCelestial
extends IRenderHandler {
    private static final ResourceLocation planetTexture = new ResourceLocation("hbm", "textures/misc/space/planet.png");
    private static final ResourceLocation flareTexture = new ResourceLocation("hbm", "textures/misc/space/sunspike.png");
    private static final ResourceLocation nightTexture = new ResourceLocation("hbm", "textures/misc/space/night.png");
    private static final ResourceLocation digammaStar = new ResourceLocation("hbm", "textures/misc/space/star_digamma.png");
    private static final ResourceLocation lodeStar = new ResourceLocation("hbm", "textures/misc/star_lode.png");
    private static final ResourceLocation impactTexture = new ResourceLocation("hbm", "textures/misc/space/impact.png");
    private static final ResourceLocation shockwaveTexture = new ResourceLocation("hbm", "textures/particle/shockwave.png");
    private static final ResourceLocation shockFlareTexture = new ResourceLocation("hbm", "textures/particle/flare.png");
    private static final ResourceLocation ringTexture = new ResourceLocation("hbm", "textures/misc/space/rings.png");
    private static final ResourceLocation destroyedBody = new ResourceLocation("hbm", "textures/misc/space/destroyed.png");
    private static final ResourceLocation thatmoShield = new ResourceLocation("hbm", "textures/particle/cens.png");
    private static final Shader fleshShader = new Shader(new ResourceLocation("hbm", "shaders/fle.frag"));
    private static final ResourceLocation noise = new ResourceLocation("hbm", "shaders/iChannel1.png");
    protected static final Shader planetShader = new Shader(new ResourceLocation("hbm", "shaders/crescent.frag"));
    protected static final Shader swarmShader = new Shader(new ResourceLocation("hbm", "shaders/swarm.vert"), new ResourceLocation("hbm", "shaders/swarm.frag"));
    private static final ResourceLocation[] citylights = new ResourceLocation[]{new ResourceLocation("hbm", "textures/misc/space/citylights_0.png"), new ResourceLocation("hbm", "textures/misc/space/citylights_1.png"), new ResourceLocation("hbm", "textures/misc/space/citylights_2.png"), new ResourceLocation("hbm", "textures/misc/space/citylights_3.png")};
    private static final ResourceLocation defaultMask = new ResourceLocation("hbm", "textures/misc/space/default_mask.png");
    private static final String[] GL_SKY_LIST = new String[]{"glSkyList", "field_72771_w", "G"};
    private static final String[] GL_SKY_LIST2 = new String[]{"glSkyList2", "field_72781_x", "H"};
    public static boolean displayListsInitialized = false;
    public static int glSkyList;
    public static int glSkyList2;
    private static boolean gl13;
    private static int lastBrightestPixel;

    public SkyProviderCelestial() {
        if (!displayListsInitialized) {
            this.initializeDisplayLists();
        }
    }

    private void initializeDisplayLists() {
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        Minecraft mc = Minecraft.func_71410_x();
        glSkyList = (Integer)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)mc.field_71438_f, (String[])GL_SKY_LIST);
        glSkyList2 = (Integer)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)mc.field_71438_f, (String[])GL_SKY_LIST2);
        gl13 = contextcapabilities.OpenGL13;
        displayListsInitialized = true;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (!(world.field_73011_w instanceof WorldProviderCelestial)) {
            return;
        }
        WorldProviderCelestial celestialProvider = (WorldProviderCelestial)world.field_73011_w;
        if (lastBrightestPixel != mc.field_71460_t.field_78504_Q[255] + mc.field_71460_t.field_78504_Q[250]) {
            if (celestialProvider.updateLightmap(mc.field_71460_t.field_78504_Q)) {
                mc.field_71460_t.field_78513_d.func_110564_a();
            }
            lastBrightestPixel = mc.field_71460_t.field_78504_Q[255] + mc.field_71460_t.field_78504_Q[250];
        }
        float fogIntensity = ModEventHandlerRenderer.lastFogDensity * 30.0f;
        CelestialBody body = CelestialBody.getBody((World)world);
        CelestialBody sun = body.getStar();
        CBT_Atmosphere atmosphere = body.getTrait(CBT_Atmosphere.class);
        boolean hasAtmosphere = atmosphere != null;
        float pressure = hasAtmosphere ? (float)atmosphere.getPressure() : 0.0f;
        float visibility = hasAtmosphere ? MathHelper.func_76131_a((float)(2.0f - pressure), (float)0.1f, (float)1.0f) : 1.0f;
        GL11.glDisable((int)3553);
        Vec3 skyColor = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float skyR = (float)skyColor.field_72450_a;
        float skyG = (float)skyColor.field_72448_b;
        float skyB = (float)skyColor.field_72449_c;
        if (mc.field_71451_h.field_70163_u > 300.0) {
            double curvature = MathHelper.func_76131_a((float)((800.0f - (float)mc.field_71451_h.field_70163_u) / 500.0f), (float)0.0f, (float)1.0f);
            skyR = (float)((double)skyR * curvature);
            skyG = (float)((double)skyG * curvature);
            skyB = (float)((double)skyB * curvature);
        }
        if (mc.field_71474_y.field_74337_g) {
            float[] anaglyphColor = this.applyAnaglyph(skyR, skyG, skyB);
            skyR = anaglyphColor[0];
            skyG = anaglyphColor[1];
            skyB = anaglyphColor[2];
        }
        float planetR = skyR;
        float planetG = skyG;
        float planetB = skyB;
        if (fogIntensity > 0.01f) {
            Vec3 fogColor = world.func_72948_g(partialTicks);
            planetR = (float)BobMathUtil.clampedLerp(skyR, fogColor.field_72450_a, fogIntensity);
            planetG = (float)BobMathUtil.clampedLerp(skyG, fogColor.field_72448_b, fogIntensity);
            planetB = (float)BobMathUtil.clampedLerp(skyB, fogColor.field_72449_c, fogIntensity);
        }
        Vec3 planetTint = Vec3.func_72443_a((double)planetR, (double)planetG, (double)planetB);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        GL11.glPushAttrib((int)128);
        GL11.glFogf((int)2915, (float)0.0f);
        GL11.glFogf((int)2916, (float)(Math.min(12.0f, (float)mc.field_71474_y.field_151451_c) * 16.0f));
        GL11.glCallList((int)glSkyList);
        GL11.glPopAttrib();
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float starBrightness = world.func_72880_h(partialTicks) * visibility;
        float solarAngle = world.func_72826_c(partialTicks);
        float siderealAngle = (float)SolarSystem.calculateSiderealAngle((World)world, partialTicks, body);
        this.renderSunset(partialTicks, world, mc);
        this.renderStars(partialTicks, world, mc, starBrightness, solarAngle + siderealAngle, body.axialTilt);
        GL11.glPushMatrix();
        GL11.glRotatef((float)body.axialTilt, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(solarAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDigamma(partialTicks, world, mc, solarAngle);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        double sunSize = SolarSystem.calculateSunSize(body) * 4.0;
        double coronaSize = sunSize * (double)(3.0f - MathHelper.func_76131_a((float)pressure, (float)0.0f, (float)1.0f));
        this.renderSun(partialTicks, world, mc, sun, sunSize, coronaSize, visibility, pressure);
        float blendAmount = hasAtmosphere ? MathHelper.func_76131_a((float)(1.0f - world.getSunBrightnessFactor(partialTicks)), (float)0.25f, (float)1.0f) : 1.0f;
        this.renderCelestials(partialTicks, world, mc, celestialProvider.metrics, solarAngle, null, planetTint, visibility, blendAmount, null, 24.0f);
        GL11.glEnable((int)3042);
        if (visibility > 0.2f) {
            if (world.field_73011_w.field_76574_g == 0) {
                Satellite.renderDefault(partialTicks, world, mc, solarAngle, 1916169L, new float[]{1.0f, 0.534f, 0.385f, 1.0f});
            }
            for (Map.Entry<Integer, Satellite> satelliteEntry : SatelliteSavedData.getClientSats().entrySet()) {
                satelliteEntry.getValue().render(partialTicks, world, mc, solarAngle, satelliteEntry.getKey().intValue());
            }
        }
        GL11.glPopMatrix();
        this.render3DModel(partialTicks, world, mc);
        CBT_War war = body.getTrait(CBT_War.class);
        if (war != null) {
            for (int i = 0; i < war.getProjectiles().size(); ++i) {
                CBT_War.Projectile projectile = war.getProjectiles().get(i);
                float thing = projectile.getFlashtime() + partialTicks;
                if (!(projectile.getTravel() <= 0.0f)) continue;
                float alpd = 1.0f - Math.min(1.0f, thing / 100.0f);
                GL11.glPushMatrix();
                this.render3DModel(partialTicks, world, mc);
                GL11.glTranslated((double)(projectile.getTranslateX() + 70.0), (double)projectile.getTranslateY(), (double)(projectile.getTranslateZ() + 50.0));
                GL11.glScaled((double)thing, (double)thing, (double)thing);
                GL11.glRotated((double)90.0, (double)-10.0, (double)-1.0, (double)50.0);
                GL11.glRotated((double)20.0, (double)-0.0, (double)-1.0, (double)1.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpd);
                mc.field_71446_o.func_110577_a(shockwaveTexture);
                ResourceManager.plane.renderAll();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(projectile.getTranslateX() + 70.0), (double)projectile.getTranslateY(), (double)(projectile.getTranslateZ() + 50.0));
                GL11.glScaled((double)(thing * 0.4f), (double)(thing * 0.4f), (double)(thing * 0.4f));
                GL11.glRotated((double)90.0, (double)-10.0, (double)-1.0, (double)50.0);
                GL11.glRotated((double)20.0, (double)-0.0, (double)-1.0, (double)1.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpd);
                mc.field_71446_o.func_110577_a(thatmoShield);
                ResourceManager.plane.renderAll();
                GL11.glPopMatrix();
            }
        }
        if (body.hasRings) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(body.axialTilt - body.ringTilt), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-100.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderRings(partialTicks, world, mc, body.ringTilt, body.ringColor, 200.0f, visibility);
            GL11.glPopMatrix();
        }
        this.renderSpecialEffects(partialTicks, world, mc);
        CelestialBodyTrait.CBT_COMPROMISED compromised = body.getTrait(CelestialBodyTrait.CBT_COMPROMISED.class);
        if (compromised != null) {
            GL11.glPushMatrix();
            float time = ((float)world.func_72820_D() + partialTicks) * 0.2f;
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            fleshShader.use();
            GL11.glScaled((double)194.5, (double)70.5, (double)94.5);
            GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            mc.field_71446_o.func_110577_a(noise);
            ResourceManager.sphere_v2.renderAll();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            fleshShader.setUniform1f("iTime", time * 0.05f);
            fleshShader.setUniform1i("iChannel1", 0);
            fleshShader.stop();
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        Vec3 pos = mc.field_71439_g.func_70666_h(partialTicks);
        double heightAboveHorizon = pos.field_72448_b - world.func_72919_O();
        if (heightAboveHorizon < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)glSkyList2);
            GL11.glPopMatrix();
            float f8 = 1.0f;
            float f9 = -((float)(heightAboveHorizon + 65.0));
            float opposite = -f8;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)opposite, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)opposite, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)opposite, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)opposite, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)opposite, (double)f8);
            tessellator.func_78377_a((double)f8, (double)opposite, (double)f8);
            tessellator.func_78377_a((double)f8, (double)opposite, (double)(-f8));
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(heightAboveHorizon - 16.0))), (float)0.0f);
        GL11.glCallList((int)glSkyList2);
        GL11.glPopMatrix();
        double sc = 1.0 / (pos.field_72448_b / 1000.0);
        double uvOffset = pos.field_72450_a / 1024.0 % 1.0;
        GL11.glPushMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float sunBrightness = world.func_72971_b(partialTicks);
        GL11.glColor4f((float)sunBrightness, (float)sunBrightness, (float)sunBrightness, (float)(((float)pos.field_72448_b - 200.0f) / 300.0f));
        mc.field_71446_o.func_110577_a(body.texture);
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        tessellator.func_78382_b();
        tessellator.func_78374_a(-115.0 * sc, 100.0, -115.0 * sc, 0.0 + uvOffset, 0.0);
        tessellator.func_78374_a(115.0 * sc, 100.0, -115.0 * sc, 1.0 + uvOffset, 0.0);
        tessellator.func_78374_a(115.0 * sc, 100.0, 115.0 * sc, 1.0 + uvOffset, 1.0);
        tessellator.func_78374_a(-115.0 * sc, 100.0, 115.0 * sc, 0.0 + uvOffset, 1.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glDisable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    protected void renderSunset(float partialTicks, WorldClient world, Minecraft mc) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] sunsetColor = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (sunsetColor != null) {
            float[] anaglyphColor = mc.field_71474_y.field_74337_g ? this.applyAnaglyph(sunsetColor) : sunsetColor;
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            tessellator.func_78369_a(anaglyphColor[0], anaglyphColor[1], anaglyphColor[2], sunsetColor[3]);
            tessellator.func_78377_a(0.0, 100.0, 0.0);
            tessellator.func_78369_a(sunsetColor[0], sunsetColor[1], sunsetColor[2], 0.0f);
            int segments = 16;
            for (int j = 0; j <= segments; ++j) {
                float angle = (float)j * (float)Math.PI * 2.0f / (float)segments;
                float sinAngle = MathHelper.func_76126_a((float)angle);
                float cosAngle = MathHelper.func_76134_b((float)angle);
                tessellator.func_78377_a((double)(sinAngle * 120.0f), (double)(cosAngle * 120.0f), (double)(-cosAngle * 40.0f * sunsetColor[3]));
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3553);
        }
    }

    protected void renderStars(float partialTicks, WorldClient world, Minecraft mc, float starBrightness, float siderealAngle, float axialTilt) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (starBrightness > 0.0f) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)axialTilt, (float)1.0f, (float)0.0f, (float)0.0f);
            mc.field_71446_o.func_110577_a(nightTexture);
            GL11.glBlendFunc((int)770, (int)1);
            float starBrightnessAlpha = starBrightness * 0.6f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightnessAlpha);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(siderealAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightnessAlpha);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderSkyboxSide(tessellator, 4);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderSkyboxSide(tessellator, 1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderSkyboxSide(tessellator, 0);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderSkyboxSide(tessellator, 5);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderSkyboxSide(tessellator, 2);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderSkyboxSide(tessellator, 3);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
    }

    protected void renderSun(float partialTicks, WorldClient world, Minecraft mc, CelestialBody sun, double sunSize, double coronaSize, float visibility, float pressure) {
        int swarmCount;
        Tessellator tessellator = Tessellator.field_78398_a;
        CBT_Dyson dyson = sun.getTrait(CBT_Dyson.class);
        int n = swarmCount = dyson != null ? dyson.size() : 0;
        if (sun.shader != null && sun.hasTrait(CBT_Destroyed.class)) {
            Shader shader = sun.shader;
            double shaderSize = sunSize * (double)sun.shaderScale;
            GL11.glBlendFunc((int)770, (int)771);
            shader.use();
            float time = ((float)world.func_72820_D() + partialTicks) / 20.0f;
            mc.field_71446_o.func_110577_a(noise);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            shader.setUniform1f("iTime", time);
            shader.setUniform1i("iChannel1", 0);
            tessellator.func_78382_b();
            tessellator.func_78374_a(-shaderSize, 100.0, -shaderSize, 0.0, 0.0);
            tessellator.func_78374_a(shaderSize, 100.0, -shaderSize, 1.0, 0.0);
            tessellator.func_78374_a(shaderSize, 100.0, shaderSize, 1.0, 1.0);
            tessellator.func_78374_a(-shaderSize, 100.0, shaderSize, 0.0, 1.0);
            tessellator.func_78381_a();
            shader.stop();
            GL11.glPopMatrix();
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        } else {
            float[] fArray;
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78382_b();
            tessellator.func_78377_a(-sunSize, 99.9, -sunSize);
            tessellator.func_78377_a(sunSize, 99.9, -sunSize);
            tessellator.func_78377_a(sunSize, 99.9, sunSize);
            tessellator.func_78377_a(-sunSize, 99.9, sunSize);
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78374_a(-sunSize * 0.25, 100.1, -sunSize * 0.25, 0.0, 0.0);
            tessellator.func_78374_a(sunSize * 0.25, 100.1, -sunSize * 0.25, 1.0, 0.0);
            tessellator.func_78374_a(sunSize * 0.25, 100.1, sunSize * 0.25, 1.0, 1.0);
            tessellator.func_78374_a(-sunSize * 0.25, 100.1, sunSize * 0.25, 0.0, 1.0);
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visibility);
            mc.field_71446_o.func_110577_a(SolarSystem.kerbol.texture);
            if (world.field_73011_w instanceof WorldProviderCelestial) {
                fArray = ((WorldProviderCelestial)world.field_73011_w).getSunColor();
            } else {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            }
            float[] sunColor = fArray;
            GL11.glColor4f((float)sunColor[0], (float)sunColor[1], (float)sunColor[2], (float)visibility);
            tessellator.func_78382_b();
            tessellator.func_78374_a(-sunSize, 100.0, -sunSize, 0.0, 0.0);
            tessellator.func_78374_a(sunSize, 100.0, -sunSize, 1.0, 0.0);
            tessellator.func_78374_a(sunSize, 100.0, sunSize, 1.0, 1.0);
            tessellator.func_78374_a(-sunSize, 100.0, sunSize, 0.0, 1.0);
            tessellator.func_78381_a();
            GL11.glColor4f((float)sunColor[0], (float)sunColor[1], (float)sunColor[2], (float)(1.0f - MathHelper.func_76131_a((float)pressure, (float)0.0f, (float)1.0f) * 0.75f));
            mc.field_71446_o.func_110577_a(flareTexture);
            tessellator.func_78382_b();
            tessellator.func_78374_a(-coronaSize, 99.9, -coronaSize, 0.0, 0.0);
            tessellator.func_78374_a(coronaSize, 99.9, -coronaSize, 1.0, 0.0);
            tessellator.func_78374_a(coronaSize, 99.9, coronaSize, 1.0, 1.0);
            tessellator.func_78374_a(-coronaSize, 99.9, coronaSize, 0.0, 1.0);
            tessellator.func_78381_a();
            this.renderSwarm(partialTicks, world, mc, sunSize * 0.5, swarmCount);
            GL11.glDepthMask((boolean)true);
            GL11.glClear((int)256);
            GL11.glDepthMask((boolean)false);
        }
    }

    private void renderSwarm(float partialTicks, WorldClient world, Minecraft mc, double swarmRadius, int swarmCount) {
        double z;
        double x;
        float t;
        int i;
        Tessellator tessellator = Tessellator.field_78398_a;
        swarmShader.use();
        float swarmScreenSize = (float)((double)((float)mc.field_71440_d / mc.field_71474_y.field_74334_X) * swarmRadius * 0.002);
        float time = ((float)world.func_72820_D() + partialTicks) / 800.0f;
        swarmShader.setUniform1f("iTime", time);
        int offsetLocation = swarmShader.getUniformLocation("iOffset");
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)MathHelper.func_76131_a((float)swarmScreenSize, (float)0.0f, (float)1.0f));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
        GL11.glScaled((double)swarmRadius, (double)swarmRadius, (double)swarmRadius);
        GL11.glPushMatrix();
        GL11.glRotatef((float)80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        tessellator.func_78371_b(0);
        for (i = 0; i < swarmCount; i += 3) {
            swarmShader.setUniform1f(offsetLocation, (float)i);
            t = (float)i + time;
            x = Math.cos(t);
            z = Math.sin(t);
            tessellator.func_78377_a(x, 0.0, z);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        tessellator.func_78371_b(0);
        for (i = 1; i < swarmCount; i += 3) {
            swarmShader.setUniform1f(offsetLocation, (float)i);
            t = (float)i + time;
            x = Math.cos(t);
            z = Math.sin(t);
            tessellator.func_78377_a(x, 0.0, z);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)-60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        tessellator.func_78371_b(0);
        for (i = 2; i < swarmCount; i += 3) {
            swarmShader.setUniform1f(offsetLocation, (float)i);
            t = (float)i + time;
            x = Math.cos(t);
            z = Math.sin(t);
            tessellator.func_78377_a(x, 0.0, z);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        swarmShader.stop();
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
    }

    protected void renderCelestials(float partialTicks, WorldClient world, Minecraft mc, List<SolarSystem.AstroMetric> metrics, float solarAngle, CelestialBody tidalLockedBody, Vec3 planetTint, float visibility, float blendAmount, CelestialBody orbiting, float maxSize) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float blendDarken = 0.1f;
        double transitionMinSize = 0.1;
        double transitionMaxSize = 0.5;
        for (SolarSystem.AstroMetric metric : metrics) {
            if (metric.distance == 0.0) continue;
            boolean orbitingThis = metric.body == orbiting;
            double uvOffset = orbitingThis ? 1.0 - ((double)world.func_72820_D() + (double)partialTicks) / 1024.0 % 1.0 : 0.0;
            float axialTilt = orbitingThis ? 0.0f : metric.body.axialTilt;
            GL11.glPushMatrix();
            double size = MathHelper.func_151237_a((double)metric.apparentSize, (double)0.0, (double)maxSize);
            boolean renderPoint = size < transitionMaxSize;
            boolean renderBody = size > transitionMinSize;
            GL11.glRotated((double)metric.angle, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)metric.inclination, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotatef((float)(axialTilt + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (renderBody) {
                CBT_Destroyed d;
                if (metric.body.hasRings) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)metric.body.ringColor[0], (float)metric.body.ringColor[1], (float)metric.body.ringColor[2], (float)visibility);
                    mc.field_71446_o.func_110577_a(ringTexture);
                    GL11.glDisable((int)2884);
                    double ringSize = size * (double)metric.body.ringSize;
                    GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
                    GL11.glRotated((double)(-metric.angle), (double)0.0, (double)0.0, (double)1.0);
                    GL11.glRotatef((float)(90.0f - metric.body.ringTilt), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotated((double)metric.angle, (double)0.0, (double)1.0, (double)0.0);
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-ringSize, 0.0, -ringSize, 0.0, 0.0);
                    tessellator.func_78374_a(ringSize, 0.0, -ringSize, 1.0, 0.0);
                    tessellator.func_78374_a(ringSize, 0.0, 0.0, 1.0, 0.5);
                    tessellator.func_78374_a(-ringSize, 0.0, 0.0, 0.0, 0.5);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)2884);
                    GL11.glPopMatrix();
                }
                if ((d = metric.body.getTrait(CBT_Destroyed.class)) != null) {
                    double interpr = (double)d.interp + size * 0.5;
                    float alpd = (float)(1.0 - Math.min(1.0, interpr / 100.0));
                    Random random = new Random(12L);
                    int numQuads = 30;
                    for (int i = 0; i < numQuads; ++i) {
                        double radius = random.nextDouble() * size * (double)d.interp;
                        double randomTheta = random.nextDouble() * Math.PI * 2.0;
                        double randomPhi = random.nextDouble() * Math.PI;
                        double randomX = radius * Math.sin(randomPhi) * Math.cos(randomTheta) * 0.7;
                        double randomY = radius * Math.sin(randomPhi) * Math.sin(randomTheta);
                        double randomZ = radius * Math.cos(randomPhi) * 0.7;
                        float randomRotation = random.nextFloat() * 360.0f;
                        double uMin = random.nextDouble();
                        double vMin = random.nextDouble();
                        double uMax = Math.min(uMin + random.nextDouble() * 0.2, 1.0);
                        double vMax = Math.min(vMin + random.nextDouble() * 0.2, 1.0);
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(randomX * -0.05), (double)(randomY * 0.0), (double)(randomZ * -0.05));
                        GL11.glRotatef((float)(randomRotation * d.interp * 0.05f), (float)0.0f, (float)1.0f, (float)0.0f);
                        mc.field_71446_o.func_110577_a(metric.body.texture);
                        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                        tessellator.func_78382_b();
                        double qsize = size * random.nextDouble() * 0.1;
                        tessellator.func_78374_a(-qsize, 100.0, -qsize, uMin, vMin);
                        tessellator.func_78374_a(qsize, 100.0, -qsize, uMax, vMin);
                        tessellator.func_78374_a(qsize, 100.0, qsize, uMax, vMax);
                        tessellator.func_78374_a(-qsize, 100.0, qsize, uMin, vMax);
                        tessellator.func_78381_a();
                        GL11.glPopMatrix();
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(randomX * 0.04), (double)(randomY * 0.0), (double)(randomZ * 0.04));
                        GL11.glRotatef((float)(randomRotation * d.interp * 0.05f), (float)0.0f, (float)1.0f, (float)0.0f);
                        mc.field_71446_o.func_110577_a(destroyedBody);
                        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                        tessellator.func_78382_b();
                        qsize = size * random.nextDouble() * 0.07;
                        tessellator.func_78374_a(-qsize, 100.0, -qsize, uMin, vMin);
                        tessellator.func_78374_a(qsize, 100.0, -qsize, uMax, vMin);
                        tessellator.func_78374_a(qsize, 100.0, qsize, uMax, vMax);
                        tessellator.func_78374_a(-qsize, 100.0, qsize, uMin, vMax);
                        tessellator.func_78381_a();
                        GL11.glPopMatrix();
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpd);
                    mc.field_71446_o.func_110577_a(shockwaveTexture);
                    double interpe = (double)d.interp * 0.5 * size * 0.1;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-interpe, 100.0, -interpe, 0.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(interpe, 100.0, -interpe, 1.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(interpe, 100.0, interpe, 1.0 + uvOffset, 1.0);
                    tessellator.func_78374_a(-interpe, 100.0, interpe, 0.0 + uvOffset, 1.0);
                    tessellator.func_78381_a();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpd * 2.0f));
                    mc.field_71446_o.func_110577_a(shockFlareTexture);
                    interpr = size * 3.0;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-interpr, 100.0, -interpr, 0.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(interpr, 100.0, -interpr, 1.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(interpr, 100.0, interpr, 1.0 + uvOffset, 1.0);
                    tessellator.func_78374_a(-interpr, 100.0, interpr, 0.0 + uvOffset, 1.0);
                    tessellator.func_78381_a();
                } else {
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visibility);
                    mc.field_71446_o.func_110577_a(metric.body.texture);
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-size, 100.0, -size, 0.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(size, 100.0, -size, 1.0 + uvOffset, 0.0);
                    tessellator.func_78374_a(size, 100.0, size, 1.0 + uvOffset, 1.0);
                    tessellator.func_78374_a(-size, 100.0, size, 0.0 + uvOffset, 1.0);
                    tessellator.func_78381_a();
                    CBT_Impact impact = metric.body.getTrait(CBT_Impact.class);
                    CBT_Lights light = metric.body.getTrait(CBT_Lights.class);
                    double impactTime = impact != null ? (double)((float)(world.func_82737_E() - impact.time) + partialTicks) : 0.0;
                    int lightIntensity = light != null && impactTime < 40.0 ? light.getIntensity() : 0;
                    int blackoutInterval = 8;
                    int maxBlackouts = 5;
                    int activeBlackouts = Math.min((int)(impactTime / (double)blackoutInterval), maxBlackouts);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    planetShader.use();
                    planetShader.setUniform1f("phase", (float)(-metric.phase));
                    planetShader.setUniform1f("offset", (float)uvOffset);
                    planetShader.setUniform1i("lights", 0);
                    planetShader.setUniform1i("cityMask", 1);
                    planetShader.setUniform1i("blackouts", activeBlackouts);
                    mc.field_71446_o.func_110577_a(citylights[lightIntensity]);
                    if (gl13) {
                        GL13.glActiveTexture((int)33985);
                        mc.field_71446_o.func_110577_a(metric.body.cityMask != null ? metric.body.cityMask : defaultMask);
                        GL13.glActiveTexture((int)33984);
                    }
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-size, 100.0, -size, 0.0, 0.0);
                    tessellator.func_78374_a(size, 100.0, -size, 1.0, 0.0);
                    tessellator.func_78374_a(size, 100.0, size, 1.0, 1.0);
                    tessellator.func_78374_a(-size, 100.0, size, 0.0, 1.0);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)3553);
                    planetShader.stop();
                    OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                    if (impact != null) {
                        double lavaAlpha = Math.min(impactTime * 0.1, 1.0);
                        double impactSize = impactTime * 0.1 * size * 0.035;
                        double impactAlpha = 1.0 - Math.min(1.0, impactTime * 0.0015);
                        double flareSize = size * 1.5;
                        double flareAlpha = 1.0 - Math.min(1.0, impactTime * 0.002);
                        if (lavaAlpha > 0.0) {
                            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)lavaAlpha);
                            mc.field_71446_o.func_110577_a(impactTexture);
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(-size, 100.0, -size, 0.0 + uvOffset, 0.0);
                            tessellator.func_78374_a(size, 100.0, -size, 1.0 + uvOffset, 0.0);
                            tessellator.func_78374_a(size, 100.0, size, 1.0 + uvOffset, 1.0);
                            tessellator.func_78374_a(-size, 100.0, size, 0.0 + uvOffset, 1.0);
                            tessellator.func_78381_a();
                        }
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(-size * 0.5), (double)0.0, (double)(size * 0.4));
                        if (impactAlpha > 0.0) {
                            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)impactAlpha);
                            mc.field_71446_o.func_110577_a(shockwaveTexture);
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(-impactSize, 100.0, -impactSize, 0.0, 0.0);
                            tessellator.func_78374_a(impactSize, 100.0, -impactSize, 1.0, 0.0);
                            tessellator.func_78374_a(impactSize, 100.0, impactSize, 1.0, 1.0);
                            tessellator.func_78374_a(-impactSize, 100.0, impactSize, 0.0, 1.0);
                            tessellator.func_78381_a();
                        }
                        if (flareAlpha > 0.0) {
                            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)flareAlpha);
                            mc.field_71446_o.func_110577_a(shockFlareTexture);
                            tessellator.func_78382_b();
                            tessellator.func_78374_a(-flareSize, 100.0, -flareSize, 0.0, 0.0);
                            tessellator.func_78374_a(flareSize, 100.0, -flareSize, 1.0, 0.0);
                            tessellator.func_78374_a(flareSize, 100.0, flareSize, 1.0, 1.0);
                            tessellator.func_78374_a(-flareSize, 100.0, flareSize, 0.0, 1.0);
                            tessellator.func_78381_a();
                        }
                        GL11.glPopMatrix();
                    }
                    GL11.glDisable((int)3553);
                    GL11.glColor4d((double)(planetTint.field_72450_a - (double)blendDarken), (double)(planetTint.field_72448_b - (double)blendDarken), (double)(planetTint.field_72449_c - (double)blendDarken), (double)(1.0f - blendAmount * visibility));
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-size, 100.0, -size, 0.0, 0.0);
                    tessellator.func_78374_a(size, 100.0, -size, 1.0, 0.0);
                    tessellator.func_78374_a(size, 100.0, size, 1.0, 1.0);
                    tessellator.func_78374_a(-size, 100.0, size, 0.0, 1.0);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)3553);
                }
                if (metric.body.hasRings) {
                    GL11.glColor4f((float)metric.body.ringColor[0], (float)metric.body.ringColor[1], (float)metric.body.ringColor[2], (float)visibility);
                    mc.field_71446_o.func_110577_a(ringTexture);
                    double ringSize = size * (double)metric.body.ringSize;
                    GL11.glDisable((int)2884);
                    GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
                    GL11.glRotated((double)(-metric.angle), (double)0.0, (double)0.0, (double)1.0);
                    GL11.glRotatef((float)(90.0f - metric.body.ringTilt), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotated((double)metric.angle, (double)0.0, (double)1.0, (double)0.0);
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(-ringSize, 0.0, 0.0, 0.0, 0.5);
                    tessellator.func_78374_a(ringSize, 0.0, 0.0, 1.0, 0.5);
                    tessellator.func_78374_a(ringSize, 0.0, ringSize, 1.0, 1.0);
                    tessellator.func_78374_a(-ringSize, 0.0, ringSize, 0.0, 1.0);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)2884);
                }
            }
            if (renderPoint) {
                float alpha = MathHelper.func_76131_a((float)((float)size * 100.0f), (float)0.0f, (float)1.0f);
                GL11.glColor4f((float)metric.body.color[0], (float)metric.body.color[1], (float)metric.body.color[2], (float)((alpha *= 1.0f - BobMathUtil.remap01_clamp((float)size, (float)transitionMinSize, (float)transitionMaxSize)) * visibility));
                mc.field_71446_o.func_110577_a(planetTexture);
                tessellator.func_78382_b();
                tessellator.func_78374_a(-1.0, 100.0, -1.0, 0.0, 0.0);
                tessellator.func_78374_a(1.0, 100.0, -1.0, 1.0, 0.0);
                tessellator.func_78374_a(1.0, 100.0, 1.0, 1.0, 1.0);
                tessellator.func_78374_a(-1.0, 100.0, 1.0, 0.0, 1.0);
                tessellator.func_78381_a();
            }
            GL11.glPopMatrix();
        }
    }

    protected void renderRings(float partialTicks, WorldClient world, Minecraft mc, float ringTilt, float[] ringColor, float ringSize, float visibility) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)visibility);
        mc.field_71446_o.func_110577_a(ringTexture);
        double offset = -20.0;
        tessellator.func_78382_b();
        tessellator.func_78374_a(offset, (double)(-ringSize), (double)(-ringSize), 0.0, 0.0);
        tessellator.func_78374_a(offset, (double)ringSize, (double)(-ringSize), 1.0, 0.0);
        tessellator.func_78374_a(offset, (double)ringSize, (double)ringSize, 1.0, 1.0);
        tessellator.func_78374_a(offset, (double)(-ringSize), (double)ringSize, 0.0, 1.0);
        tessellator.func_78381_a();
    }

    protected void renderDigamma(float partialTicks, WorldClient world, Minecraft mc, float solarAngle) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        float var12 = 1.0f + world.field_73012_v.nextFloat() * 0.5f;
        double dist = 100.0;
        if (ModEventHandlerClient.renderLodeStar) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-75.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(lodeStar);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-var12), dist, (double)(-var12), 0.0, 0.0);
            tessellator.func_78374_a((double)var12, dist, (double)(-var12), 0.0, 1.0);
            tessellator.func_78374_a((double)var12, dist, (double)var12, 1.0, 1.0);
            tessellator.func_78374_a((double)(-var12), dist, (double)var12, 1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float brightness = (float)Math.sin((double)solarAngle * Math.PI);
        brightness *= brightness;
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)brightness);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(solarAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(digammaStar);
        float digamma = HbmLivingProps.getDigamma((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        var12 = 1.0f * (1.0f + digamma * 0.25f);
        dist = 100.0 - (double)digamma * 2.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-var12), dist, (double)(-var12), 0.0, 0.0);
        tessellator.func_78374_a((double)var12, dist, (double)(-var12), 0.0, 1.0);
        tessellator.func_78374_a((double)var12, dist, (double)var12, 1.0, 1.0);
        tessellator.func_78374_a((double)(-var12), dist, (double)var12, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    protected float[] applyAnaglyph(float ... colors) {
        float r = (colors[0] * 30.0f + colors[1] * 59.0f + colors[2] * 11.0f) / 100.0f;
        float g = (colors[0] * 30.0f + colors[1] * 70.0f) / 100.0f;
        float b = (colors[0] * 30.0f + colors[2] * 70.0f) / 100.0f;
        return new float[]{r, g, b};
    }

    private void renderSkyboxSide(Tessellator tessellator, int side) {
        double u = (double)(side % 3) / 3.0;
        double v = (double)(side / 3) / 2.0;
        tessellator.func_78382_b();
        tessellator.func_78374_a(-100.0, -100.0, -100.0, u, v);
        tessellator.func_78374_a(-100.0, -100.0, 100.0, u, v + 0.5);
        tessellator.func_78374_a(100.0, -100.0, 100.0, u + 0.3333333333333333, v + 0.5);
        tessellator.func_78374_a(100.0, -100.0, -100.0, u + 0.3333333333333333, v);
        tessellator.func_78381_a();
    }

    protected void renderSpecialEffects(float partialTicks, WorldClient world, Minecraft mc) {
    }

    protected void render3DModel(float partialTicks, WorldClient world, Minecraft mc) {
    }

    static {
        lastBrightestPixel = 0;
    }
}

