/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.network.FluidDuctBase;
import com.hbm.interfaces.ICopiable;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class FluidDuctPaintable
extends FluidDuctBase
implements IToolable,
IBlockMultiPass,
ILookOverlay {
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlay;
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlayColor;

    public FluidDuctPaintable() {
        super(Material.field_151573_f);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPipePaintable();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("hbm:fluid_duct_paintable");
        this.overlay = reg.func_94245_a("hbm:fluid_duct_paintable_overlay");
        this.overlayColor = reg.func_94245_a("hbm:fluid_duct_paintable_color");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityPipePaintable pipe;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityPipePaintable && (pipe = (TileEntityPipePaintable)tile).block != null) {
            if (RenderBlockMultipass.currentPass == 1) {
                return this.overlay;
            }
            return pipe.block.func_149691_a(side, pipe.meta);
        }
        return RenderBlockMultipass.currentPass == 1 ? this.overlayColor : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityPipePaintable pipe;
        if (RenderBlockMultipass.currentPass == 0) {
            return 0xFFFFFF;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityPipePaintable && (pipe = (TileEntityPipePaintable)tile).block == null) {
            return pipe.getType().getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            TileEntityPipePaintable pipe;
            TileEntity tile;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            Block block = ib.field_150939_a;
            if (block.func_149686_d() && block != this && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityPipePaintable && (pipe = (TileEntityPipePaintable)tile).block == null) {
                pipe.block = block;
                pipe.meta = stack.func_77960_j() & 0xF;
                world.func_147471_g(x, y, z);
                pipe.func_70296_d();
                return true;
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, fX, fY, fZ);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntityPipePaintable pipe;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityPipePaintable && (pipe = (TileEntityPipePaintable)tile).block != null) {
            pipe.block = null;
            world.func_147471_g(x, y, z);
            pipe.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public int getPasses() {
        return 2;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityPipeBaseNT)) {
            return;
        }
        TileEntityPipeBaseNT duct = (TileEntityPipeBaseNT)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("&[" + duct.getType().getColor() + "&]" + duct.getType().getLocalizedName());
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public static class TileEntityPipePaintable
    extends TileEntityPipeBaseNT
    implements ICopiable {
        private Block block;
        private int meta;
        private Block lastBlock;
        private int lastMeta;

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.field_145850_b.field_72995_K && (this.lastBlock != this.block || this.lastMeta != this.meta)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastBlock = this.block;
                this.lastMeta = this.meta;
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int id = nbt.func_74762_e("block");
            this.block = id == 0 ? null : Block.func_149729_e((int)id);
            this.meta = nbt.func_74762_e("meta");
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.block != null) {
                nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
            }
            nbt.func_74768_a("meta", this.meta);
        }

        @Override
        public NBTTagCompound getSettings(World world, int x, int y, int z) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.block != null) {
                nbt.func_74768_a("paintblock", Block.func_149682_b((Block)this.block));
                nbt.func_74768_a("paintmeta", this.meta);
            }
            return nbt;
        }

        @Override
        public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
            if (nbt.func_74764_b("paintblock")) {
                this.block = Block.func_149729_e((int)nbt.func_74762_e("paintblock"));
                this.meta = nbt.func_74762_e("paintmeta");
            }
        }
    }
}

