/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityMachineHephaestus;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineHephaestus
extends BlockDummyable
implements ILookOverlay {
    public MachineHephaestus(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineHephaestus();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().fluid();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{11, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, (x -= dir.offsetX) + 1, y, z -= dir.offsetZ);
        this.makeExtra(world, x - 1, y, z);
        this.makeExtra(world, x, y, z + 1);
        this.makeExtra(world, x, y, z - 1);
        this.makeExtra(world, x + 1, y + 11, z);
        this.makeExtra(world, x - 1, y + 11, z);
        this.makeExtra(world, x, y + 11, z + 1);
        this.makeExtra(world, x, y + 11, z - 1);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                int[] pos = this.findCore(world, x, y, z);
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
                if (!(te instanceof TileEntityMachineHephaestus)) {
                    return false;
                }
                TileEntityMachineHephaestus heatex = (TileEntityMachineHephaestus)te;
                FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, pos[0], pos[1], pos[2], player.func_70694_bm());
                heatex.input.setTankType(type);
                heatex.func_70296_d();
                player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityMachineHephaestus)) {
            return;
        }
        TileEntityMachineHephaestus heatex = (TileEntityMachineHephaestus)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(String.format(Locale.US, "%,d", heatex.bufferedHeat) + " TU");
        for (int i = 0; i < heatex.getAllTanks().length; ++i) {
            FluidTank tank = heatex.getAllTanks()[i];
            text.add((i == 0 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + tank.getTankType().getLocalizedName() + ": " + tank.getFill() + "/" + tank.getMaxFill() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

