/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.entity.projectile.EntityBombletZeta;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.storage.TileEntityMachineFluidTank;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineFluidTank
extends BlockDummyable
implements IPersistentInfoProvider,
IToolable,
ILookOverlay {
    public MachineFluidTank(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineFluidTank();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().fluid();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 1, 1, 2, 2};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntityMachineFluidTank tank = (TileEntityMachineFluidTank)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (tank != null) {
                if (tank.hasExploded) {
                    return false;
                }
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)pos[0], (int)pos[1], (int)pos[2]);
            }
            return true;
        }
        if (player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntityMachineFluidTank tank = (TileEntityMachineFluidTank)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (tank != null) {
                if (tank.hasExploded) {
                    return false;
                }
                if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                    FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, pos[0], pos[1], pos[2], player.func_70694_bm());
                    tank.tank.setTankType(type);
                    tank.func_70296_d();
                    player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, x - dir.offsetX + 1, y, z - dir.offsetZ + 1);
        this.makeExtra(world, x - dir.offsetX + 1, y, z - dir.offsetZ - 1);
        this.makeExtra(world, x - dir.offsetX - 1, y, z - dir.offsetZ + 1);
        this.makeExtra(world, x - dir.offsetX - 1, y, z - dir.offsetZ - 1);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    @Override
    public void addInformation(ItemStack stack, NBTTagCompound persistentTag, EntityPlayer player, List list, boolean ext) {
        FluidTank tank = new FluidTank(Fluids.NONE, 0);
        tank.readFromNBT(persistentTag, "tank");
        list.add(EnumChatFormatting.YELLOW + "" + tank.getFill() + "/" + tank.getMaxFill() + "mB " + tank.getTankType().getLocalizedName());
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity core = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(core instanceof TileEntityMachineFluidTank)) {
            return;
        }
        TileEntityMachineFluidTank tank = (TileEntityMachineFluidTank)core;
        if (tank.lastExplosion == explosion) {
            return;
        }
        tank.lastExplosion = explosion;
        if (!tank.hasExploded) {
            tank.explode();
            if (explosion.field_77283_e != null && explosion.field_77283_e instanceof EntityBombletZeta) {
                if (tank.tank.getTankType().getTrait(FT_Flammable.class) == null) {
                    return;
                }
                List players = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)).func_72314_b(100.0, 100.0, 100.0));
                for (EntityPlayer p : players) {
                    p.func_71029_a((StatBase)MainRegistry.achInferno);
                }
            }
        } else {
            world.func_147449_b(pos[0], pos[1], pos[2], Blocks.field_150350_a);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 6) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return 0;
            }
            TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!(te instanceof TileEntityMachineFluidTank)) {
                return 0;
            }
            TileEntityMachineFluidTank tank = (TileEntityMachineFluidTank)te;
            return tank.getComparatorPower();
        }
        return 0;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.TORCH) {
            return false;
        }
        return IRepairable.tryRepairMultiblock(world, x, y, z, this, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        IRepairable.addGenericOverlay(event, world, x, y, z, this);
    }
}

