/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityDysonConverterAnatmogenesis;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class MachineDysonConverterAnatmogenesis
extends BlockDummyable
implements ILookOverlay,
IToolable {
    public MachineDysonConverterAnatmogenesis(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityDysonConverterAnatmogenesis();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, false, false);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 5, 5, 1, 1};
    }

    @Override
    public int getOffset() {
        return 5;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        double pressure;
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityDysonConverterAnatmogenesis)) {
            return;
        }
        TileEntityDysonConverterAnatmogenesis converter = (TileEntityDysonConverterAnatmogenesis)te;
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(world, CBT_Atmosphere.class);
        double d = pressure = atmosphere != null ? atmosphere.getPressure(converter.fluid) : 0.0;
        if (pressure < 1.0E-4) {
            pressure = 0.0;
        }
        pressure = (double)Math.round(pressure * 1000.0) / 1000.0;
        ArrayList<String> text = new ArrayList<String>();
        text.add("Current rate: " + (double)converter.gasProduced * 20.0 * 60.0 * 60.0 / 1.0E12 + "atm per hour");
        text.add("Current gas: " + converter.fluid.getLocalizedName() + " - " + pressure);
        text.add("Current mode: " + (converter.isEmitting ? "EMITTING" : "CAPTURING"));
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityDysonConverterAnatmogenesis)) {
            return false;
        }
        TileEntityDysonConverterAnatmogenesis converter = (TileEntityDysonConverterAnatmogenesis)te;
        converter.isEmitting = !converter.isEmitting;
        converter.func_70296_d();
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!(te instanceof TileEntityDysonConverterAnatmogenesis)) {
                return false;
            }
            TileEntityDysonConverterAnatmogenesis converter = (TileEntityDysonConverterAnatmogenesis)te;
            FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, x, y, z, player.func_70694_bm());
            if (type.hasTrait(FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
                converter.fluid = type;
                converter.func_70296_d();
                player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
            }
            return true;
        }
        return false;
    }
}

