/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityChungus;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineChungus
extends BlockDummyable
implements ITooltipProvider,
ILookOverlay,
IToolable {
    public MachineChungus(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityChungus();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, true, true);
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return true;
            }
            TileEntityChungus entity = (TileEntityChungus)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (entity != null && !entity.damaged) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(entity.func_145832_p() - 10));
                ForgeDirection turn = dir.getRotation(ForgeDirection.DOWN);
                int iX = entity.field_145851_c + dir.offsetX + turn.offsetX * 2;
                int iX2 = entity.field_145851_c + dir.offsetX * 2 + turn.offsetX * 2;
                int iZ = entity.field_145849_e + dir.offsetZ + turn.offsetZ * 2;
                int iZ2 = entity.field_145849_e + dir.offsetZ * 2 + turn.offsetZ * 2;
                if (!(x != iX && x != iX2 || z != iZ && z != iZ2 || y >= entity.field_145848_d + 2)) {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:block.chungusLever", 1.5f, 1.0f);
                    if (!world.field_72995_K) {
                        FluidType type = entity.tanks[0].getTankType();
                        entity.onLeverPull(type);
                        if (type == Fluids.STEAM) {
                            entity.tanks[0].setTankType(Fluids.HOTSTEAM);
                            entity.tanks[1].setTankType(Fluids.STEAM);
                            entity.tanks[0].setFill(entity.tanks[0].getFill() / 10);
                            entity.tanks[1].setFill(0);
                        } else if (type == Fluids.HOTSTEAM) {
                            entity.tanks[0].setTankType(Fluids.SUPERHOTSTEAM);
                            entity.tanks[1].setTankType(Fluids.HOTSTEAM);
                            entity.tanks[0].setFill(entity.tanks[0].getFill() / 10);
                            entity.tanks[1].setFill(0);
                        } else if (type == Fluids.SUPERHOTSTEAM) {
                            entity.tanks[0].setTankType(Fluids.ULTRAHOTSTEAM);
                            entity.tanks[1].setTankType(Fluids.SUPERHOTSTEAM);
                            entity.tanks[0].setFill(entity.tanks[0].getFill() / 10);
                            entity.tanks[1].setFill(0);
                        } else {
                            entity.tanks[0].setTankType(Fluids.STEAM);
                            entity.tanks[1].setTankType(Fluids.SPENTSTEAM);
                            entity.tanks[0].setFill(Math.min(entity.tanks[0].getFill() * 1000, entity.tanks[0].getMaxFill()));
                            entity.tanks[1].setFill(0);
                        }
                        entity.func_70296_d();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{4, 0, 10, 3, 2, 2};
    }

    @Override
    public int getOffset() {
        return 3;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 0, 3, 2, 2}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{4, -4, 0, 3, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 6, -1, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{2, 0, 10, -7, 1, 1}, (Block)this, dir);
        world.func_147465_d(x + dir.offsetX, y + 2, z + dir.offsetZ, (Block)this, dir.ordinal(), 3);
        this.makeExtra(world, x + dir.offsetX, y + 2, z + dir.offsetZ);
        this.makeExtra(world, x + dir.offsetX * (o - 10), y, z + dir.offsetZ * (o - 10));
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, x + dir.offsetX * o + side.offsetX * 2, y, z + dir.offsetZ * o + side.offsetZ * 2);
        this.makeExtra(world, x + dir.offsetX * o - side.offsetX * 2, y, z + dir.offsetZ * o - side.offsetZ * 2);
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 0, 3, 2, 2}, x, y, z, dir)) {
            return false;
        }
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{4, -4, 0, 3, 1, 1}, x, y, z, dir)) {
            return false;
        }
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 6, -1, 1, 1}, x, y, z, dir)) {
            return false;
        }
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{2, 0, 10, -7, 1, 1}, x, y, z, dir)) {
            return false;
        }
        return world.func_147439_a(x + dir.offsetX, y + 2, z + dir.offsetZ).func_149742_c(world, x + dir.offsetX, y + 2, z + dir.offsetZ);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityChungus)) {
            return;
        }
        TileEntityChungus chungus = (TileEntityChungus)te;
        if (chungus.damaged) {
            IRepairable.addGenericOverlay(event, world, x, y, z, this);
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        FluidTank tankInput = chungus.tanks[0];
        FluidTank tankOutput = chungus.tanks[1];
        FluidType inputType = tankInput.getTankType();
        FluidType outputType = Fluids.NONE;
        if (inputType.hasTrait(FT_Coolable.class)) {
            outputType = inputType.getTrait(FT_Coolable.class).coolsTo;
        }
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + inputType.getLocalizedName() + ": " + String.format(Locale.US, "%,d", tankInput.getFill()) + "/" + String.format(Locale.US, "%,d", tankInput.getMaxFill()) + "mB");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + outputType.getLocalizedName() + ": " + String.format(Locale.US, "%,d", tankOutput.getFill()) + "/" + String.format(Locale.US, "%,d", tankOutput.getMaxFill()) + "mB");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + BobMathUtil.getShortNumber(chungus.power) + "/" + BobMathUtil.getShortNumber(chungus.getMaxPower()) + "HE");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.TORCH) {
            return false;
        }
        return IRepairable.tryRepairMultiblock(world, x, y, z, this, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity core = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(core instanceof TileEntityChungus)) {
            return;
        }
        TileEntityChungus tank = (TileEntityChungus)core;
        if (tank.lastExplosion == explosion) {
            return;
        }
        tank.lastExplosion = explosion;
        if (!tank.damaged) {
            tank.damaged = true;
            tank.func_70296_d();
        } else {
            world.func_147449_b(pos[0], pos[1], pos[2], Blocks.field_150350_a);
        }
    }
}

