/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.BufPacket;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockAtmosphereEditor
extends BlockContainer
implements IToolable,
ITooltipProvider,
ILookOverlay {
    public BlockAtmosphereEditor(Material material) {
        super(material);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityAtmosphereEditor();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Use screwdriver to turn on and off");
        list.add(EnumChatFormatting.GOLD + "Use hand drill to increase/decrease throughput");
        list.add(EnumChatFormatting.GOLD + "Use defuser to switch emission/capture mode");
        list.add(EnumChatFormatting.GOLD + "Use fluid identifier to change fluid");
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        double pressure;
        if (world.field_73011_w instanceof WorldProviderOrbit) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityAtmosphereEditor)) {
            return;
        }
        TileEntityAtmosphereEditor editor = (TileEntityAtmosphereEditor)te;
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(world, CBT_Atmosphere.class);
        double d = pressure = atmosphere != null ? atmosphere.getPressure(editor.fluid) : 0.0;
        if (pressure < 1.0E-4) {
            pressure = 0.0;
        }
        pressure = (double)Math.round(pressure * 1000.0) / 1000.0;
        ArrayList<String> text = new ArrayList<String>();
        text.add("State: " + (editor.isOn ? "RUNNING" : "OFF"));
        text.add("Current gas: " + editor.fluid.getLocalizedName() + " - " + pressure);
        text.add("Current mode: " + (editor.isEmitting ? "EMITTING" : "CAPTURING"));
        text.add("Current throughput: " + Math.pow(10.0, editor.throughputFactor) / 1.0E12);
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityAtmosphereEditor)) {
            return false;
        }
        TileEntityAtmosphereEditor editor = (TileEntityAtmosphereEditor)te;
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            editor.isOn = !editor.isOn;
            editor.func_70296_d();
            return true;
        }
        if (tool == IToolable.ToolType.HAND_DRILL) {
            TileEntityAtmosphereEditor tileEntityAtmosphereEditor = editor;
            tileEntityAtmosphereEditor.throughputFactor = tileEntityAtmosphereEditor.throughputFactor + (player.func_70093_af() ? -1 : 1);
            editor.func_70296_d();
            return true;
        }
        if (tool == IToolable.ToolType.DEFUSER) {
            editor.isEmitting = !editor.isEmitting;
            editor.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof TileEntityAtmosphereEditor)) {
                return false;
            }
            TileEntityAtmosphereEditor editor = (TileEntityAtmosphereEditor)te;
            FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, x, y, z, player.func_70694_bm());
            editor.fluid = type;
            editor.func_70296_d();
            player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
            return true;
        }
        return false;
    }

    public static class TileEntityAtmosphereEditor
    extends TileEntity
    implements IBufPacketReceiver {
        private boolean isOn = false;
        private int throughputFactor = 10;
        private FluidType fluid = Fluids.AIR;
        private boolean isEmitting = true;

        public void func_145845_h() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.isOn && this.field_145850_b.func_82737_E() % 5L == 0L) {
                if (this.isEmitting) {
                    FT_Gaseous.release(this.field_145850_b, this.fluid, Math.pow(10.0, this.throughputFactor));
                } else {
                    FT_Gaseous.capture(this.field_145850_b, this.fluid, Math.pow(10.0, this.throughputFactor));
                }
            }
            PacketDispatcher.wrapper.sendToAllAround(new BufPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 25.0));
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.isOn = nbt.func_74767_n("isOn");
            this.throughputFactor = nbt.func_74762_e("throughput");
            this.fluid = Fluids.fromID(nbt.func_74762_e("fluid"));
            this.isEmitting = nbt.func_74767_n("emit");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74757_a("isOn", this.isOn);
            nbt.func_74768_a("throughput", this.throughputFactor);
            nbt.func_74768_a("fluid", this.fluid.getID());
            nbt.func_74757_a("emit", this.isEmitting);
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeBoolean(this.isOn);
            buf.writeInt(this.throughputFactor);
            buf.writeInt(this.fluid.getID());
            buf.writeBoolean(this.isEmitting);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.isOn = buf.readBoolean();
            this.throughputFactor = buf.readInt();
            this.fluid = Fluids.fromID(buf.readInt());
            this.isEmitting = buf.readBoolean();
        }
    }
}

