/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.WorldConfig;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;

public class BlockOreFluid
extends BlockOre {
    private final Block empty;
    private final ReserveType type;
    Random rand = new Random();
    private static HashMap<Block, Block> emptyToFull = new HashMap();

    public BlockOreFluid(Material mat, Block empty, ReserveType type) {
        super(mat);
        this.empty = empty;
        this.type = type;
        emptyToFull.put(empty, this);
    }

    public String getUnlocalizedReserveType() {
        switch (this.type) {
            case GAS: {
                return "_gas";
            }
            case BRINE: {
                return "_brine";
            }
        }
        return "";
    }

    public FluidType getPrimaryFluid(int meta) {
        switch (this.type) {
            case OIL: {
                if (meta == SolarSystem.Body.LAYTHE.ordinal()) {
                    return Fluids.OIL_DS;
                }
                return Fluids.OIL;
            }
            case GAS: {
                return Fluids.GAS;
            }
            case BRINE: {
                return Fluids.BRINE;
            }
            case TCRUDE: {
                return Fluids.TCRUDE;
            }
        }
        return Fluids.NONE;
    }

    public FluidType getSecondaryFluid(int meta) {
        switch (this.type) {
            case OIL: {
                return Fluids.GAS;
            }
            case GAS: {
                return Fluids.PETROLEUM;
            }
            case TCRUDE: {
                return Fluids.HGAS;
            }
        }
        return Fluids.NONE;
    }

    public int getBlockFluidAmount(int meta) {
        switch (this.type) {
            case OIL: {
                return 250;
            }
            case GAS: {
                return 100;
            }
            case TCRUDE: {
                return 70;
            }
        }
        return 0;
    }

    public int getPrimaryFluidAmount(int meta) {
        if (this.empty == null) {
            return WorldConfig.bedrockOilPerDeposit;
        }
        if (meta == SolarSystem.Body.DUNA.ordinal()) {
            return WorldConfig.dunaOilPerDeposit;
        }
        if (meta == SolarSystem.Body.LAYTHE.ordinal()) {
            return WorldConfig.laytheOilPerDeposit;
        }
        if (meta == SolarSystem.Body.EVE.ordinal()) {
            return WorldConfig.eveGasPerDeposit;
        }
        if (meta == SolarSystem.Body.MUN.ordinal()) {
            return WorldConfig.munBrinePerDeposit;
        }
        if (meta == SolarSystem.Body.MINMUS.ordinal()) {
            return WorldConfig.minmusBrinePerDeposit;
        }
        if (meta == SolarSystem.Body.IKE.ordinal()) {
            return WorldConfig.ikeBrinePerDeposit;
        }
        if (meta == SolarSystem.Body.TEKTO.ordinal()) {
            return WorldConfig.tektoOilPerDeposit;
        }
        return WorldConfig.earthOilPerDeposit;
    }

    public int getSecondaryFluidAmount(int meta) {
        if (this.empty == null) {
            return WorldConfig.bedrockGasPerDepositMin + this.rand.nextInt(WorldConfig.bedrockGasPerDepositMax - WorldConfig.bedrockGasPerDepositMin);
        }
        if (meta == SolarSystem.Body.DUNA.ordinal()) {
            return WorldConfig.dunaGasPerDepositMin + this.rand.nextInt(WorldConfig.dunaGasPerDepositMax - WorldConfig.dunaGasPerDepositMin);
        }
        if (meta == SolarSystem.Body.LAYTHE.ordinal()) {
            return WorldConfig.laytheGasPerDepositMin + this.rand.nextInt(WorldConfig.laytheGasPerDepositMax - WorldConfig.laytheGasPerDepositMin);
        }
        if (meta == SolarSystem.Body.EVE.ordinal()) {
            return WorldConfig.evePetPerDepositMin + this.rand.nextInt(WorldConfig.evePetPerDepositMax - WorldConfig.evePetPerDepositMin);
        }
        if (meta == SolarSystem.Body.TEKTO.ordinal()) {
            return WorldConfig.tektoGasPerDepositMin + this.rand.nextInt(WorldConfig.tektoGasPerDepositMax - WorldConfig.tektoGasPerDepositMin);
        }
        return WorldConfig.earthGasPerDepositMin + this.rand.nextInt(WorldConfig.earthGasPerDepositMax - WorldConfig.earthGasPerDepositMin);
    }

    private double getDrainChance(int meta) {
        if (this.empty == null) {
            return 0.0;
        }
        if (meta == SolarSystem.Body.DUNA.ordinal()) {
            return WorldConfig.dunaOilDrainChance;
        }
        if (meta == SolarSystem.Body.LAYTHE.ordinal()) {
            return WorldConfig.laytheOilDrainChance;
        }
        if (meta == SolarSystem.Body.EVE.ordinal()) {
            return WorldConfig.eveGasDrainChance;
        }
        if (meta == SolarSystem.Body.MUN.ordinal()) {
            return WorldConfig.munBrineDrainChance;
        }
        if (meta == SolarSystem.Body.MINMUS.ordinal()) {
            return WorldConfig.minmusBrineDrainChance;
        }
        if (meta == SolarSystem.Body.IKE.ordinal()) {
            return WorldConfig.ikeBrineDrainChance;
        }
        if (meta == SolarSystem.Body.TEKTO.ordinal()) {
            return WorldConfig.tektoOilDrainChance;
        }
        return WorldConfig.earthOilDrainChance;
    }

    public void drain(World world, int x, int y, int z, int meta, double chanceMultiplier) {
        if (this.empty == null) {
            return;
        }
        if (world.field_73012_v.nextDouble() < this.getDrainChance(meta) * chanceMultiplier) {
            world.func_147465_d(x, y, z, this.empty, meta, 3);
        }
    }

    public boolean requiresFracking() {
        return this.empty == null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (this.empty == null) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (world.func_147439_a(x, y - 1, z) == this.empty) {
            world.func_147465_d(x, y, z, this.empty, meta, 3);
            world.func_147465_d(x, y - 1, z, (Block)this, meta, 3);
        }
    }

    public static Block getFullBlock(Block block) {
        return emptyToFull.get(block);
    }

    public static enum ReserveType {
        OIL,
        GAS,
        BRINE,
        TCRUDE;

    }
}

