/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.SpaceConfig;
import com.hbm.dim.SolarSystem;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOre
extends Block
implements IBlockMultiPass,
IBlockMulti,
ITooltipProvider {
    protected IIcon[] stoneIcons;
    public Set<SolarSystem.Body> spawnsOn = new HashSet<SolarSystem.Body>();
    public static Map<Block, BlockOre> vanillaMap = new HashMap<Block, BlockOre>();
    public boolean allowFortune = true;

    public BlockOre(Material mat) {
        super(mat);
    }

    public static void addValidBody(Block ore, SolarSystem.Body body) {
        if (!(ore instanceof BlockOre)) {
            return;
        }
        ((BlockOre)ore).spawnsOn.add(body);
    }

    public static void addAllBodies(Block ore) {
        for (SolarSystem.Body celestial : SolarSystem.Body.values()) {
            BlockOre.addValidBody(ore, celestial);
        }
    }

    public static void addAllExcept(Block ore, SolarSystem.Body body) {
        for (SolarSystem.Body celestial : SolarSystem.Body.values()) {
            if (celestial == body) continue;
            BlockOre.addValidBody(ore, celestial);
        }
    }

    public BlockOre(Material mat, Block vanillaBlock) {
        this(mat);
        vanillaMap.put(vanillaBlock, this);
    }

    public Item func_149650_a(int i, Random rand, int j) {
        if (this == ModBlocks.ore_fluorite) {
            return ModItems.fluorite;
        }
        if (this == ModBlocks.ore_niter) {
            return ModItems.niter;
        }
        if (this == ModBlocks.ore_sulfur) {
            return ModItems.sulfur;
        }
        if (this == ModBlocks.ore_glowstone) {
            return Items.field_151114_aO;
        }
        if (this == ModBlocks.ore_fire) {
            return rand != null && rand.nextInt(10) == 0 ? ModItems.ingot_phosphorus : ModItems.powder_fire;
        }
        if (this == ModBlocks.ore_rare) {
            return ModItems.chunk_ore;
        }
        if (this == ModBlocks.ore_asbestos) {
            return ModItems.ingot_asbestos;
        }
        if (this == ModBlocks.ore_lignite) {
            return ModItems.lignite;
        }
        if (this == ModBlocks.ore_cinnebar) {
            return ModItems.cinnebar;
        }
        if (this == ModBlocks.ore_coltan) {
            return ModItems.fragment_coltan;
        }
        if (this == ModBlocks.ore_cobalt) {
            return ModItems.fragment_cobalt;
        }
        if (this == ModBlocks.ore_redstone) {
            return Items.field_151137_ax;
        }
        if (this == ModBlocks.ore_lapis) {
            return Items.field_151100_aR;
        }
        if (this == ModBlocks.ore_emerald) {
            return Items.field_151166_bC;
        }
        if (this == ModBlocks.ore_quartz) {
            return Items.field_151128_bU;
        }
        if (this == ModBlocks.ore_diamond) {
            return Items.field_151045_i;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(Random rand) {
        if (this == ModBlocks.ore_fluorite) {
            return 2 + rand.nextInt(3);
        }
        if (this == ModBlocks.ore_niter) {
            return 2 + rand.nextInt(3);
        }
        if (this == ModBlocks.ore_sulfur) {
            return 2 + rand.nextInt(3);
        }
        if (this == ModBlocks.ore_glowstone) {
            return 1 + rand.nextInt(3);
        }
        if (this == ModBlocks.ore_cobalt) {
            return 4 + rand.nextInt(6);
        }
        if (this == ModBlocks.ore_redstone) {
            return 4 + rand.nextInt(2);
        }
        if (this == ModBlocks.ore_lapis) {
            return 4 + rand.nextInt(5);
        }
        return 1;
    }

    public BlockOre noFortune() {
        this.allowFortune = false;
        return this;
    }

    public int func_149679_a(int fortune, Random rand) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_149650_a(0, rand, fortune) && this.allowFortune) {
            int mult = rand.nextInt(fortune + 2) - 1;
            if (mult < 0) {
                mult = 0;
            }
            return this.func_149745_a(rand) * (mult + 1);
        }
        return this.func_149745_a(rand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.stoneIcons = new IIcon[SolarSystem.Body.values().length];
        this.stoneIcons[0] = reg.func_94245_a("stone");
        for (int i = 1; i < SolarSystem.Body.values().length; ++i) {
            SolarSystem.Body body = SolarSystem.Body.values()[i];
            this.stoneIcons[i] = reg.func_94245_a(body.getStoneTexture());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (RenderBlockMultipass.currentPass == 0) {
            int meta = world.func_72805_g(x, y, z);
            return this.stoneIcons[meta % this.stoneIcons.length];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (RenderBlockMultipass.currentPass == 0) {
            return this.stoneIcons[meta % this.stoneIcons.length];
        }
        return this.field_149761_L;
    }

    public int func_149692_a(int meta) {
        if (this == ModBlocks.ore_rare) {
            return ItemEnums.EnumChunkType.RARE.ordinal();
        }
        if (this == ModBlocks.ore_lapis) {
            return 4;
        }
        if (this.func_149650_a(0, null, 0) != Item.func_150898_a((Block)this)) {
            return 0;
        }
        return this.rectify(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getSubCount(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (!SpaceConfig.showOreLocations) {
            return;
        }
        if (this.spawnsOn.isEmpty()) {
            return;
        }
        if (this.spawnsOn.size() == SolarSystem.Body.values().length) {
            list.add(EnumChatFormatting.GOLD + "Can be found anywhere");
            return;
        }
        if (this.spawnsOn.size() == SolarSystem.Body.values().length - 1) {
            list.add(EnumChatFormatting.GOLD + "Can be found anywhere except:");
            for (SolarSystem.Body body : SolarSystem.Body.values()) {
                if (this.spawnsOn.contains((Object)body)) continue;
                list.add(EnumChatFormatting.RED + " - " + I18nUtil.resolveKey("body." + body.name, new Object[0]));
            }
            return;
        }
        list.add(EnumChatFormatting.GOLD + "Can be found on:");
        for (SolarSystem.Body body : this.spawnsOn) {
            list.add(EnumChatFormatting.AQUA + " - " + I18nUtil.resolveKey("body." + body.name, new Object[0]));
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        if (this == ModBlocks.ore_australium) {
            return EnumRarity.uncommon;
        }
        if (this == ModBlocks.ore_rare) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int meta = stack.func_77960_j();
        world.func_72921_c(x, y, z, meta, 2);
    }

    @Override
    public int getPasses() {
        return 2;
    }

    @Override
    public boolean shouldRenderItemMulti() {
        return true;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Override
    public int getSubCount() {
        return SolarSystem.Body.values().length;
    }
}

