/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ILookOverlay;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.machine.TileEntityAirPump;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockAirPump
extends BlockContainer
implements ILookOverlay,
IBlockSealable {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public BlockAirPump(Material p_i45386_1_) {
        super(p_i45386_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("hbm:vent_chlorine_seal_top");
        this.field_149761_L = iconRegister.func_94245_a("hbm:vent_chlorine_seal_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 1 ? this.iconTop : this.field_149761_L;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityAirPump();
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityAirPump)) {
            return;
        }
        TileEntityAirPump pump = (TileEntityAirPump)tile;
        CBT_Atmosphere atmosphere = pump.currentAtmosphere;
        ArrayList<String> text = new ArrayList<String>();
        text.add(I18nUtil.resolveKey("hbmfluid." + pump.tank.getTankType().getName().toLowerCase(), new Object[0]) + ": " + pump.tank.getFill() + "/" + pump.tank.getMaxFill() + "mB");
        if (pump.tank.getFill() <= 10) {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noTank", new Object[0]) + " ! ! !");
        } else if (!pump.hasSeal()) {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noSeal", new Object[0]) + " ! ! !");
        }
        text.add(I18nUtil.resolveKey("atmosphere.name", new Object[0]) + ": ");
        boolean hasPressure = false;
        if (atmosphere != null) {
            for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
                if (!(entry.pressure > 0.01)) continue;
                double pressure = BobMathUtil.roundDecimal(entry.pressure, 3);
                text.add(EnumChatFormatting.AQUA + " - " + I18nUtil.resolveKey("hbmfluid." + entry.fluid.getName().toLowerCase(), new Object[0]) + " - " + pressure + "atm");
                hasPressure = true;
            }
        }
        if (!hasPressure) {
            text.add(EnumChatFormatting.AQUA + " - " + I18nUtil.resolveKey("atmosphere.vacuum", new Object[0]));
        }
        if (pump.isRecycling()) {
            text.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("atmosphere.recycling", new Object[0]));
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        FluidType type;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityAirPump)) {
            return false;
        }
        TileEntityAirPump pump = (TileEntityAirPump)tile;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier && (type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, x, y, z, player.func_70694_bm())).hasTrait(FT_Gaseous.class)) {
            pump.tank.setTankType(type);
            pump.func_70296_d();
            player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
        }
        return true;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z) {
        return false;
    }
}

