/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ModBlocks;
import com.hbm.dim.tekto.TTree;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.atmosphere.IPlantableBreathing;
import com.hbm.inventory.fluid.Fluids;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockNTSapling
extends BlockSapling
implements IBlockMulti,
IPlantableBreathing {
    private IIcon[] textures;

    @Override
    public boolean canBreathe(CBT_Atmosphere atmosphere) {
        return atmosphere != null && (atmosphere.hasFluid(Fluids.TEKTOAIR, 0.1) || atmosphere.hasFluid(Fluids.CHLORINE, 0.1));
    }

    protected boolean func_149854_a(Block block) {
        return block == ModBlocks.rubber_silt || block == ModBlocks.rubber_grass || block == ModBlocks.rubber_farmland;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[EnumSapling.values().length];
        for (int i = 0; i < EnumSapling.values().length; ++i) {
            EnumSapling sapling = EnumSapling.values()[i];
            this.textures[i] = iconRegister.func_94245_a("hbm:sapling_" + sapling.name().toLowerCase(Locale.US));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[meta];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumSapling.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return soil == ModBlocks.rubber_grass || soil == ModBlocks.rubber_silt || soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(7) == 0) {
            this.func_149878_d(world, x, y, z, random);
        }
    }

    public void func_149878_d(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        TTree treeGen = new TTree(true, 3, 4, 6, 3, 2, false, ModBlocks.vinyl_log, ModBlocks.pet_leaves);
        switch (meta) {
            case 0: {
                treeGen = new TTree(false, 2, 4, 5, 3, 2, false, ModBlocks.vinyl_log, ModBlocks.pet_leaves);
                break;
            }
            case 1: {
                treeGen = new TTree(true, 2, 5, 7, 4, 3, false, ModBlocks.pvc_log, ModBlocks.rubber_leaves);
            }
        }
        if (treeGen != null) {
            world.func_147468_f(x, y, z);
            if (!treeGen.func_76484_a(world, rand, x, y, z)) {
                world.func_147465_d(x, y, z, (Block)this, meta, 2);
            }
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, stack.func_77960_j(), 2);
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        this.func_149878_d(world, x, y, z, random);
    }

    @Override
    public int getSubCount() {
        return EnumSapling.values().length;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        EnumSapling sapling = EnumSapling.values()[stack.func_77960_j()];
        return super.func_149739_a() + "_" + sapling.name().toLowerCase(Locale.US);
    }

    public static enum EnumSapling {
        VINYL,
        PVC;

    }
}

