/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import com.hbm.blocks.ModBlocks;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.atmosphere.IPlantableBreathing;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrop
extends BlockBush
implements IGrowable,
IPlantableBreathing {
    protected int maxGrowthStage = 7;
    protected Block soilBlock;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] blockIcons;
    private Predicate<CBT_Atmosphere> atmospherePredicate;
    public boolean canHydro;

    public BlockCrop(Block block, Predicate<CBT_Atmosphere> atmospherePredicate, boolean canHydro) {
        this.func_149675_a(true);
        float f = 0.5f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149649_H();
        this.soilBlock = block;
        this.atmospherePredicate = atmospherePredicate;
        this.canHydro = canHydro;
    }

    @Override
    public boolean canBreathe(CBT_Atmosphere atmosphere) {
        if (atmosphere == null) {
            return false;
        }
        return this.atmospherePredicate.test(atmosphere);
    }

    protected boolean func_149854_a(Block block) {
        return block == this.soilBlock;
    }

    public void incrementGrowStage(World world, Random rand, int x, int y, int z) {
        int growStage = world.func_72805_g(x, y, z) + MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        if (growStage > this.maxGrowthStage) {
            growStage = this.maxGrowthStage;
        }
        world.func_72921_c(x, y, z, growStage, 2);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (this == ModBlocks.crop_strawberry) {
            return ModItems.strawberry;
        }
        if (this == ModBlocks.crop_coffee) {
            return ModItems.bean_raw;
        }
        if (this == ModBlocks.crop_tea) {
            return meta == 7 ? ModItems.tea_leaf : ModItems.teaseeds;
        }
        if (this == ModBlocks.crop_paraffin) {
            return ModItems.paraffin_seeds;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149645_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int growthStage) {
        return this.blockIcons[growthStage];
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, BlockCrop.func_149729_e((int)0), 0, 2);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        int growStage = world.func_72805_g(x, y, z) + 1;
        if (growStage > 7) {
            growStage = 7;
        }
        world.func_72921_c(x, y, z, growStage, 2);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean p_149851_5_) {
        return world.func_72805_g(x, y, z) != 7;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.incrementGrowStage(world, rand, x, y, z);
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        if (meta == 7) {
            return 4;
        }
        return meta / 2;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        int i;
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (this == ModBlocks.crop_tea && metadata >= 7) {
            for (i = 0; i < 3 + fortune; ++i) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(new ItemStack(ModItems.teaseeds, 1, 0));
            }
        }
        if (this == ModBlocks.crop_paraffin && metadata >= 7) {
            for (i = 0; i < 3 + fortune; ++i) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(new ItemStack(ModItems.paraffin_seeds));
                ret.add(new ItemStack(ModItems.oil_tar, 1, ItemEnums.EnumTarType.WAX.ordinal()));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister parIIconRegister) {
        this.blockIcons = new IIcon[this.maxGrowthStage + 2];
        this.blockIcons[0] = parIIconRegister.func_94245_a(this.func_149641_N() + "_1");
        this.blockIcons[1] = parIIconRegister.func_94245_a(this.func_149641_N() + "_1");
        this.blockIcons[2] = parIIconRegister.func_94245_a(this.func_149641_N() + "_2");
        this.blockIcons[3] = parIIconRegister.func_94245_a(this.func_149641_N() + "_2");
        this.blockIcons[4] = parIIconRegister.func_94245_a(this.func_149641_N() + "_3");
        this.blockIcons[5] = parIIconRegister.func_94245_a(this.func_149641_N() + "_3");
        this.blockIcons[6] = parIIconRegister.func_94245_a(this.func_149641_N() + "_4");
        this.blockIcons[7] = parIIconRegister.func_94245_a(this.func_149641_N() + "_5");
        this.blockIcons[8] = parIIconRegister.func_94245_a(this.func_149641_N() + "_5");
    }
}

