/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.ntl;

import api.hbm.ntl.StorageStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StorageManifest {
    public HashMap<Integer, MetaNode> itemMeta = new HashMap();

    public void writeStack(ItemStack stack) {
        NBTNode nbt;
        int id = Item.func_150891_b((Item)stack.func_77973_b());
        MetaNode meta = this.itemMeta.get(id);
        if (meta == null) {
            meta = new MetaNode();
            this.itemMeta.put(id, meta);
        }
        if ((nbt = meta.metaNBT.get(stack.func_77960_j())) == null) {
            nbt = new NBTNode();
            meta.metaNBT.put(stack.func_77960_j(), nbt);
        }
        NBTTagCompound compound = stack.func_77942_o() ? (NBTTagCompound)stack.field_77990_d.func_74737_b() : null;
        long amount = nbt.nbtAmount.containsKey(compound) ? nbt.nbtAmount.get(compound) : 0L;
        nbt.nbtAmount.put(compound, amount += (long)stack.field_77994_a);
    }

    public List<StorageStack> getStacks() {
        ArrayList<StorageStack> stacks = new ArrayList<StorageStack>();
        for (Map.Entry<Integer, MetaNode> itemNode : this.itemMeta.entrySet()) {
            for (Map.Entry<Integer, NBTNode> metaNode : itemNode.getValue().metaNBT.entrySet()) {
                for (Map.Entry<NBTTagCompound, Long> nbtNode : metaNode.getValue().nbtAmount.entrySet()) {
                    ItemStack itemStack = new ItemStack(Item.func_150899_d((int)itemNode.getKey()), 1, metaNode.getKey().intValue());
                    itemStack.field_77990_d = nbtNode.getKey();
                    StorageStack stack = new StorageStack(itemStack, nbtNode.getValue());
                    stacks.add(stack);
                }
            }
        }
        return stacks;
    }

    public class NBTNode {
        public HashMap<NBTTagCompound, Long> nbtAmount = new HashMap();
    }

    public class MetaNode {
        public HashMap<Integer, NBTNode> metaNBT = new HashMap();
    }
}

