/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluidmk2;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.FluidNode;
import api.hbm.fluidmk2.IFluidProviderMK2;
import api.hbm.fluidmk2.IFluidReceiverMK2;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.uninos.NodeNet;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FluidNetMK2
extends NodeNet<IFluidReceiverMK2, IFluidProviderMK2, FluidNode> {
    public long fluidTracker = 0L;
    protected static int timeout = 3000;
    protected static long currentTime = 0L;
    protected FluidType type;
    public long[] fluidAvailable = new long[6];
    public List<Tuple.Pair<IFluidProviderMK2, Long>>[] providers = new ArrayList[6];
    public long[][] fluidDemand = new long[6][IEnergyReceiverMK2.ConnectionPriority.values().length];
    public List<Tuple.Pair<IFluidReceiverMK2, Long>>[][] receivers = new ArrayList[6][IEnergyReceiverMK2.ConnectionPriority.values().length];
    public long[] transfered = new long[6];

    public FluidNetMK2(FluidType type) {
        int i;
        this.type = type;
        for (i = 0; i < 6; ++i) {
            this.providers[i] = new ArrayList<Tuple.Pair<IFluidProviderMK2, Long>>();
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < IEnergyReceiverMK2.ConnectionPriority.values().length; ++j) {
                this.receivers[i][j] = new ArrayList<Tuple.Pair<IFluidReceiverMK2, Long>>();
            }
        }
    }

    @Override
    public void resetTrackers() {
        this.fluidTracker = 0L;
    }

    @Override
    public void update() {
        if (this.providerEntries.isEmpty()) {
            return;
        }
        if (this.receiverEntries.isEmpty()) {
            return;
        }
        currentTime = System.currentTimeMillis();
        this.setupFluidProviders();
        this.setupFluidReceivers();
        this.transferFluid();
        this.cleanUp();
    }

    public void setupFluidProviders() {
        Iterator iterator = this.providerEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (currentTime - (Long)entry.getValue() > (long)timeout || FluidNetMK2.isBadLink(entry.getKey())) {
                iterator.remove();
                continue;
            }
            IFluidProviderMK2 provider = (IFluidProviderMK2)entry.getKey();
            int[] pressureRange = provider.getProvidingPressureRange(this.type);
            int p = pressureRange[0];
            while (p <= pressureRange[1]) {
                long available = Math.min(provider.getFluidAvailable(this.type, p), provider.getProviderSpeed(this.type, p));
                this.providers[p].add(new Tuple.Pair<IFluidProviderMK2, Long>(provider, available));
                int n = p++;
                this.fluidAvailable[n] = this.fluidAvailable[n] + available;
            }
        }
    }

    public void setupFluidReceivers() {
        Iterator iterator = this.receiverEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (currentTime - (Long)entry.getValue() > (long)timeout || FluidNetMK2.isBadLink(entry.getKey())) {
                iterator.remove();
                continue;
            }
            IFluidReceiverMK2 receiver = (IFluidReceiverMK2)entry.getKey();
            int[] pressureRange = receiver.getReceivingPressureRange(this.type);
            for (int p = pressureRange[0]; p <= pressureRange[1]; ++p) {
                long required = Math.min(receiver.getDemand(this.type, p), receiver.getReceiverSpeed(this.type, p));
                int priority = receiver.getFluidPriority().ordinal();
                this.receivers[p][priority].add(new Tuple.Pair<IFluidReceiverMK2, Long>(receiver, required));
                long[] lArray = this.fluidDemand[p];
                int n = priority;
                lArray[n] = lArray[n] + required;
            }
        }
    }

    public void transferFluid() {
        int p;
        long[] received = new long[6];
        long[] notAccountedFor = new long[6];
        for (p = 0; p <= 5; ++p) {
            long totalAvailable = this.fluidAvailable[p];
            for (int i = IEnergyReceiverMK2.ConnectionPriority.values().length - 1; i >= 0; --i) {
                long toTransfer = Math.min(this.fluidDemand[p][i], totalAvailable);
                if (toTransfer <= 0L) continue;
                long priorityDemand = this.fluidDemand[p][i];
                for (Tuple.Pair<IFluidReceiverMK2, Long> entry : this.receivers[p][i]) {
                    double weight = (double)entry.getValue().longValue() / (double)priorityDemand;
                    long toSend = (long)Math.max((double)toTransfer * weight, 0.0);
                    toSend -= entry.getKey().transferFluid(this.type, p, toSend);
                    int n = p;
                    received[n] = received[n] + toSend;
                    this.fluidTracker += toSend;
                }
                totalAvailable -= received[p];
            }
            notAccountedFor[p] = received[p];
        }
        for (p = 0; p <= 5; ++p) {
            for (Tuple.Pair<IFluidProviderMK2, Long> entry : this.providers[p]) {
                double weight = (double)entry.getValue().longValue() / (double)this.fluidAvailable[p];
                long toUse = (long)Math.max((double)received[p] * weight, 0.0);
                entry.getKey().useUpFluid(this.type, p, toUse);
                int n = p;
                notAccountedFor[n] = notAccountedFor[n] - toUse;
            }
        }
        for (p = 0; p <= 5; ++p) {
            for (int iterationsLeft = 100; iterationsLeft > 0 && notAccountedFor[p] > 0L && this.providers[p].size() > 0; --iterationsLeft) {
                Tuple.Pair<IFluidProviderMK2, Long> selected = this.providers[p].get(rand.nextInt(this.providers[p].size()));
                IFluidProviderMK2 scapegoat = selected.getKey();
                long toUse = Math.min(notAccountedFor[p], scapegoat.getFluidAvailable(this.type, p));
                scapegoat.useUpFluid(this.type, p, toUse);
                int n = p;
                notAccountedFor[n] = notAccountedFor[n] - toUse;
            }
        }
    }

    public void cleanUp() {
        for (int i = 0; i < 6; ++i) {
            this.fluidAvailable[i] = 0L;
            this.providers[i].clear();
            this.transfered[i] = 0L;
            for (int j = 0; j < IEnergyReceiverMK2.ConnectionPriority.values().length; ++j) {
                this.fluidDemand[i][j] = 0L;
                this.receivers[i][j].clear();
            }
        }
    }
}

