/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energymk2;

import api.hbm.energymk2.IEnergyConductorMK2;
import api.hbm.energymk2.IEnergyHandlerMK2;
import api.hbm.energymk2.Nodespace;
import api.hbm.energymk2.PowerNetMK2;
import com.hbm.interfaces.NotableComments;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.DirPos;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@NotableComments
public interface IEnergyReceiverMK2
extends IEnergyHandlerMK2 {
    default public long transferPower(long power) {
        if (power + this.getPower() <= this.getMaxPower()) {
            this.setPower(power + this.getPower());
            return 0L;
        }
        long capacity = this.getMaxPower() - this.getPower();
        long overshoot = power - capacity;
        this.setPower(this.getMaxPower());
        return overshoot;
    }

    default public long getReceiverSpeed() {
        return this.getMaxPower();
    }

    default public void trySubscribe(World world, DirPos pos) {
        this.trySubscribe(world, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
    }

    default public void trySubscribe(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = Compat.getTileStandard(world, x, y, z);
        boolean red = false;
        if (te instanceof IEnergyConductorMK2) {
            IEnergyConductorMK2 con = (IEnergyConductorMK2)te;
            if (!con.canConnect(dir.getOpposite())) {
                return;
            }
            Nodespace.PowerNode node = Nodespace.getNode(world, x, y, z);
            if (node != null && node.net != null) {
                ((PowerNetMK2)node.net).addReceiver(this);
                red = true;
            }
        }
    }

    default public void tryUnsubscribe(World world, int x, int y, int z) {
        IEnergyConductorMK2 con;
        Nodespace.PowerNode node;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IEnergyConductorMK2 && (node = (con = (IEnergyConductorMK2)te).createNode()) != null && node.net != null) {
            ((PowerNetMK2)node.net).removeReceiver(this);
        }
    }

    default public ConnectionPriority getPriority() {
        return ConnectionPriority.NORMAL;
    }

    public static enum ConnectionPriority {
        LOWEST,
        LOW,
        NORMAL,
        HIGH,
        HIGHEST;

    }
}

