/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.patchers;

import java.util.Iterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import pl.asie.foamfix.bugfixmod.coremod.MappingRegistry;
import pl.asie.foamfix.bugfixmod.coremod.patchers.AbstractPatcher;

public class GhostBusterEarlyReturnPatcher
extends AbstractPatcher {
    private final int accessPos;
    private final int xyzStartPos;
    private final int radius;
    private final Object returnValue;
    private boolean applied;

    public GhostBusterEarlyReturnPatcher(String targetClassName, String targetMethodName, String targetMethodDesc, int accessPos, int xyzStartPos, int radius, Object returnValue) {
        super("GhostBusterFix", targetClassName, targetMethodName, targetMethodDesc);
        this.accessPos = accessPos;
        this.xyzStartPos = xyzStartPos;
        this.radius = radius;
        this.returnValue = returnValue;
    }

    public static GhostBusterEarlyReturnPatcher updateTick(String targetClassName, int radius) {
        return new GhostBusterEarlyReturnPatcher(targetClassName, MappingRegistry.getMethodNameFor("Block.updateTick"), null, 1, 2, radius, null);
    }

    @Override
    public String getPatcherName() {
        return this.patcherName + "/" + this.targetClassName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InsnList buildNewInsns(AbstractInsnNode currentInstruction, Iterator<AbstractInsnNode> instructionSet) {
        if (this.applied) {
            return null;
        }
        InsnList list = new InsnList();
        Label l = new Label();
        LabelNode ln = new LabelNode(l);
        list.add((AbstractInsnNode)new VarInsnNode(25, this.accessPos));
        list.add((AbstractInsnNode)new VarInsnNode(21, this.xyzStartPos));
        list.add((AbstractInsnNode)new VarInsnNode(21, this.xyzStartPos + 1));
        list.add((AbstractInsnNode)new VarInsnNode(21, this.xyzStartPos + 2));
        if (this.radius == 0) {
            list.add((AbstractInsnNode)new MethodInsnNode(184, "pl/asie/foamfix/ghostbuster/GhostBusterSafeAccessors", "isBlockLoaded", "(Lnet/minecraft/world/IBlockAccess;III)Z", false));
        } else {
            switch (this.radius) {
                case 1: {
                    list.add((AbstractInsnNode)new InsnNode(4));
                    break;
                }
                case 2: {
                    list.add((AbstractInsnNode)new InsnNode(5));
                    break;
                }
                case 3: {
                    list.add((AbstractInsnNode)new InsnNode(6));
                    break;
                }
                case 4: {
                    list.add((AbstractInsnNode)new InsnNode(7));
                    break;
                }
                case 5: {
                    list.add((AbstractInsnNode)new InsnNode(8));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid ghost buster radius: " + this.radius);
                }
            }
            list.add((AbstractInsnNode)new MethodInsnNode(184, "pl/asie/foamfix/ghostbuster/GhostBusterSafeAccessors", "isAreaLoaded", "(Lnet/minecraft/world/IBlockAccess;IIII)Z", false));
        }
        list.add((AbstractInsnNode)new JumpInsnNode(154, ln));
        if (this.returnValue != null) {
            if (!(this.returnValue instanceof Boolean)) throw new RuntimeException("Invalid ghost buster return value: " + this.returnValue);
            list.add((AbstractInsnNode)new InsnNode((Boolean)this.returnValue != false ? 4 : 3));
            list.add((AbstractInsnNode)new InsnNode(172));
        } else {
            list.add((AbstractInsnNode)new InsnNode(177));
        }
        list.add((AbstractInsnNode)ln);
        list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        this.successful = true;
        this.applied = true;
        this.printMessage("Added ghost buster patch (radius = " + this.radius + ") in " + this.targetMethodName);
        return list;
    }
}

