/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.nether.biome.decorator;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockNylium;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenBlockSplatter;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenHugeFungus;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenNetherGrass;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenTwistingVines;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenWeepingVines;
import ganymedes01.etfuturum.world.nether.biome.decorator.NetherBiomeDecorator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class NetherForestDecorator
extends NetherBiomeDecorator {
    private final WorldGenHugeFungus hugeFungusGenerator;
    private final WorldGenNetherGrass grassGenerator;
    private final WorldGenerator vineGenerator;
    private final WorldGenerator wartSplatterGenerator;
    private final WorldGenerator netherrackSplatterGenerator;

    private NetherForestDecorator(boolean crimson) {
        if (crimson) {
            this.hugeFungusGenerator = new WorldGenHugeFungus(false, 0, 0, ModBlocks.CRIMSON_STEM.get(), ModBlocks.NETHER_WART.get());
            this.grassGenerator = new WorldGenNetherGrass(true);
            this.vineGenerator = new WorldGenWeepingVines();
            this.wartSplatterGenerator = new WorldGenBlockSplatter(ModBlocks.NETHER_WART.get(), 0, ModBlocks.NYLIUM.get(), 0, 4);
            this.netherrackSplatterGenerator = new WorldGenBlockSplatter(Blocks.field_150424_aL, 0, ModBlocks.NYLIUM.get(), 0, 4);
        } else {
            this.hugeFungusGenerator = new WorldGenHugeFungus(false, 0, 1, ModBlocks.WARPED_STEM.get(), ModBlocks.NETHER_WART.get());
            this.grassGenerator = new WorldGenNetherGrass(false);
            this.vineGenerator = new WorldGenTwistingVines();
            this.wartSplatterGenerator = new WorldGenBlockSplatter(ModBlocks.NETHER_WART.get(), 1, ModBlocks.NYLIUM.get(), 1, 6);
            this.netherrackSplatterGenerator = new WorldGenBlockSplatter(Blocks.field_150424_aL, 0, ModBlocks.NYLIUM.get(), 1, 6);
        }
    }

    public static NetherForestDecorator newWarpedForestDecorator() {
        return new NetherForestDecorator(false);
    }

    public static NetherForestDecorator newCrimsonForestDecorator() {
        return new NetherForestDecorator(true);
    }

    @Override
    public void populate(World world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public void decorate(World world, Random rand, int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        int attempt;
        int x2 = chunkX + rand.nextInt(16) + 8;
        int y2 = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
        int z2 = chunkZ + rand.nextInt(16) + 8;
        if (this.wartSplatterGenerator != null && rand.nextBoolean()) {
            this.wartSplatterGenerator.func_76484_a(world, rand, x2, y2, z2);
        } else {
            this.netherrackSplatterGenerator.func_76484_a(world, rand, x2, y2, z2);
        }
        for (attempt = 0; attempt < 12; ++attempt) {
            x = chunkX + rand.nextInt(16) + 8;
            y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 24));
            z = chunkZ + rand.nextInt(16) + 8;
            while (y-- > 32 && world.func_147437_c(x, y, z)) {
            }
            if (!(world.func_147439_a(x, y, z) instanceof BlockNylium) || world.func_72805_g(x, y, z) != (this.hugeFungusGenerator.log == ModBlocks.CRIMSON_STEM.get() ? 0 : 1) || !world.func_147437_c(x, y + 1, z) || !this.hugeFungusGenerator.func_76484_a(world, rand, x, y + 1, z)) continue;
            this.hugeFungusGenerator.func_150524_b(world, rand, x, y + 1, z);
        }
        for (attempt = 0; attempt < 48; ++attempt) {
            x = chunkX + rand.nextInt(16) + 8;
            y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
            z = chunkZ + rand.nextInt(16) + 8;
            this.vineGenerator.func_76484_a(world, rand, x, y, z);
        }
        for (attempt = 0; attempt < 12; ++attempt) {
            x = chunkX + rand.nextInt(16) + 8;
            y = MathHelper.func_76136_a((Random)rand, (int)32, (int)(world.field_73011_w.getActualHeight() - 8));
            z = chunkZ + rand.nextInt(16) + 8;
            this.grassGenerator.func_76484_a(world, rand, x, y, z);
        }
    }
}

