/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import com.google.common.base.Objects;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class Vec3i
implements Comparable<Vec3i> {
    private final int x;
    private final int y;
    private final int z;

    public Vec3i(int xIn, int yIn, int zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
    }

    public Vec3i(double xIn, double yIn, double zIn) {
        this(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
    }

    public Vec3i(BlockPos blockpos) {
        this(blockpos.getX(), blockpos.getY(), blockpos.getZ());
    }

    public Vec3i(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vec3i)) {
            return false;
        }
        Vec3i vec3i = (Vec3i)p_equals_1_;
        return this.getX() == vec3i.getX() && this.getY() == vec3i.getY() && this.getZ() == vec3i.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vec3i vec) {
        return this.getY() == vec.getY() ? (this.getZ() == vec.getZ() ? this.getX() - vec.getX() : this.getZ() - vec.getZ()) : this.getY() - vec.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Vec3i crossProduct(Vec3i vec) {
        return new Vec3i(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public boolean isWithinDistance(Vec3i vec, double distance) {
        return this.getSquaredDistance(vec.getX(), vec.getY(), vec.getZ(), false) < distance * distance;
    }

    public double getSquaredDistance(Vec3i vec) {
        return this.getSquaredDistance(vec.getX(), vec.getY(), vec.getZ(), true);
    }

    public double getSquaredDistance(Vec3 vec) {
        return this.getSquaredDistance(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, true);
    }

    public double getSquaredDistance(Vec3i vec, boolean treatAsBlockPos) {
        return this.getSquaredDistance(vec.x, vec.y, vec.z, treatAsBlockPos);
    }

    public double getSquaredDistance(double x, double y, double z, boolean treatAsBlockPos) {
        double d = treatAsBlockPos ? 0.5 : 0.0;
        double e = (double)this.getX() + d - x;
        double f = (double)this.getY() + d - y;
        double g = (double)this.getZ() + d - z;
        return e * e + f * f + g * g;
    }

    public int manhattanDistance(Vec3i p_218139_1_) {
        float f = Math.abs(p_218139_1_.getX() - this.getX());
        float f1 = Math.abs(p_218139_1_.getY() - this.getY());
        float f2 = Math.abs(p_218139_1_.getZ() - this.getZ());
        return (int)(f + f1 + f2);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }
}

