/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration.configs;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.core.utils.Logger;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Property;

public class ConfigWorld
extends ConfigBase {
    public static boolean enableNewNether;
    public static String fossilBlockID;
    public static String amethystOuterBlockID;
    public static String amethystMiddleBlockID;
    public static RegistryMapping<Block> fossilBlock;
    public static RegistryMapping<Block> amethystOuterBlock;
    public static RegistryMapping<Block> amethystMiddleBlock;
    public static boolean enableDmgIndicator;
    public static boolean enableAirDebris;
    public static int debrisMax;
    public static int maxNetherGoldPerCluster;
    public static int maxMagmaPerCluster;
    public static int maxCopperPerCluster;
    public static int deepslateGenerationMode;
    public static int maxDeepslatePerCluster;
    public static int deepslateMaxY;
    public static boolean deepslateReplacesStones;
    public static boolean deepslateReplacesDirt;
    public static boolean enableFossils;
    public static int maxTuffPerCluster;
    public static int[] fossilDimensionBlacklist;
    public static boolean fossilDimensionBlacklistAsWhitelist;
    public static int tileReplacementMode;
    public static int maxStonesPerCluster;
    public static int smallDebrisMax;
    public static boolean enableOceanMonuments;
    public static int[] deepslateLayerDimensionBlacklist;
    public static boolean deepslateLayerDimensionBlacklistAsWhitelist;
    public static int[] replaceAllStoneWithDeepslateDimensionWhitelist;
    public static boolean enableExtraMesaGold;
    public static boolean enableMesaMineshaft;
    public static boolean enableCoarseDirtReplacement;
    public static boolean enableAmethystGeodes;
    public static int buddingAmethystMode;
    public static int amethystRarity;
    public static int amethystMaxY;
    public static int[] amethystDimensionBlacklist;
    public static boolean amethystDimensionBlacklistAsWhitelist;
    public static int cherryTreeRarity;
    public static boolean bambooWorldgen;
    public static int crimsonForestID;
    public static int warpedForestID;
    public static int soulSandValleyID;
    public static int basaltDeltasID;
    public static int netherWastesWeight;
    public static int crimsonForestWeight;
    public static int warpedForestWeight;
    public static int soulSandValleyWeight;
    public static int basaltDeltasWeight;
    public static boolean oldHuskSpawning;
    public static boolean oldStraySpawning;
    public static final String catClient = "client";
    public static final String catGeneration = "generation";
    public static final String catBiomes = "biomes";
    public static final String catMisc = "miscellaneous";

    public ConfigWorld(File file) {
        super(file);
        this.setCategoryComment(catClient, "Client-side only effects.");
        this.setCategoryComment(catGeneration, "Generation settings.");
        this.setCategoryComment(catBiomes, "Biome ID and weight settings. These do not disable the respective blocks, go to blocksitems.cfg to disable their blocks. Nether biomes can currently only be enabled via experiments.cfg");
        this.setCategoryComment(catMisc, "For things that affect the world but don't belong in any other category.");
        this.configCats.add(this.getCategory(catClient));
        this.configCats.add(this.getCategory(catGeneration));
        this.configCats.add(this.getCategory(catBiomes));
        this.configCats.add(this.getCategory(catMisc));
    }

    @Override
    protected void syncConfigOptions() {
        int oldID;
        enableDmgIndicator = this.getBoolean("enableDmgIndicator", catClient, true, "Heart Damage Indicator");
        enableAirDebris = this.getBoolean("enableAirDebris", catGeneration, false, "Can ancient debris generate next to air?");
        maxStonesPerCluster = this.getInt("maxStonesPerCluster", catGeneration, 32, 0, 64, "Max vein size for Granite/Andesite/Diorite blocks in a cluster");
        smallDebrisMax = this.getInt("smallDebrisMax", catGeneration, 2, 0, 64, "The max vein size for the first, typically smaller debris veins which generate from Y 8 to 119");
        debrisMax = this.getInt("debrisMax", catGeneration, 3, 0, 64, "The max vein size for the second, typically bigger debris veins, which generate from Y 8 to 22");
        maxNetherGoldPerCluster = this.getInt("maxNetherGoldPerCluster", catGeneration, 10, 0, 64, "Max vein size for nether gold ore blocks in a cluster");
        maxMagmaPerCluster = this.getInt("maxMagmaPerCluster", catGeneration, 33, 0, 64, "Max vein size for magma blocks in a cluster");
        maxCopperPerCluster = this.getInt("copperClusterSize", catGeneration, 8, 0, 64, "Max vein size for copper ore blocks in a cluster");
        maxDeepslatePerCluster = this.getInt("deepslateClusterSize", catGeneration, 64, 0, 128, "If deepslateGenerationMode is set to 1, this value is used to determine how big the clusters are. Otherwise this value is unused.");
        deepslateMaxY = this.getInt("deepslateMaxY", catGeneration, 22, 0, 255, "How high up deepslate and tuff goes. If deepslateGenerationMode is 0, all stone up to this y level (with a scattering effect a few blocks before then) are replaced with deepslate. If it's 1, the patches can generate to that Y level.");
        deepslateReplacesStones = this.getBoolean("deepslateReplacesStones", catGeneration, true, "Whether or not Deepslate will overwrite granite, diorite, andesite (Only works when deepslate generation mode is set to 0)");
        deepslateReplacesDirt = this.getBoolean("deepslateReplacesDirt", catGeneration, true, "Whether or not Deepslate will overwrite dirt (Only works when deepslate generation mode is set to 0)");
        deepslateGenerationMode = this.getInt("deepslateGenerationMode", catGeneration, 0, -1, 1, "If 0, deepslate replaces all stone below the specified value, with a shattering effect near the top similar to bedrock. If 1, it generates in clusters using the deepslate cluster settings. -1 disables Et Futurum deepslate generation entirely.");
        enableOceanMonuments = this.getBoolean("enableOceanMonuments", catGeneration, true, "Note: Ocean monuments currently do not have guardians");
        enableFossils = this.getBoolean("enableFossils", catGeneration, true, "");
        if (this.hasKey(catGeneration, "fossilBoneBlock")) {
            Property oldFossilIDProp = this.get(catGeneration, "fossilBoneBlock", 0);
            oldID = oldFossilIDProp.getInt();
            switch (oldID) {
                default: {
                    fossilBlockID = "etfuturum:bone";
                    break;
                }
                case 1: {
                    fossilBlockID = "netherlicious:BoneBlock";
                    break;
                }
                case 2: {
                    fossilBlockID = "uptodate:bone_block";
                }
            }
            this.getCategory(catGeneration).remove((Object)"fossilBoneBlock");
            this.get(catGeneration, "fossilBlockID", "etfuturum:bone").set(fossilBlockID);
            this.save();
        }
        fossilBlockID = this.getString("fossilBlockID", catGeneration, "etfuturum:bone", "Use a namespaced ID, + optionally meta (max 3) to choose the block that makes up fossils. The max meta is 3 because the rotations will change the meta. North/South is the meta + 4 and East/West is + 8.\nNetherlicious bone block is \"netherlicious:BoneBlock\" and UpToDate bone block is \"uptodate:bone_block\".\nIf the chosen block does not exist then fossils will not generate. If Netherlicious is installed, its bone block will be used if this is set to \"etfutrum:bone\" and Et Futurum Requiem bone blocks are disabled.");
        if (this.hasKey(catGeneration, "amethystOuterBlock")) {
            Property oldAmethystOuterIDProp = this.get(catGeneration, "amethystOuterBlock", 0);
            oldID = oldAmethystOuterIDProp.getInt();
            switch (oldID) {
                default: {
                    amethystOuterBlockID = "etfuturum:smooth_basalt";
                    break;
                }
                case 1: {
                    amethystOuterBlockID = "etfuturum:tuff";
                    break;
                }
                case 2: {
                    amethystOuterBlockID = "netherlicious:BasaltBricks:6";
                }
            }
            this.getCategory(catGeneration).remove((Object)"amethystOuterBlock");
            this.get(catGeneration, "amethystOuterBlockID", "etfuturum:bone").set(amethystOuterBlockID);
            this.save();
        }
        amethystOuterBlockID = this.getString("amethystOuterBlockID", catGeneration, "etfuturum:smooth_basalt", "Use a namespaced ID, + optionally meta (max 15) to choose the block that makes up the outer layer of amethyst geodes.\nThe outer layer was formerly \"etfuturum:tuff\" before it was changed in later 1.17 snapshots. Netherlicious smooth basalt is \"netherlicious:BasaltBricks:6\"\nIf the chosen block does not exist then amethyst geodes will not generate.");
        amethystMiddleBlockID = this.getString("amethystMiddleBlockID", catGeneration, "etfuturum:calcite", "Use a namespaced ID, + optionally meta (max 15) to choose the block that makes up the middle layer of amethyst geodes.\nIf the chosen block does not exist then amethyst geodes will not generate.");
        Property fossilBlacklistProp = this.get(catGeneration, "fossilDimensionBlacklist", new int[0]);
        fossilBlacklistProp.comment = "The dimension IDs of the dimensions the fossil structures should not spawn in. Fossils will also not spawn in any dimension that is not an instance of WorldProviderSurface";
        fossilDimensionBlacklist = fossilBlacklistProp.getIntList();
        fossilDimensionBlacklistAsWhitelist = this.getBoolean("fossilDimensionBlacklistAsWhitelist", catGeneration, false, "Treat the fossil dimension blacklist as a whitelist instead, so fossils will ONLY generate in those dimensions, instead of excluding those dimensions from generation.");
        Property deepslateBlacklistProp = this.get(catGeneration, "deepslateLayerDimensionBlacklist", new int[]{-1, 1});
        deepslateBlacklistProp.comment = "The dimensions the deepslate layer (deepslate generation mode 0) should not spawn in. Does nothing if other deepslate generation modes are used.";
        deepslateLayerDimensionBlacklist = deepslateBlacklistProp.getIntList();
        deepslateLayerDimensionBlacklistAsWhitelist = this.getBoolean("deepslateLayerDimensionBlacklistAsWhitelist", catGeneration, false, "Treat the deepslate layer dimension blacklist as a whitelist instead, so it will ONLY generate in those dimensions, instead of excluding those dimensions from generation.");
        Property replaceAllStoneWithDeepslateDimensionWhitelistProp = this.get(catGeneration, "replaceAllStoneWithDeepslateDimensionWhitelist", new int[0]);
        replaceAllStoneWithDeepslateDimensionWhitelistProp.comment = "The dimensions the deepslate layer (deepslate generation mode 0) should replace ALL stone in, rather than adhering to the deepslateMaxY limit. Does nothing if other deepslate generation modes are used. Useful if you have a mod that adds more \"layers\" to the overworld, for example.";
        replaceAllStoneWithDeepslateDimensionWhitelist = replaceAllStoneWithDeepslateDimensionWhitelistProp.getIntList();
        maxTuffPerCluster = this.getInt("tuffClusterSize", catGeneration, 32, 0, 64, "Max vein size for tuff blocks in a cluster");
        enableExtraMesaGold = this.getBoolean("enableExtraMesaGold", catGeneration, true, "Generate 20 more veins of gold ore from Y 32 to Y 80 in any Mesa biome.");
        enableMesaMineshaft = this.getBoolean("enableMesaMineshaft", catGeneration, true, "Generates extra mineshafts in mesa biomes up to y80. If fences are enabled, dark oak wood is used.");
        enableCoarseDirtReplacement = this.getBoolean("enableCoarseDirtReplacement", catGeneration, true, "Replaces coarse dirt in biomes it (dirt:1) generates in such as shattered savannas or mesa plateaus.");
        enableAmethystGeodes = this.getBoolean("enableAmethystGeodes", catGeneration, true, "");
        buddingAmethystMode = this.getInt("buddingAmethystMode", catGeneration, 0, 0, 2, "0 = Budding amethyst cannot be obtained at all even with silk touch. When using this option, attempting to push them using a piston will break it.\n1 = Budding amethyst will drop if you use a silk touch pickaxe.\n2 = Budding amethyst does not need silk touch, just a pickaxe.");
        Property amethystBlacklistProp = this.get(catGeneration, "amethystDimensionBlacklist", new int[]{-1, 1});
        amethystBlacklistProp.comment = "What dimensions should we ban amethyst geodes from generating in?";
        amethystDimensionBlacklist = amethystBlacklistProp.getIntList();
        amethystDimensionBlacklistAsWhitelist = this.getBoolean("amethystDimensionBlacklistAsWhitelist", catGeneration, false, "Treat the amethyst dimension blacklist as a whitelist instead, so geodes will ONLY generate in those dimensions, instead of excluding those dimensions from generation.");
        amethystRarity = this.getInt("amethystRarity", catGeneration, 53, 1, 127, "How rare should amethyst geodes be? 1/x chance per chunk, 1 means a geode attempts to appear every chunk");
        amethystMaxY = this.getInt("amethystMaxY", catGeneration, 46, 6, 245, "Max Y level amethyst geodes should attempt to generate at");
        cherryTreeRarity = this.getInt("cherryTreeRarity", catGeneration, 72, 0, 127, "How rare should cherry trees be? 1/x chance per chunk, 1 means a tree attempts to appear every chunk. 0 = no cherry trees. They will spawn in mountain-type biomes.");
        bambooWorldgen = this.getBoolean("bambooWorldgen", catGeneration, true, "Whether bamboo should naturally spawn in the overworld. Turning this off allows you to use bamboo based blocks without bamboo world gen for mod compatability.");
        crimsonForestID = this.getInt("crimsonForestID", catBiomes, 200, -1, 65536, "Set to -1 to disable the generation of Crimson Forests. To use an ID above 255, EndlessIDs is required.");
        warpedForestID = this.getInt("warpedForestID", catBiomes, 201, -1, 65536, "Set to -1 to disable the generation of Warped Forests. To use an ID above 255, EndlessIDs is required.");
        soulSandValleyID = this.getInt("soulSandValleyID", catBiomes, 202, -1, 65536, "Set to -1 to disable the generation of Soul Sand Valleys. To use an ID above 255, EndlessIDs is required.");
        basaltDeltasID = this.getInt("basaltDeltasID", catBiomes, 203, -1, 65536, "Set to -1 to disable the generation of Basalt Deltas. To use an ID above 255, EndlessIDs is required.");
        netherWastesWeight = this.getInt("netherWastesWeight", catBiomes, 30, 1, 127, "How likely the Nether Wastes biome should generate compared to other Nether biomes.");
        crimsonForestWeight = this.getInt("crimsonForestWeight", catBiomes, 10, 1, 127, "How likely the Crimson Forest biome should generate compared to other Nether biomes.");
        warpedForestWeight = this.getInt("warpedForestWeight", catBiomes, 10, 1, 127, "How likely the Warped Forest biome should generate compared to other Nether biomes.");
        soulSandValleyWeight = this.getInt("soulSandValleyWeight", catBiomes, 10, 1, 127, "How likely the Soul Sand Valley biome should generate compared to other Nether biomes.");
        basaltDeltasWeight = this.getInt("basaltDeltasWeight", catBiomes, 10, 1, 127, "How likely the Basalt Deltas biome should generate compared to other Nether biomes.");
        tileReplacementMode = this.getInt("tileReplacementMode", catMisc, 0, -1, 1, "Replace old Brewing Stands/Enchanting Tables/Daylight Sensors/Beacons with new one on the fly.\n-1 = Disabled, no conversion even if the replacement tile entities are on\n0 = Convert the vanilla tile entities to their Et Futurum versions\n1 = Convert Et Futurum replacement tile entities back to default ones. Useful if you want to turn those off.");
        oldHuskSpawning = this.getBoolean("oldHuskSpawning", catMisc, false, "Enables the old husk spawning logic. Instead of replacing 80% of zombies exposed to the sky in the right biomes, they'll reduce the spawn rate of normal zombies and spawn anywhere in the correct biomes.\nOptiFine breaks the sky-exposure behavior so this option will be forced on when OptiFine is detected.");
        oldStraySpawning = this.getBoolean("oldStraySpawning", catMisc, false, "Enables the old stray spawning logic. Instead of replacing 80% of skeletons exposed to the sky in the right biomes, they'll reduce the spawn rate of normal skeletons and spawn anywhere in the correct biomes.\nOptiFine breaks the sky-exposure behavior so this option will be forced on when OptiFine is detected.");
    }

    @Override
    protected void initValues() {
        int meta;
        if (enableFossils) {
            if (ModsList.NETHERLICIOUS.isLoaded() && fossilBlockID.equals("etfuturum:bone_block") && !ModBlocks.BONE.isEnabled()) {
                fossilBlock = new RegistryMapping<Block>(ExternalContent.Blocks.NETHERLICIOUS_BONE_BLOCK.get(), 0);
            } else {
                String[] fossilBlockArray = fossilBlockID.split(":");
                if ((fossilBlockArray.length == 2 || fossilBlockArray.length == 3) && GameRegistry.findBlock((String)fossilBlockArray[0], (String)fossilBlockArray[1]) != null) {
                    meta = 0;
                    if (fossilBlockArray.length == 3) {
                        try {
                            meta = Integer.parseInt(fossilBlockArray[2]);
                        }
                        catch (NumberFormatException e) {
                            Logger.error("Specified bone block for fossils: " + fossilBlockID + " has invalid metadata specified! (Not an integer)");
                            Logger.error("Defaulting to 0.");
                        }
                        if (meta > 3 || meta < 0) {
                            Logger.error("Specified bone block for fossils: " + fossilBlockID + " has invalid metadata specified! (Value cannot be greater than 3 or lower than 0)");
                            Logger.error("Defaulting to 0.");
                            meta = 0;
                        }
                    }
                    fossilBlock = new RegistryMapping<Block>(GameRegistry.findBlock((String)fossilBlockArray[0], (String)fossilBlockArray[1]), meta);
                } else {
                    Logger.error("Fossil block " + fossilBlockID + " does not exist or is malformed, therefore fossils will not generate!");
                }
            }
        }
        if (enableAmethystGeodes && ModBlocks.AMETHYST_BLOCK.isEnabled() && ModBlocks.AMETHYST_CLUSTER_1.isEnabled() && ModBlocks.AMETHYST_CLUSTER_2.isEnabled()) {
            String[] amethystMiddleBlockArray;
            String[] amethystOuterBlockArray = amethystOuterBlockID.split(":");
            if ((amethystOuterBlockArray.length == 2 || amethystOuterBlockArray.length == 3) && GameRegistry.findBlock((String)amethystOuterBlockArray[0], (String)amethystOuterBlockArray[1]) != null) {
                meta = 0;
                if (amethystOuterBlockArray.length == 3) {
                    try {
                        meta = Integer.parseInt(amethystOuterBlockArray[2]);
                    }
                    catch (NumberFormatException e) {
                        Logger.error("Specified block for amethystOuterLayer: " + amethystOuterBlockID + " has invalid metadata specified! (Not an integer)");
                        Logger.error("Defaulting to 0.");
                    }
                    if (meta > 15 || meta < 0) {
                        Logger.error("Specified block for amethystOuterLayer: " + amethystOuterBlockID + " has invalid metadata specified! (Value cannot be greater than 15 or lower than 0)");
                        Logger.error("Defaulting to 0.");
                        meta = 0;
                    }
                }
                amethystOuterBlock = new RegistryMapping<Block>(GameRegistry.findBlock((String)amethystOuterBlockArray[0], (String)amethystOuterBlockArray[1]), meta);
            }
            if (((amethystMiddleBlockArray = amethystMiddleBlockID.split(":")).length == 2 || amethystMiddleBlockArray.length == 3) && GameRegistry.findBlock((String)amethystMiddleBlockArray[0], (String)amethystMiddleBlockArray[1]) != null) {
                int meta2 = 0;
                if (amethystMiddleBlockArray.length == 3) {
                    try {
                        meta2 = Integer.parseInt(amethystMiddleBlockArray[2]);
                    }
                    catch (NumberFormatException e) {
                        Logger.error("Specified block for amethystMiddleLayer: " + amethystMiddleBlockID + " has invalid metadata specified! (Not an integer)");
                        Logger.error("Defaulting to 0.");
                    }
                    if (meta2 > 15 || meta2 < 0) {
                        Logger.error("Specified block for amethystMiddleLayer: " + amethystMiddleBlockID + " has invalid metadata specified! (Value cannot be greater than 15 or lower than 0)");
                        Logger.error("Defaulting to 0.");
                        meta2 = 0;
                    }
                }
                amethystMiddleBlock = new RegistryMapping<Block>(GameRegistry.findBlock((String)amethystMiddleBlockArray[0], (String)amethystMiddleBlockArray[1]), meta2);
            }
        }
    }

    static {
        debrisMax = 3;
        smallDebrisMax = 2;
    }
}

