/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.enchantment.FrostWalker;
import ganymedes01.etfuturum.enchantment.Mending;
import ganymedes01.etfuturum.enchantment.SwiftSneak;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;

public class ModEnchantments {
    public static Enchantment frostWalker;
    public static Enchantment mending;
    public static Enchantment swiftSneak;
    private static final Map<EntityLivingBase, double[]> prevMoveCache;

    public static void init() {
        if (ConfigEnchantsPotions.enableFrostWalker) {
            frostWalker = new FrostWalker();
        }
        if (ConfigEnchantsPotions.enableMending) {
            mending = new Mending();
        }
        if (ConfigEnchantsPotions.enableSwiftSneak) {
            swiftSneak = new SwiftSneak();
        }
    }

    public static void onLivingUpdate(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!ConfigEnchantsPotions.enableFrostWalker) {
            return;
        }
        ItemStack boots = entity.func_71124_b(1);
        int level = 0;
        level = EnchantmentHelper.func_77506_a((int)ModEnchantments.frostWalker.field_77352_x, (ItemStack)boots);
        if (level > 0 && entity.field_70122_E) {
            double[] prevCoords = prevMoveCache.get(entity);
            if (prevCoords == null || Math.abs(prevCoords[0] - entity.field_70165_t) > 0.003 && Math.abs(prevCoords[1] - entity.field_70161_v) > 0.003) {
                int x = (int)entity.field_70165_t;
                int y = (int)entity.field_70163_u;
                int z = (int)entity.field_70161_v;
                int radius = Math.min(16, 2 + level);
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        if (i * i + j * j > radius * radius) continue;
                        Block block = entity.field_70170_p.func_147439_a(x + i, y - 1, z + j);
                        Block blockUp = entity.field_70170_p.func_147439_a(x + i, y, z + j);
                        if (blockUp.func_149721_r() || blockUp.func_149688_o() == Material.field_151586_h || block != Blocks.field_150355_j && block != Blocks.field_150358_i || !entity.field_70170_p.func_72839_b((Entity)entity, AxisAlignedBB.func_72330_a((double)(x + i), (double)(y - 1), (double)(z + j), (double)(x + i + 1), (double)y, (double)(z + j + 1))).isEmpty()) continue;
                        entity.field_70170_p.func_147449_b(x + i, y - 1, z + j, ModBlocks.FROSTED_ICE.get());
                    }
                }
                prevMoveCache.put(entity, new double[]{entity.field_70165_t, entity.field_70161_v});
            }
        } else {
            prevMoveCache.remove(entity);
        }
    }

    public static void onPlayerPickupXP(PlayerPickupXpEvent event) {
        EntityPlayer player = event.entityPlayer;
        EntityXPOrb orb = event.orb;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!ConfigEnchantsPotions.enableMending) {
            return;
        }
        ItemStack[] stacks = new ItemStack[]{player.func_71045_bC(), player.func_71124_b(1), player.func_71124_b(2), player.func_71124_b(3), player.func_71124_b(4)};
        for (ItemStack stack : stacks) {
            int xp;
            if (stack == null || stack.func_77960_j() <= 0 || EnchantmentHelper.func_77506_a((int)ModEnchantments.mending.field_77352_x, (ItemStack)stack) <= 0) continue;
            for (xp = orb.field_70530_e; xp > 0 && stack.func_77960_j() > 0; --xp) {
                stack.func_77964_b(stack.func_77960_j() - 2);
            }
            if (xp > 0) continue;
            orb.func_70106_y();
            event.setCanceled(true);
            return;
        }
    }

    static {
        prevMoveCache = new WeakHashMap<EntityLivingBase, double[]>();
    }
}

