/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryUtils;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackMap<T> {
    public static final NBTTagCompound WILDCARD_TAG = new NBTTagCompound();
    private final Map<Item, DetailMap> itemMap = new LinkedHashMap<Item, DetailMap>();
    private int size;

    public static int getKeyType(int damage, NBTTagCompound tag) {
        int i = 0;
        if (ItemStackMap.isWildcard(damage)) {
            i = 1;
        }
        if (ItemStackMap.isWildcard(tag)) {
            i |= 2;
        }
        return i;
    }

    public static ItemStack wildcard(Item item) {
        return InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)WILDCARD_TAG);
    }

    public static boolean isWildcard(int damage) {
        return damage == Short.MAX_VALUE;
    }

    public static boolean isWildcard(NBTTagCompound tag) {
        return tag != null && tag.func_74767_n("*");
    }

    public T get(ItemStack key) {
        if (key == null) {
            return null;
        }
        Item item = key.func_77973_b();
        if (item == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(item);
        return map == null ? null : (T)map.get(key);
    }

    public T getOrDefault(ItemStack key, T defaultValue) {
        T e = this.get(key);
        return e == null ? defaultValue : e;
    }

    public void put(ItemStack key, T value) {
        if (key == null || key.func_77973_b() == null) {
            return;
        }
        DetailMap map = this.itemMap.get(key.func_77973_b());
        if (map == null) {
            map = new DetailMap();
            this.itemMap.put(key.func_77973_b(), map);
        }
        map.put(key, value);
    }

    public T computeIfAbsent(ItemStack key, Function<ItemStack, ? extends T> mappingFunction) {
        T newValue;
        T value = this.get(key);
        if (value == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
            return newValue;
        }
        return value;
    }

    public void clear() {
        this.itemMap.clear();
        this.size = 0;
    }

    public T remove(ItemStack key) {
        if (key == null || key.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(key.func_77973_b());
        return map == null ? null : (T)map.remove(key);
    }

    public List<ItemStack> keys() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (Map.Entry<Item, DetailMap> entry : this.itemMap.entrySet()) {
            entry.getValue().addKeys(entry.getKey(), list);
        }
        return list;
    }

    public List<T> values() {
        LinkedList list = new LinkedList();
        for (DetailMap map : this.itemMap.values()) {
            map.addValues(list);
        }
        return list;
    }

    public List<Entry<T>> entries() {
        LinkedList<Entry<T>> list = new LinkedList<Entry<T>>();
        for (Map.Entry<Item, DetailMap> entry : this.itemMap.entrySet()) {
            entry.getValue().addEntries(entry.getKey(), list);
        }
        return list;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    static {
        WILDCARD_TAG.func_74757_a("*", true);
    }

    public class DetailMap {
        private boolean hasWildcard;
        private T wildcard;
        private HashMap<Integer, T> damageMap;
        private HashMap<NBTTagCompound, T> tagMap;
        private HashMap<StackMetaKey, T> metaMap;
        private int size;

        public T get(ItemStack key) {
            Object ret;
            if (this.wildcard != null) {
                return this.wildcard;
            }
            if (this.damageMap != null && (ret = this.damageMap.get(InventoryUtils.actualDamage((ItemStack)key))) != null) {
                return ret;
            }
            if (this.tagMap != null && (ret = this.tagMap.get(key.field_77990_d)) != null) {
                return ret;
            }
            if (this.metaMap != null) {
                return this.metaMap.get(new StackMetaKey(key));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T put(ItemStack key, T value) {
            try {
                switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                    case 0: {
                        if (this.metaMap == null) {
                            this.metaMap = new HashMap();
                        }
                        Object t = this.metaMap.put(new StackMetaKey(key), value);
                        return t;
                    }
                    case 1: {
                        if (this.tagMap == null) {
                            this.tagMap = new HashMap();
                        }
                        Object t = this.tagMap.put(key.field_77990_d, value);
                        return t;
                    }
                    case 2: {
                        if (this.damageMap == null) {
                            this.damageMap = new HashMap();
                        }
                        Object t = this.damageMap.put(InventoryUtils.actualDamage((ItemStack)key), value);
                        return t;
                    }
                    case 3: {
                        Object ret = this.wildcard;
                        this.wildcard = value;
                        this.hasWildcard = true;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T remove(ItemStack key) {
            try {
                switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                    case 0: {
                        Object t = this.metaMap != null ? (Object)this.metaMap.remove(new StackMetaKey(key)) : null;
                        return t;
                    }
                    case 1: {
                        Object t = this.tagMap != null ? (Object)this.tagMap.remove(key.field_77990_d) : null;
                        return t;
                    }
                    case 2: {
                        Object t = this.damageMap != null ? (Object)this.damageMap.remove(InventoryUtils.actualDamage((ItemStack)key)) : null;
                        return t;
                    }
                    case 3: {
                        Object ret = this.wildcard;
                        this.wildcard = null;
                        this.hasWildcard = false;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        private void updateSize() {
            int newSize = (this.hasWildcard ? 1 : 0) + (this.metaMap != null ? this.metaMap.size() : 0) + (this.tagMap != null ? this.tagMap.size() : 0) + (this.damageMap != null ? this.damageMap.size() : 0);
            if (newSize != this.size) {
                ItemStackMap.this.size += newSize - this.size;
                this.size = newSize;
            }
        }

        public void addKeys(Item item, List<ItemStack> list) {
            if (this.wildcard != null) {
                list.add(ItemStackMap.wildcard(item));
            }
            if (this.damageMap != null) {
                Iterator<Object> iterator = this.damageMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int damage = iterator.next();
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)damage, (NBTTagCompound)WILDCARD_TAG));
                }
            }
            if (this.tagMap != null) {
                for (NBTTagCompound tag : this.tagMap.keySet()) {
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)tag));
                }
            }
            if (this.metaMap != null) {
                for (StackMetaKey key : this.metaMap.keySet()) {
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)key.damage, (NBTTagCompound)key.tag));
                }
            }
        }

        public void addValues(List<T> list) {
            if (this.wildcard != null) {
                list.add(this.wildcard);
            }
            if (this.damageMap != null) {
                list.addAll(this.damageMap.values());
            }
            if (this.tagMap != null) {
                list.addAll(this.tagMap.values());
            }
            if (this.metaMap != null) {
                list.addAll(this.metaMap.values());
            }
        }

        public void addEntries(Item item, List<Entry<T>> list) {
            if (this.wildcard != null) {
                list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)WILDCARD_TAG), this.wildcard));
            }
            if (this.damageMap != null) {
                for (Map.Entry entry : this.damageMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)entry.getKey(), (NBTTagCompound)WILDCARD_TAG), entry.getValue()));
                }
            }
            if (this.tagMap != null) {
                for (Map.Entry entry : this.tagMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)((NBTTagCompound)entry.getKey())), entry.getValue()));
                }
            }
            if (this.metaMap != null) {
                for (Map.Entry entry : this.metaMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)((StackMetaKey)entry.getKey()).damage, (NBTTagCompound)((StackMetaKey)entry.getKey()).tag), entry.getValue()));
                }
            }
        }
    }

    public static class Entry<T> {
        public final ItemStack key;
        public final T value;

        public Entry(ItemStack key, T value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class StackMetaKey {
        public final int damage;
        public final NBTTagCompound tag;
        private final int hashCode;

        public StackMetaKey(int damage, NBTTagCompound tag) {
            if (tag != null && tag.func_82582_d()) {
                tag = null;
            }
            this.hashCode = Objects.hashCode((Object[])new Object[]{damage, tag});
            this.damage = damage;
            this.tag = tag;
        }

        public StackMetaKey(ItemStack key) {
            this(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StackMetaKey)) {
                return false;
            }
            StackMetaKey t = (StackMetaKey)o;
            return this.damage == t.damage && Objects.equal((Object)this.tag, (Object)t.tag);
        }
    }
}

