/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod.vanilla;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.client.model.mod.vanilla.VanillaColorHandler;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;

public final class VanillaBlockHandler
implements ModBlockDelegate.IModBlockHandler {
    ListMultimap<Material, BlockMD.Flag> materialFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Class<? extends Block>, BlockMD.Flag> blockClassFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Block, BlockMD.Flag> blockFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    HashMap<Material, Float> materialAlphas = new HashMap();
    HashMap<Block, Float> blockAlphas = new HashMap();
    HashMap<Class<? extends Block>, Float> blockClassAlphas = new HashMap();
    HashMap<Block, Integer> blockTextureSides = new HashMap();
    HashMap<Class<? extends Block>, Integer> blockClassTextureSides = new HashMap();

    public VanillaBlockHandler() {
        this.preInitialize();
    }

    private void preInitialize() {
        this.setFlags(Material.field_151579_a, BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow);
        this.setFlags(Material.field_151592_s, Float.valueOf(0.4f), BlockMD.Flag.TransparentRoof);
        if (JourneymapClient.getCoreProperties().caveIgnoreGlass.get()) {
            this.setFlags(Material.field_151592_s, BlockMD.Flag.OpenToSky);
        }
        this.setFlags(Material.field_151586_h, Float.valueOf(0.3f), BlockMD.Flag.NoShadow, BlockMD.Flag.Water);
        this.setFlags(Material.field_151587_i, BlockMD.Flag.NoShadow);
        this.materialAlphas.put(Material.field_151588_w, Float.valueOf(0.8f));
        this.materialAlphas.put(Material.field_151598_x, Float.valueOf(0.8f));
        this.setFlags(Blocks.field_150411_aY, Float.valueOf(0.4f), new BlockMD.Flag[0]);
        this.setFlags((Block)Blocks.field_150480_ab, BlockMD.Flag.NoShadow);
        this.setTextureSide((Block)Blocks.field_150480_ab, 2);
        this.setFlags(Blocks.field_150411_aY, BlockMD.Flag.TransparentRoof);
        this.setFlags(Blocks.field_150468_ap, BlockMD.Flag.OpenToSky);
        this.setFlags(Blocks.field_150431_aC, BlockMD.Flag.NoTopo);
        this.setFlags(Blocks.field_150473_bD, BlockMD.Flag.NoShadow);
        this.setFlags((Block)Blocks.field_150479_bC, BlockMD.Flag.NoShadow);
        this.setFlags(Blocks.field_150321_G, BlockMD.Flag.OpenToSky);
        this.setTextureSide(Blocks.field_150321_G, 2);
        this.setFlags(BlockLog.class, BlockMD.Flag.OpenToSky, BlockMD.Flag.CustomBiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags(BlockFence.class, Float.valueOf(0.4f), BlockMD.Flag.TransparentRoof);
        this.setFlags(BlockFenceGate.class, Float.valueOf(0.4f), BlockMD.Flag.TransparentRoof);
        this.setFlags(BlockGrass.class, BlockMD.Flag.Grass);
        this.setFlags(BlockTallGrass.class, BlockMD.Flag.HasAir, BlockMD.Flag.NoTopo);
        this.setFlags(BlockDoublePlant.class, BlockMD.Flag.Plant, BlockMD.Flag.NoTopo);
        this.setTextureSide(BlockDoublePlant.class, 2);
        this.setFlags(BlockLeavesBase.class, BlockMD.Flag.OpenToSky, BlockMD.Flag.Foliage, BlockMD.Flag.NoTopo);
        this.setFlags(BlockVine.class, Float.valueOf(0.2f), BlockMD.Flag.OpenToSky, BlockMD.Flag.CustomBiomeColor, BlockMD.Flag.Foliage, BlockMD.Flag.NoTopo, BlockMD.Flag.NoShadow);
        this.setFlags(BlockLilyPad.class, BlockMD.Flag.CustomBiomeColor, BlockMD.Flag.NoTopo);
        this.setFlags(BlockCrops.class, BlockMD.Flag.Crop, BlockMD.Flag.NoTopo);
        this.setTextureSide(BlockCrops.class, 2);
        this.setFlags(BlockFlower.class, BlockMD.Flag.Plant, BlockMD.Flag.NoTopo);
        this.setFlags(BlockBush.class, BlockMD.Flag.Plant, BlockMD.Flag.NoTopo);
        this.setTextureSide(BlockBush.class, 2);
        this.setFlags(BlockCactus.class, BlockMD.Flag.Plant, BlockMD.Flag.NoTopo);
        this.setTextureSide(BlockCactus.class, 2);
        this.setFlags(BlockRailBase.class, BlockMD.Flag.NoShadow, BlockMD.Flag.NoTopo);
        this.setFlags(BlockTorch.class, BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow, BlockMD.Flag.NoTopo);
    }

    @Override
    public boolean initialize(BlockMD blockMD) {
        Block block;
        blockMD.setBlockColorHandler(VanillaColorHandler.INSTANCE);
        if (blockMD.isWater()) {
            Journeymap.getLogger().info("Water! " + blockMD);
        }
        Material material = blockMD.getBlock().func_149688_o();
        blockMD.addFlags(this.materialFlags.get((Object)material));
        Float alpha = this.materialAlphas.get(material);
        if (alpha != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (this.blockFlags.containsKey((Object)(block = blockMD.getBlock()))) {
            blockMD.addFlags(this.blockFlags.get((Object)block));
        }
        if ((alpha = this.blockAlphas.get(block)) != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (blockMD.getFlags().isEmpty()) {
            for (Class parentClass : this.blockClassFlags.keys()) {
                Integer textureSide;
                if (!parentClass.isAssignableFrom(block.getClass())) continue;
                blockMD.addFlags(this.blockClassFlags.get((Object)parentClass));
                alpha = this.blockClassAlphas.get(parentClass);
                if (alpha != null) {
                    blockMD.setAlpha(alpha.floatValue());
                }
                if ((textureSide = this.blockClassTextureSides.get(parentClass)) == null) break;
                blockMD.setTextureSide(textureSide);
                break;
            }
        }
        if (block instanceof BlockHugeMushroom) {
            int overrideMeta = 14;
            if (blockMD.getMeta() != overrideMeta) {
                blockMD.setOverrideMeta(overrideMeta);
            }
        }
        if (block == Blocks.field_150398_cm && blockMD.getMeta() == 2) {
            blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.NoTopo);
        }
        if (block == Blocks.field_150329_H && blockMD.getMeta() == 2) {
            blockMD.addFlags(BlockMD.Flag.Plant, BlockMD.Flag.CustomBiomeColor);
        }
        if (blockMD.hasAnyFlag(BlockMD.FlagsPlantAndCrop) && !JourneymapClient.getCoreProperties().mapPlantShadows.get()) {
            blockMD.addFlags(BlockMD.Flag.NoShadow);
        }
        return false;
    }

    @Override
    public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
        return blockMD;
    }

    private void setFlags(Material material, BlockMD.Flag ... flags) {
        this.materialFlags.putAll((Object)material, new ArrayList<BlockMD.Flag>(Arrays.asList(flags)));
    }

    private void setFlags(Material material, Float alpha, BlockMD.Flag ... flags) {
        this.materialAlphas.put(material, alpha);
        this.setFlags(material, flags);
    }

    private void setFlags(Class<? extends Block> parentClass, BlockMD.Flag ... flags) {
        this.blockClassFlags.putAll(parentClass, new ArrayList<BlockMD.Flag>(Arrays.asList(flags)));
    }

    private void setFlags(Class<? extends Block> parentClass, Float alpha, BlockMD.Flag ... flags) {
        this.blockClassAlphas.put(parentClass, alpha);
        this.setFlags(parentClass, flags);
    }

    private void setFlags(Block block, BlockMD.Flag ... flags) {
        this.blockFlags.putAll((Object)block, new ArrayList<BlockMD.Flag>(Arrays.asList(flags)));
    }

    private void setFlags(Block block, Float alpha, BlockMD.Flag ... flags) {
        this.blockAlphas.put(block, alpha);
        this.setFlags(block, flags);
    }

    private void setTextureSide(Class<? extends Block> parentClass, int side) {
        this.blockClassTextureSides.put(parentClass, side);
    }

    private void setTextureSide(Block block, int side) {
        this.blockTextureSides.put(block, side);
    }
}

