/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.nbt;

import net.minecraft.block.Block;

public interface INBTBlockTransformable {
    public int transformMeta(int var1, int var2);

    default public Block transformBlock(Block block) {
        return block;
    }

    public static int transformMetaDeco(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        switch (coordBaseMode) {
            case 1: {
                switch (meta) {
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 3;
                    }
                }
            }
            case 2: {
                switch (meta) {
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 4;
                    }
                }
            }
            case 3: {
                switch (meta) {
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                }
            }
        }
        return meta;
    }

    public static int transformMetaDecoModel(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        int rot = (meta + coordBaseMode) % 4;
        int type = meta / 4 * 4;
        return rot | type;
    }

    public static int transformMetaStairs(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        switch (coordBaseMode) {
            case 1: {
                if ((meta & 3) < 2) {
                    meta ^= 2;
                    break;
                }
                meta ^= 3;
                break;
            }
            case 2: {
                meta ^= 1;
                break;
            }
            case 3: {
                if ((meta & 3) < 2) {
                    meta ^= 3;
                    break;
                }
                meta ^= 2;
            }
        }
        return meta;
    }

    public static int transformMetaTrapdoor(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        switch (coordBaseMode) {
            case 1: {
                if ((meta & 3) < 2) {
                    meta ^= 3;
                    break;
                }
                meta ^= 2;
                break;
            }
            case 2: {
                meta ^= 1;
                break;
            }
            case 3: {
                if ((meta & 3) < 2) {
                    meta ^= 2;
                    break;
                }
                meta ^= 3;
            }
        }
        return meta;
    }

    public static int transformMetaPillar(int meta, int coordBaseMode) {
        if (coordBaseMode == 0 || coordBaseMode == 2) {
            return meta;
        }
        int type = meta & 3;
        int rot = meta & 0xC;
        if (rot == 4) {
            return type | 8;
        }
        if (rot == 8) {
            return type | 4;
        }
        return meta;
    }

    public static int transformMetaDirectional(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        int rot = meta & 3;
        int other = meta & 0xC;
        switch (coordBaseMode) {
            default: {
                break;
            }
            case 1: {
                rot = (rot + 1) % 4;
                break;
            }
            case 2: {
                rot ^= 2;
                break;
            }
            case 3: {
                rot = (rot + 3) % 4;
            }
        }
        return other | rot;
    }

    public static int transformMetaTorch(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        switch (coordBaseMode) {
            case 1: {
                switch (meta) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 1;
                    }
                }
            }
            case 2: {
                switch (meta) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                }
            }
            case 3: {
                switch (meta) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                }
            }
        }
        return meta;
    }

    public static int transformMetaDoor(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        if (meta == 8 || meta == 9) {
            return meta;
        }
        return INBTBlockTransformable.transformMetaDirectional(meta, coordBaseMode);
    }

    public static int transformMetaLever(int meta, int coordBaseMode) {
        if (coordBaseMode == 0) {
            return meta;
        }
        if (meta <= 0 || meta >= 7) {
            switch (coordBaseMode) {
                case 1: 
                case 3: {
                    meta ^= 7;
                }
            }
        } else if (meta >= 5) {
            switch (coordBaseMode) {
                case 1: 
                case 3: {
                    meta = (meta + 1) % 2 + 5;
                }
            }
        } else {
            meta = INBTBlockTransformable.transformMetaTorch(meta, coordBaseMode);
        }
        return meta;
    }

    public static int transformMetaVine(int meta, int coordBaseMode) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int bit = 1 << i;
            if ((meta & bit) == 0) continue;
            result |= INBTBlockTransformable.rotateVineBit(bit, coordBaseMode);
        }
        return result;
    }

    public static int rotateVineBit(int bit, int coordBaseMode) {
        int index = -1;
        switch (bit) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 4: {
                index = 2;
                break;
            }
            case 8: {
                index = 3;
                break;
            }
            default: {
                return 0;
            }
        }
        int rotated = index;
        switch (coordBaseMode) {
            case 1: {
                rotated = (index + 1) % 4;
                break;
            }
            case 2: {
                rotated = (index + 2) % 4;
                break;
            }
            case 3: {
                rotated = (index + 3) % 4;
            }
        }
        switch (rotated) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        return 0;
    }
}

