/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import java.util.function.Function;

public final class Either<L, R> {
    private final Object value;
    private final boolean isLeft;

    public static <L, R> Either<L, R> left(L value) {
        return new Either<L, R>(value, true);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either<L, R>(value, false);
    }

    private Either(Object value, boolean isLeft) {
        this.value = value;
        this.isLeft = isLeft;
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public boolean isRight() {
        return !this.isLeft;
    }

    public L left() {
        if (this.isLeft) {
            return (L)this.value;
        }
        throw new IllegalStateException("Tried accessing value as the L type, but was R type");
    }

    public R right() {
        if (!this.isLeft) {
            return (R)this.value;
        }
        throw new IllegalStateException("Tried accessing value as the R type, but was L type");
    }

    public L leftOrNull() {
        return (L)(this.isLeft ? this.value : null);
    }

    public R rightOrNull() {
        return (R)(!this.isLeft ? this.value : null);
    }

    public <V> V cast() {
        return (V)this.value;
    }

    public <T> T run(Function<L, T> leftFunc, Function<R, T> rightFunc) {
        return this.isLeft ? leftFunc.apply(this.value) : rightFunc.apply(this.value);
    }

    public <T> T runLeftOrNull(Function<L, T> func) {
        return this.isLeft ? (T)func.apply(this.value) : null;
    }

    public <T> T runRightOrNull(Function<R, T> func) {
        return !this.isLeft ? (T)func.apply(this.value) : null;
    }

    public <V, T> T runCasting(Function<V, T> func) {
        return func.apply(this.value);
    }
}

