/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.gui.GuiScreenRadioTelex;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.network.RTTYSystem;
import com.hbm.util.BufferUtil;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRadioTelex
extends TileEntityLoadedBase
implements IControlReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent {
    public static final int lineWidth = 33;
    public String txChannel = "";
    public String rxChannel = "";
    public String[] txBuffer = new String[]{"", "", "", "", ""};
    public String[] rxBuffer = new String[]{"", "", "", "", ""};
    public int sendingLine = 0;
    public int sendingIndex = 0;
    public boolean isSending = false;
    public int sendingWait = 0;
    public int writingLine = 0;
    public boolean printAfterRx = false;
    public boolean deleteOnReceive = true;
    public char sendingChar = (char)32;
    public static final char eol = '\n';
    public static final char eot = '\u0004';
    public static final char bell = '\u0007';
    public static final char print = '\f';
    public static final char pause = '\u0016';
    public static final char clear = '\u007f';
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            RTTYSystem.RTTYChannel chan;
            char c;
            this.sendingChar = (char)32;
            if (this.isSending && this.txChannel.isEmpty()) {
                this.isSending = false;
            }
            if (this.isSending) {
                if (this.sendingWait > 0) {
                    --this.sendingWait;
                } else {
                    String line = this.txBuffer[this.sendingLine];
                    if (line.length() > this.sendingIndex) {
                        c = line.charAt(this.sendingIndex);
                        ++this.sendingIndex;
                        if (c == '\u0016') {
                            this.sendingWait = 20;
                        } else {
                            RTTYSystem.broadcast(this.field_145850_b, this.txChannel, Character.valueOf(c));
                            this.sendingChar = c;
                        }
                    } else if (this.sendingLine >= 4) {
                        this.isSending = false;
                        RTTYSystem.broadcast(this.field_145850_b, this.txChannel, Character.valueOf('\u0004'));
                        this.sendingLine = 0;
                        this.sendingIndex = 0;
                    } else {
                        RTTYSystem.broadcast(this.field_145850_b, this.txChannel, Character.valueOf('\n'));
                        ++this.sendingLine;
                        this.sendingIndex = 0;
                    }
                }
            }
            if (!this.rxChannel.isEmpty() && (chan = RTTYSystem.listen(this.field_145850_b, this.rxChannel)) != null && chan.signal instanceof Character && chan.timeStamp > this.field_145850_b.func_82737_E() - 2L && chan.timeStamp != -1L) {
                int i;
                c = ((Character)chan.signal).charValue();
                if (this.deleteOnReceive) {
                    this.deleteOnReceive = false;
                    for (i = 0; i < 5; ++i) {
                        this.rxBuffer[i] = "";
                    }
                    this.writingLine = 0;
                }
                if (c == '\u0004') {
                    if (this.printAfterRx) {
                        this.printAfterRx = false;
                        this.print();
                    }
                    this.deleteOnReceive = true;
                } else if (c == '\n') {
                    if (this.writingLine < 4) {
                        ++this.writingLine;
                    }
                    this.func_70296_d();
                } else if (c == '\u0007') {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.orb", 2.0f, 0.5f);
                } else if (c == '\f') {
                    this.printAfterRx = true;
                } else if (c == '\u007f') {
                    for (i = 0; i < 5; ++i) {
                        this.rxBuffer[i] = "";
                    }
                    this.writingLine = 0;
                } else {
                    int n = this.writingLine;
                    this.rxBuffer[n] = this.rxBuffer[n] + c;
                    this.func_70296_d();
                }
            }
            this.networkPackNT(16);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        for (int i = 0; i < 5; ++i) {
            BufferUtil.writeString(buf, this.txBuffer[i]);
            BufferUtil.writeString(buf, this.rxBuffer[i]);
        }
        BufferUtil.writeString(buf, this.txChannel);
        BufferUtil.writeString(buf, this.rxChannel);
        buf.writeChar((int)this.sendingChar);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        for (int i = 0; i < 5; ++i) {
            this.txBuffer[i] = BufferUtil.readString(buf);
            this.rxBuffer[i] = BufferUtil.readString(buf);
        }
        this.txChannel = BufferUtil.readString(buf);
        this.rxChannel = BufferUtil.readString(buf);
        this.sendingChar = buf.readChar();
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        for (int i = 0; i < 5; ++i) {
            if (!data.func_74764_b("tx" + i)) continue;
            this.txBuffer[i] = data.func_74779_i("tx" + i);
        }
        String cmd = data.func_74779_i("cmd");
        if ("snd".equals(cmd) && !this.isSending) {
            this.isSending = true;
            this.sendingLine = 0;
            this.sendingIndex = 0;
        }
        if ("rxprt".equals(cmd)) {
            this.print();
        }
        if ("rxcls".equals(cmd)) {
            for (int i = 0; i < 5; ++i) {
                this.rxBuffer[i] = "";
            }
            this.writingLine = 0;
        }
        if ("sve".equals(cmd)) {
            this.txChannel = data.func_74779_i("txChan");
            this.rxChannel = data.func_74779_i("rxChan");
            this.func_70296_d();
        }
    }

    public void print() {
        ItemStack stack = new ItemStack(Items.field_151121_aF);
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            if (this.rxBuffer[i].isEmpty()) continue;
            text.add(this.rxBuffer[i]);
        }
        ItemStackUtil.addTooltipToStack(stack, text.toArray(new String[0]));
        stack.func_151001_c("Message");
        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, stack));
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 256.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 5; ++i) {
            this.txBuffer[i] = nbt.func_74779_i("tx" + i);
            this.rxBuffer[i] = nbt.func_74779_i("rx" + i);
        }
        this.txChannel = nbt.func_74779_i("txChan");
        this.rxChannel = nbt.func_74779_i("rxChan");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 5; ++i) {
            nbt.func_74778_a("tx" + i, this.txBuffer[i]);
            nbt.func_74778_a("rx" + i, this.rxBuffer[i]);
        }
        nbt.func_74778_a("txChan", this.txChannel);
        nbt.func_74778_a("rxChan", this.rxChannel);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiScreenRadioTelex(this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_telex";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getChannels(Context context, Arguments args) {
        return new Object[]{this.txChannel, this.rxChannel};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setChannels(Context context, Arguments args) {
        String[] old = new String[]{this.txChannel, this.rxChannel};
        this.rxChannel = args.checkString(0);
        this.txChannel = args.checkString(1);
        return new Object[]{old[0], old[1]};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSendingTexts(Context context, Arguments args) {
        return new Object[]{this.txBuffer[0], this.txBuffer[1], this.txBuffer[2], this.txBuffer[3], this.txBuffer[4]};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getReceivingText(Context context, Arguments args) {
        return new Object[]{this.rxBuffer[0], this.rxBuffer[1], this.rxBuffer[2], this.rxBuffer[3], this.rxBuffer[4]};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setSendingText(Context context, Arguments args) {
        for (int i = 0; i < 5; ++i) {
            this.txBuffer[i] = args.checkAny(i) == null || args.checkString(i).isEmpty() ? "" : (args.checkString(i).length() > 33 ? args.checkString(i).substring(0, 33) : args.checkString(i));
        }
        return new Object[]{true};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] printMessage(Context context, Arguments args) {
        this.print();
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] clearAll(Context context, Arguments args) {
        for (int i = 0; i < 5; ++i) {
            this.rxBuffer[i] = "";
        }
        this.writingLine = 0;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] sendMessage(Context context, Arguments args) {
        if (!this.isSending) {
            this.isSending = true;
            this.sendingLine = 0;
            this.sendingIndex = 0;
            return new Object[]{true};
        }
        return new Object[]{false};
    }
}

