/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.FluidNetMK2;
import api.hbm.fluidmk2.FluidNode;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineFluidTank;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FT_Polluting;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUIMachineFluidTank;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IOverpressurable;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityMachineFluidTank
extends TileEntityMachineBase
implements SimpleComponent,
CompatHandler.OCComponent,
IFluidStandardTransceiverMK2,
IPersistentNBT,
IOverpressurable,
IGUIProvider,
IRepairable,
IFluidCopiable,
IRORValueProvider,
IRORInteractive {
    protected FluidNode node;
    protected FluidType lastType;
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    public boolean hasExploded = false;
    public boolean onFire = false;
    public byte lastRedstone = 0;
    public Explosion lastExplosion = null;
    public int age = 0;
    AxisAlignedBB bb = null;
    List<RecipesCommon.AStack> repair = new ArrayList<RecipesCommon.AStack>();

    public TileEntityMachineFluidTank() {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, 256000);
    }

    @Override
    public String getName() {
        return "container.fluidtank";
    }

    public byte getComparatorPower() {
        if (this.tank.getFill() == 0) {
            return 0;
        }
        double frac = (double)this.tank.getFill() / (double)this.tank.getMaxFill() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.func_145832_p() < 12) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.DOWN);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_fluidtank, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_fluidtank).getDimensions(), ModBlocks.machine_fluidtank, dir);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            if (!this.hasExploded) {
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                    this.markChanged();
                }
                if (this.mode == 1) {
                    if (this.node == null || this.node.expired || this.tank.getTankType() != this.lastType) {
                        this.node = (FluidNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
                        if (this.node == null || this.node.expired || this.tank.getTankType() != this.lastType) {
                            this.node = this.createNode(this.tank.getTankType());
                            UniNodespace.createNode(this.field_145850_b, this.node);
                            this.lastType = this.tank.getTankType();
                        }
                    }
                    if (this.node != null && this.node.hasValidNet()) {
                        ((FluidNetMK2)this.node.net).addProvider(this);
                        ((FluidNetMK2)this.node.net).addReceiver(this);
                    }
                } else {
                    if (this.node != null) {
                        UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
                        this.node = null;
                    }
                    for (DirPos pos : this.getConPos()) {
                        FluidNode dirNode = (FluidNode)UniNodespace.getNode(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), this.tank.getTankType().getNetworkProvider());
                        if (this.mode == 2) {
                            this.tryProvide(this.tank, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                        } else if (dirNode != null && dirNode.hasValidNet()) {
                            ((FluidNetMK2)dirNode.net).removeProvider(this);
                        }
                        if (this.mode == 0) {
                            if (dirNode == null || !dirNode.hasValidNet()) continue;
                            ((FluidNetMK2)dirNode.net).addReceiver(this);
                            continue;
                        }
                        if (dirNode == null || !dirNode.hasValidNet()) continue;
                        ((FluidNetMK2)dirNode.net).removeReceiver(this);
                    }
                }
                this.tank.loadTank(2, 3, this.slots);
                this.tank.setType(0, 1, this.slots);
            } else if (this.node != null) {
                UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
                this.node = null;
            }
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
                for (DirPos pos : this.getConPos()) {
                    this.updateRedstoneConnection(pos);
                }
            }
            this.lastRedstone = comp;
            if (this.tank.getFill() > 0) {
                if (this.tank.getTankType().isAntimatter()) {
                    new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f).makeAmat().setBlockAllocator(null).setBlockProcessor(null).explode();
                    this.explode();
                    this.tank.setFill(0);
                }
                if (this.tank.getTankType().hasTrait(FT_Corrosive.class) && this.tank.getTankType().getTrait(FT_Corrosive.class).isHighlyCorrosive()) {
                    this.explode();
                }
                if (this.hasExploded) {
                    int leaking = 0;
                    leaking = this.tank.getTankType().isAntimatter() ? this.tank.getFill() : (this.tank.getTankType().hasTrait(FT_Gaseous.class) || this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous_ART.class) ? Math.min(this.tank.getFill(), this.tank.getMaxFill() / 100) : Math.min(this.tank.getFill(), this.tank.getMaxFill() / 10000));
                    this.updateLeak(leaking);
                }
            }
            this.tank.unloadTank(4, 5, this.slots);
            this.networkPackNT(150);
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 2.875), (double)(this.field_145849_e + 1)).func_72317_d((double)dir.offsetX * 0.5 - (double)rot.offsetX * 2.25, 0.0, (double)dir.offsetZ * 0.5 - (double)rot.offsetZ * 2.25));
        for (EntityPlayer player : players) {
            HbmPlayerProps props = HbmPlayerProps.getData(player);
            props.isOnLadder = true;
        }
    }

    protected FluidNode createNode(FluidType type) {
        DirPos[] conPos = this.getConPos();
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        posSet.add(new BlockPos(this));
        for (DirPos pos : conPos) {
            ForgeDirection dir = pos.getDir();
            posSet.add(new BlockPos(pos.getX() - dir.offsetX, pos.getY() - dir.offsetY, pos.getZ() - dir.offsetZ));
        }
        return new FluidNode(type.getNetworkProvider(), posSet.toArray(new BlockPos[posSet.size()])).setConnections(conPos);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType().getNetworkProvider());
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.mode);
        buf.writeBoolean(this.hasExploded);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.mode = buf.readShort();
        this.hasExploded = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    public void explode() {
        this.hasExploded = true;
        this.onFire = this.tank.getTankType().hasTrait(FT_Flammable.class);
        this.markChanged();
    }

    public void updateLeak(int amount) {
        if (!this.hasExploded) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        this.tank.getTankType().onFluidRelease(this, this.tank, amount);
        this.tank.setFill(Math.max(0, this.tank.getFill() - amount));
        FluidType type = this.tank.getTankType();
        if (type.hasTrait(FluidTraitSimple.FT_Amat.class)) {
            new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f).makeAmat().setBlockAllocator(null).setBlockProcessor(null).explode();
        } else if (type.hasTrait(FT_Flammable.class) && this.onFire) {
            List affected = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 2.5), (double)(this.field_145848_d + 5), (double)((double)this.field_145849_e + 2.5)));
            for (Entity e : affected) {
                e.func_70015_d(5);
            }
            Random rand = this.field_145850_b.field_73012_v;
            ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + rand.nextDouble(), (double)this.field_145848_d + 0.5 + rand.nextDouble(), (double)this.field_145849_e + rand.nextDouble(), rand.nextGaussian() * 0.2, 0.1, rand.nextGaussian() * 0.2);
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                FT_Polluting.pollute(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType(), FluidTrait.FluidReleaseType.BURN, amount * 5);
            }
        } else if (type.hasTrait(FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 1.0f);
                data.func_74776_a("base", 1.0f);
                data.func_74776_a("max", 5.0f);
                data.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(20));
                data.func_74768_a("color", this.tank.getTankType().getColor());
                PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            }
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                FT_Polluting.pollute(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getTankType(), FluidTrait.FluidReleaseType.SPILL, amount * 5);
            }
        }
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (this.hasExploded) {
            return;
        }
        this.onFire = this.tank.getTankType().hasTrait(FT_Flammable.class);
        this.hasExploded = true;
        this.markChanged();
    }

    @Override
    public void tryExtinguish(World world, int x, int y, int z, IRepairable.EnumExtinguishType type) {
        if (!this.hasExploded || !this.onFire) {
            return;
        }
        if (type == IRepairable.EnumExtinguishType.WATER) {
            if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Liquid.class)) {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
            } else {
                this.onFire = false;
                this.markChanged();
                return;
            }
        }
        if (type == IRepairable.EnumExtinguishType.FOAM || type == IRepairable.EnumExtinguishType.CO2) {
            this.onFire = false;
            this.markChanged();
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.mode = (short)((this.mode + 1) % 4);
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.tank.readFromNBT(nbt, "tank");
        this.hasExploded = nbt.func_74767_n("exploded");
        this.onFire = nbt.func_74767_n("onFire");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74757_a("exploded", this.hasExploded);
        nbt.func_74757_a("onFire", this.onFire);
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        long toTransfer = Math.min(this.getDemand(type, pressure), fluid);
        this.tank.setFill(this.tank.getFill() + (int)toTransfer);
        return fluid - toTransfer;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        if (this.mode == 2 || this.mode == 3) {
            return 0L;
        }
        if (this.tank.getPressure() != pressure) {
            return 0L;
        }
        return type == this.tank.getTankType() ? (long)(this.tank.getMaxFill() - this.tank.getFill()) : 0L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tank.getFill() == 0 && !this.hasExploded) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        this.tank.writeToNBT(data, "tank");
        data.func_74777_a("mode", this.mode);
        data.func_74757_a("hasExploded", this.hasExploded);
        data.func_74757_a("onFire", this.onFire);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.tank.readFromNBT(data, "tank");
        this.mode = data.func_74765_d("mode");
        this.hasExploded = data.func_74767_n("hasExploded");
        this.onFire = data.func_74767_n("onFire");
    }

    @Override
    public boolean canConnect(FluidType fluid, ForgeDirection dir) {
        return true;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        FluidTank[] fluidTankArray;
        if (this.hasExploded) {
            return new FluidTank[0];
        }
        if (this.mode == 1 || this.mode == 2) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        FluidTank[] fluidTankArray;
        if (this.hasExploded) {
            return new FluidTank[0];
        }
        if (this.mode == 0 || this.mode == 1) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
        return this.mode == 1 ? IEnergyReceiverMK2.ConnectionPriority.LOW : IEnergyReceiverMK2.ConnectionPriority.NORMAL;
    }

    @Override
    public int[] getFluidIDToCopy() {
        return new int[]{this.tank.getTankType().getID()};
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineFluidTank(player.field_71071_by, (TileEntityMachineFluidTank)world.func_147438_o(x, y, z));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineFluidTank(player.field_71071_by, (TileEntityMachineFluidTank)world.func_147438_o(x, y, z));
    }

    @Override
    public boolean isDamaged() {
        return this.hasExploded;
    }

    @Override
    public List<RecipesCommon.AStack> getRepairMaterials() {
        if (!this.repair.isEmpty()) {
            return this.repair;
        }
        this.repair.add(new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6));
        return this.repair;
    }

    @Override
    public void repair() {
        this.hasExploded = false;
        this.markChanged();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fluid_tank";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluidStored(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxStored(Context context, Arguments args) {
        return new Object[]{this.tank.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypeStored(Context context, Arguments args) {
        return new Object[]{this.tank.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill(), this.tank.getTankType().getName()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluidStored", "getMaxStored", "getTypeStored", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluidStored": {
                return this.getFluidStored(context, args);
            }
            case "getMaxStored": {
                return this.getMaxStored(context, args);
            }
            case "getTypeStored": {
                return this.getTypeStored(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:type", "VAL:fill", "VAL:fillpercent", "FUN:setmode!mode", "FUN:setmode!mode:fallback"};
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:type".equals(name)) {
            return this.tank.getTankType().getName();
        }
        if ("VAL:fill".equals(name)) {
            return "" + this.tank.getFill();
        }
        if ("VAL:fillpercent".equals(name)) {
            return "" + this.tank.getFill() * 100 / this.tank.getMaxFill();
        }
        return null;
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if ("FUN:setmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.mode) {
                this.mode = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.mode = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        return null;
    }
}

