/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerOrbitalStationComputer;
import com.hbm.inventory.gui.GUIOrbitalStationComputer;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityOrbitalStationComputer
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver {
    public boolean hasDrive;
    AxisAlignedBB bb = null;

    public TileEntityOrbitalStationComputer() {
        super(1);
    }

    public boolean travelTo(CelestialBody body, ItemStack drive) {
        OrbitalStation station = OrbitalStation.getStationFromPosition(this.field_145851_c, this.field_145849_e);
        if (station.orbiting == body) {
            return false;
        }
        station.travelTo(this.field_145850_b, body);
        this.slots[0] = drive;
        this.markChanged();
        return true;
    }

    public boolean isTravelling() {
        OrbitalStation station = OrbitalStation.getStationFromPosition(this.field_145851_c, this.field_145849_e);
        return station.state != OrbitalStation.StationState.ORBIT;
    }

    @Override
    public String getName() {
        return "container.orbitalStationComputer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.hasDrive = this.slots[0] != null;
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.hasDrive);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.hasDrive = buf.readBoolean();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOrbitalStationComputer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIOrbitalStationComputer(this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return true;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        OrbitalStation station;
        if (data.func_74764_b("name")) {
            station = OrbitalStation.getStationFromPosition(this.field_145851_c, this.field_145849_e);
            station.name = data.func_74779_i("name");
        }
        if (data.func_74764_b("gravity")) {
            station = OrbitalStation.getStationFromPosition(this.field_145851_c, this.field_145849_e);
            station.gravityMultiplier = data.func_74767_n("gravity") ? 1.0f : 0.0f;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }
}

