/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachinePUREX;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachinePUREX;
import com.hbm.inventory.recipes.PUREXRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.module.machine.ModuleMachinePUREX;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMachinePUREX
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver,
IGUIProvider {
    public FluidTank[] inputTanks;
    public FluidTank[] outputTanks;
    public long power;
    public long maxPower = 1000000L;
    public boolean didProcess = false;
    public boolean frame = false;
    public int anim;
    public int prevAnim;
    public ModuleMachinePUREX purexModule;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    AxisAlignedBB bb = null;

    public TileEntityMachinePUREX() {
        super(13);
        this.inputTanks = new FluidTank[3];
        this.outputTanks = new FluidTank[1];
        for (int i = 0; i < 3; ++i) {
            this.inputTanks[i] = new FluidTank(Fluids.NONE, 24000);
        }
        this.outputTanks[0] = new FluidTank(Fluids.NONE, 24000);
        this.purexModule = new ModuleMachinePUREX(0, this, this.slots).itemInput(4).itemOutput(7).fluidInput(this.inputTanks[0], this.inputTanks[1], this.inputTanks[2]).fluidOutput(this.outputTanks[0]);
    }

    @Override
    public String getName() {
        return "container.machinePUREX";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 1000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            GenericRecipe recipe = (GenericRecipe)PUREXRecipes.INSTANCE.recipeNameMap.get(this.purexModule.recipe);
            if (recipe != null) {
                this.maxPower = recipe.power * 100L;
            }
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 1000000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 2, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                for (FluidTank tank : this.inputTanks) {
                    if (tank.getTankType() == Fluids.NONE) continue;
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, pos);
                }
                for (FluidTank tank : this.outputTanks) {
                    if (tank.getFill() <= 0) continue;
                    this.tryProvide(tank, this.field_145850_b, pos);
                }
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            this.purexModule.update(speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3), pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0, true, this.slots[1]);
            this.didProcess = this.purexModule.didProcess;
            if (this.purexModule.markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(100);
        } else {
            this.prevAnim = this.anim++;
            if (this.didProcess) {
                // empty if block
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e);
            }
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 2, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 2, Library.POS_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 2, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 2, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.serialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.serialize(buf);
        }
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeBoolean(this.didProcess);
        this.purexModule.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.deserialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.deserialize(buf);
        }
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.didProcess = buf.readBoolean();
        this.purexModule.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.inputTanks[i].readFromNBT(nbt, "i" + i);
        }
        this.outputTanks[0].readFromNBT(nbt, "o0");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.purexModule.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.inputTanks[i].writeToNBT(nbt, "i" + i);
        }
        this.outputTanks[0].writeToNBT(nbt, "o0");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        this.purexModule.writeToNBT(nbt);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (slot == 1 && stack.func_77973_b() == ModItems.blueprints) {
            return true;
        }
        if (slot >= 2 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        return this.purexModule.isItemValid(slot, stack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 7 && i <= 12 || this.purexModule.isSlotClogged(i);
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.inputTanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.outputTanks;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.inputTanks[0], this.inputTanks[1], this.inputTanks[2], this.outputTanks[0]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachinePUREX(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachinePUREX(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index == 0) {
                this.purexModule.recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_purex));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

