/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerMachineLargeTurbine;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.inventory.gui.GUIMachineLargeTurbine;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineLargeTurbine
extends TileEntityMachineBase
implements IEnergyProviderMK2,
IFluidStandardTransceiver,
IGUIProvider,
SimpleComponent,
IInfoProviderEC,
CompatHandler.OCComponent,
IConfigurableMachine,
IFluidCopiable {
    public long power;
    public FluidTank[] tanks;
    protected double[] info = new double[3];
    private boolean shouldTurn;
    public float rotor;
    public float lastRotor;
    public float fanAcceleration = 0.0f;
    private AudioWrapper audio;
    private float audioDesync;
    public static long maxPower = 100000000L;
    public static int inputTankSize = 512000;
    public static int outputTankSize = 10240000;
    public static double efficiency = 1.0;
    private boolean operational;

    public TileEntityMachineLargeTurbine() {
        super(7);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.STEAM, inputTankSize);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, outputTankSize);
        Random rand = new Random();
        this.audioDesync = rand.nextFloat() * 0.05f;
    }

    @Override
    public String getConfigName() {
        return "steamturbineIndustrial";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:maxPower", maxPower);
        inputTankSize = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSize);
        outputTankSize = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSize);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:maxPower").value(maxPower);
        writer.name("INFO").value("industrial steam turbine consumes 20% of availible steam per tick");
        writer.name("I:inputTankSize").value((long)inputTankSize);
        writer.name("I:outputTankSize").value((long)outputTankSize);
        writer.name("D:efficiency").value(efficiency);
    }

    @Override
    public String getName() {
        return "container.machineLargeTurbine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            this.info = new double[3];
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * -4, dir.getOpposite());
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[0].loadTank(2, 3, this.slots);
            this.power = Library.chargeItemsFromTE(this.slots, 4, this.power, maxPower);
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE) * efficiency) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = (int)Math.floor(this.tanks[0].getFill() / trait.amountReq);
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int cap = (int)Math.ceil((float)(this.tanks[0].getFill() / trait.amountReq) / 5.0f);
                int ops = Math.min(inputOps, Math.min(outputOps, cap));
                this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                this.power = (long)((double)this.power + (double)(ops * trait.heatEnergy) * eff);
                this.info[0] = ops * trait.amountReq;
                this.info[1] = ops * trait.amountProduced;
                this.info[2] = (double)(ops * trait.heatEnergy) * eff;
                valid = true;
                boolean bl = this.operational = ops > 0;
            }
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            this.tanks[1].unloadTank(5, 6, this.slots);
            this.networkPackNT(50);
        } else {
            this.lastRotor = this.rotor;
            this.rotor += this.fanAcceleration;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
            }
            if (this.shouldTurn) {
                this.fanAcceleration = Math.max(0.0f, Math.min(15.0f, this.fanAcceleration += 0.075f + this.audioDesync));
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.largeTurbineRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
                    this.audio.startSound();
                }
                float turbineSpeed = this.fanAcceleration / 15.0f;
                this.audio.updateVolume(this.getVolume(0.4f * turbineSpeed));
                this.audio.updatePitch(0.25f + 0.75f * turbineSpeed);
            } else {
                this.fanAcceleration = Math.max(0.0f, Math.min(15.0f, this.fanAcceleration -= 0.1f));
                if (this.audio != null) {
                    if (this.fanAcceleration > 0.0f) {
                        float turbineSpeed = this.fanAcceleration / 15.0f;
                        this.audio.updateVolume(this.getVolume(0.4f * turbineSpeed));
                        this.audio.updatePitch(0.25f + 0.75f * turbineSpeed);
                    } else {
                        this.audio.stopSound();
                        this.audio = null;
                    }
                }
            }
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeBoolean(this.operational);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.shouldTurn = buf.readBoolean();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / maxPower;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_turbine";
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Callback(direct=true, doc="function():table -- Gets current tanks state. The format is the following: <input tank amount>, <input tank capacity>, <output tank amount>, <output tank capacity>")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Callback(direct=true, doc="function():number -- Gets the current input tank fluid type. 0 stands for steam, 1 for dense steam, 2 for super dense steam and 3 for ultra dense steam.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        return CompatHandler.steamTypeToInt(this.tanks[0].getTankType());
    }

    @Callback(direct=true, limit=4, doc="function(type:number) -- Sets the input tank fluid type. Refer getType() for the accepted values information.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setType(Context context, Arguments args) {
        this.tanks[0].setTankType(CompatHandler.intToSteamType(args.checkInteger(0)));
        return new Object[0];
    }

    @Callback(direct=true, doc="function():number -- Gets the power buffer of the turbine.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(direct=true, doc="function():table -- Gets information about this turbine. The format is the following: <input tank amount>, <input tank capacity>, <output tank amount>, <output tank capacity>, <input tank fluid type>, <power>")
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), CompatHandler.steamTypeToInt(this.tanks[0].getTankType())[0], this.power};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluid", "getType", "setType", "getPower", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getType": {
                return this.getType(context, args);
            }
            case "setType": {
                return this.setType(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineLargeTurbine(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineLargeTurbine(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.info[1] > 0.0);
        data.func_74780_a("consumption", this.info[0]);
        data.func_74780_a("outputmb", this.info[1]);
        data.func_74780_a("output", this.info[2]);
    }
}

