/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata.satellites;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_War;
import com.hbm.main.ResourceManager;
import com.hbm.render.util.BeamPronter;
import com.hbm.saveddata.satellites.SatelliteWar;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SatelliteRailgun
extends SatelliteWar {
    private static final ResourceLocation texture = new ResourceLocation("hbm:textures/particle/shockwave.png");
    private static final ResourceLocation flash = new ResourceLocation("hbm:textures/misc/space/flare.png");
    private boolean canFire = false;
    private boolean hasTarget = false;
    public long lastOp;
    public float interp;
    public int cooldown;
    private CelestialBody target;

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("lastOp", this.lastOp);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.lastOp = nbt.func_74763_f("lastOp");
    }

    @Override
    public void onClick(World world, int x, int z) {
        this.fireAtTarget(this.target);
        this.canFire = this.hasTarget;
    }

    @Override
    public void fire() {
        if (this.canFire) {
            this.interp += 0.5f;
            this.interp = Math.min(100.0f, this.interp + 0.3f * (100.0f - this.interp) * 0.15f);
            if (this.interp >= 100.0f) {
                this.interp = 0.0f;
                this.canFire = false;
            }
        }
    }

    @Override
    public void setTarget(CelestialBody body) {
        this.target = CelestialBody.getBody(body.dimensionId);
        if (this.target != null) {
            this.hasTarget = true;
        }
    }

    @Override
    public void fireAtTarget(CelestialBody body) {
        if (this.hasTarget) {
            if (!this.target.hasTrait(CBT_War.class)) {
                this.target.modifyTraits(new CBT_War(100, 0));
            } else {
                CBT_War war = this.target.getTrait(CBT_War.class);
                if (war != null) {
                    float rand = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat();
                    CBT_War.Projectile projectile = new CBT_War.Projectile(100.0f, 20, 50, 28.0f * rand * 5.0f, 55.0, 20.0, CBT_War.ProjectileType.SMALL, body.dimensionId);
                    projectile.GUIangle = (int)(rand * 360.0f);
                    war.launchProjectile(projectile);
                    System.out.println(war.health);
                }
            }
        }
    }

    @Override
    public void playsound() {
        Minecraft.func_71410_x().field_71439_g.func_85030_a("hbm:misc.fireflash", 10.0f, 1.0f);
    }

    @Override
    protected float[] getColor() {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    @Override
    public float getInterp() {
        return this.interp;
    }

    @Override
    public int magSize() {
        return 0;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeFloat(this.interp);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.interp = buf.readFloat();
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc, float solarAngle, long id) {
        GL11.glPushMatrix();
        GL11.glScaled((double)5.0, (double)5.0, (double)5.0);
        double rounded = Math.round((double)id / 1000.0);
        double x = (id % 10L - 5L) * 2L;
        double y = (id / 10L % 10L - 5L) * 2L;
        double xPos = Math.min(Math.max(-rounded + 30.0 + x, -50.0), 50.0);
        double yPos = Math.min(Math.max(-rounded - 20.0 + y, -50.0), 50.0);
        GL11.glTranslated((double)xPos, (double)yPos, (double)20.0);
        float fuck = this.getInterp();
        float alped = 1.0f - Math.min(1.0f, fuck / 100.0f);
        GL11.glPushMatrix();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alped);
        GL11.glTranslated((double)1.0, (double)5.5, (double)0.0);
        GL11.glScaled((double)((double)fuck * 0.2), (double)((double)fuck * 0.2), (double)((double)fuck * 0.2));
        mc.field_71446_o.func_110577_a(flash);
        ResourceManager.plane.renderAll();
        mc.field_71446_o.func_110577_a(texture);
        ResourceManager.plane.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)1.0, (double)5.5, (double)0.0);
        BeamPronter.prontBeam(Vec3.func_72443_a((double)0.0, (double)(fuck * 2.0f), (double)0.0), BeamPronter.EnumWaveType.SPIRAL, BeamPronter.EnumBeamType.SOLID, 0x202060, 0x202060, 0, 1, 0.0f, 6, 1.9200001f * alped, alped * 0.2f);
        BeamPronter.prontBeam(Vec3.func_72443_a((double)0.0, (double)(fuck * 2.0f), (double)0.0), BeamPronter.EnumWaveType.SPIRAL, BeamPronter.EnumBeamType.SOLID, 0x202060, 0x202060, 0, 1, 0.0f, 6, 0.42000002f, alped * 0.6f);
        BeamPronter.prontBeam(Vec3.func_72443_a((double)0.0, (double)(fuck * 2.0f), (double)0.0), BeamPronter.EnumWaveType.RANDOM, BeamPronter.EnumBeamType.SOLID, 0x202060, 0x202060, (int)(world.func_82737_E() / 5L) % 1000, 35, 0.2f, 6, 0.020000001f, alped);
        GL11.glClear((int)256);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glDepthRange((double)0.0, (double)1.0);
        mc.field_71446_o.func_110577_a(ResourceManager.sat_rail_tex);
        ResourceManager.sat_rail.renderAll();
        GL11.glClear((int)256);
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
    }
}

