/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderMinigun
extends ItemRenderWeaponBase {
    protected ResourceLocation texture;

    public ItemRenderMinigun(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderMinigun.standardAimingTransform(stack, -1.75f * offset, -1.75f * offset, 3.5f * offset, 0.0, -0.78125, 1.0);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] rotate = HbmAnimations.getRelevantTransformation("ROTATE");
        GL11.glTranslated((double)0.0, (double)3.0, (double)-6.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-3.0, (double)6.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glShadeModel((int)7425);
        ResourceManager.minigun.renderPart("Gun");
        ResourceManager.minigun.renderPart("Grip");
        GL11.glPushMatrix();
        GL11.glRotated((double)rotate[2], (double)0.0, (double)0.0, (double)1.0);
        ResourceManager.minigun.renderPart("Barrels");
        GL11.glPopMatrix();
        double smokeScale = 0.5;
        GL11.glPushMatrix();
        GL11.glTranslated((double)-2.0, (double)1.25, (double)-3.5);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
        ItemRenderMinigun.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.5);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)12.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        if (stack.func_77973_b() == ModItems.gun_minigun_lacunae) {
            ItemRenderMinigun.renderLaserFlash(gun.lastShot[0], 50, 1.0, 0xFF00FF);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.25);
            ItemRenderMinigun.renderLaserFlash(gun.lastShot[0], 50, 0.5, 0xFF0080);
        } else {
            GL11.glRotated((double)(gun.shotRand * 90.0), (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
            ItemRenderMinigun.renderMuzzleFlash(gun.lastShot[0], 75, 5.0);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)1.0, (double)-3.5, (double)8.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 0.875;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.25, (double)0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -6.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ResourceManager.minigun.renderPart("Gun");
        ResourceManager.minigun.renderPart("Grip");
        ResourceManager.minigun.renderPart("Barrels");
        GL11.glShadeModel((int)7424);
    }
}

